/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proformatter;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.raptor.proformatter.ICodingStyleSQLOptions;
import oracle.dbtools.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FormatHelper {
    public static final int UNKNOWNINT = -1;
    public static final String ORACLE = "Oracle";
    public static final int ORACLEINT = 1;
    public static final String DB2 = "DB2";
    public static final int DB2INT = 2;
    public static final String SYBASE = "Sybase";
    public static final int SYBASEINT = 3;
    public static final String ACCESS = "Microsoft Access";
    public static final int ACCESSINT = 4;
    public static final String SQLSERVER = "Microsoft SQL Server";
    public static final int SQLSERVERINT = 5;
    public static final String MYSQL = "MySQL";
    public static final int MYSQLINT = 6;
    private static URL u;
    private static boolean fail;

    public static boolean loadFromXML(ICodingStyleSQLOptions cb, URL url) {
        u = url;
        return FormatHelper.loadFromXML(cb);
    }

    public static boolean loadFromXML(ICodingStyleSQLOptions cb) {
        String fname = System.getenv("SQLFORMATPATH");
        if (fname == null && u != null) {
            return FormatHelper.populateBean(u, (Object)cb, "Item");
        }
        if (!new File(fname).exists() && u != null) {
            return FormatHelper.populateBean(u, (Object)cb, "Item");
        }
        return false;
    }

    public static boolean populateBean(String fname, Object cb, String item) {
        File f = new File(fname);
        try {
            return FormatHelper.populateBean(f.toURI().toURL(), cb, item);
        }
        catch (MalformedURLException e) {
            Logger.fine(FormatHelper.class, e.getLocalizedMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean populateBean(URL u, Object cb, String item) {
        Exception x;
        fail = false;
        Method[] methArray = cb.getClass().getDeclaredMethods();
        HashMap<String, Method> hm = new HashMap<String, Method>();
        boolean xi = false;
        for (Method m : methArray) {
            String name = m.getName();
            if (!name.startsWith("set")) continue;
            hm.put(name, m);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Exception t = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(u.openStream());
            NodeList nl = document.getElementsByTagName(item);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                Node nlkeyvalue = null;
                Node nlvalue = null;
                NodeList nk = n.getChildNodes();
                for (int ij = 0; ij < nl.getLength(); ++ij) {
                    Node nn = nk.item(ij);
                    if (nn.getNodeName().equals("Key")) {
                        nlkeyvalue = nn;
                    }
                    if (!nn.getNodeName().equals("Value")) continue;
                    nlvalue = nn;
                    break;
                }
                if (nlkeyvalue == null || nlvalue == null || nlkeyvalue.getFirstChild() == null || nlkeyvalue.getFirstChild().getNodeValue() == null || !nlkeyvalue.getFirstChild().getNodeValue().equals("1:SQL")) continue;
                Node nlc = nlvalue;
                NodeList children = nlc.getChildNodes();
                for (int ii = 0; ii < children.getLength(); ++ii) {
                    try {
                        String name = children.item(ii).getNodeName();
                        String methName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
                        Method theM = null;
                        if (methName.equals("set#text") || methName.equals("setMemberOrderHashStructure")) continue;
                        theM = (Method)hm.get(methName);
                        if (theM == null) {
                            Logger.info(new FormatHelper().getClass(), "the method: " + methName + " does not exist");
                            continue;
                        }
                        String value = children.item(ii).getChildNodes().item(0).getNodeValue();
                        if (name.equals("name")) {
                            theM.invoke(cb, value);
                            hm.remove(methName);
                            continue;
                        }
                        if (value == null || value.equals("")) continue;
                        if (value.equals("true")) {
                            theM.invoke(cb, true);
                            hm.remove(methName);
                            continue;
                        }
                        if (value.equals("false")) {
                            theM.invoke(cb, false);
                            hm.remove(methName);
                            continue;
                        }
                        theM.invoke(cb, Integer.parseInt(value));
                        hm.remove(methName);
                        continue;
                    }
                    catch (IllegalAccessException iae) {
                        t = iae;
                        continue;
                    }
                    catch (InvocationTargetException iae) {
                        t = iae;
                        continue;
                    }
                    finally {
                        if (t != null) {
                            Logger.fine(new FormatHelper().getClass(), t);
                            fail = true;
                        }
                    }
                }
                Iterator sti = hm.keySet().iterator();
                while (sti.hasNext()) {
                    Logger.info(new FormatHelper().getClass(), "Method " + (String)sti.next() + "has not been matched");
                }
            }
        }
        catch (SAXParseException spe) {
            x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            Logger.fine(new FormatHelper().getClass(), "\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId() + "  " + spe.getMessage() + x.getMessage());
            fail = true;
        }
        catch (SAXException sxe) {
            x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            t = x;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            t = ioe;
        }
        finally {
            if (t != null) {
                Logger.fine(new FormatHelper().getClass(), t);
                fail = true;
            }
        }
        return fail;
    }

    public static final String dbToFormatter(int db) {
        if (db == 1) {
            return ORACLE;
        }
        if (db == 2) {
            return "DB2/UDB";
        }
        if (db == 3) {
            return SYBASE;
        }
        if (db == 4) {
            return "MSAccess";
        }
        if (db == 5) {
            return "SQL Server";
        }
        if (db == 6) {
            return "MYSQL";
        }
        return "Any SQL";
    }

    static {
        fail = false;
    }
}

