/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.AccessCache;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Messages;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.query.db.QueryDB;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.jdbc.OracleDriver;
import oracle.sql.Datum;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QueryUtils {
    private static Logger LOGGER = Logger.getLogger(QueryUtils.class.getName());
    private static Map<ConnectionIdentifier, Map<String, Boolean>> connection2objectDba = new HashMap<ConnectionIdentifier, Map<String, Boolean>>();
    private static final String DBA_PREFIX = "DBA_";

    public static List<Bind> getNodeBinds(Node node) {
        return QueryUtils.getNodeBinds(node, "binds", null);
    }

    public static List<Bind> getNodeBinds(Node node, XLIFFHelper xliffHelper) {
        return QueryUtils.getNodeBinds(node, "binds", xliffHelper);
    }

    public static List<Bind> getNodeBinds(Node node, String path, XLIFFHelper xliffHelper) {
        XMLNode[] children;
        ArrayList<Bind> binds = new ArrayList<Bind>();
        Node bindsNode = XMLHelper.getChildNode(node, path);
        if (bindsNode == null) {
            return binds;
        }
        for (XMLNode child : children = XMLHelper.getChildNodes(bindsNode, "bind")) {
            String name = XMLHelper.getAttributeNode((Node)child, "id");
            String type = XMLHelper.getNodeValue((Node)child, "type");
            String prompt = XMLHelper.getNodeValue((Node)child, "prompt");
            String value = XMLHelper.getNodeValue((Node)child, "value");
            String tooltip = XMLHelper.getNodeValue((Node)child, "tooltip");
            if (xliffHelper != null) {
                prompt = xliffHelper.getTranslation(prompt);
                tooltip = xliffHelper.getTranslation(tooltip);
            }
            Bind oBind = new Bind(name, type, prompt, value, tooltip);
            oBind.setSortable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)child, "sortable")));
            oBind.setFilterable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)child, "filterable")));
            binds.add(oBind);
        }
        return binds;
    }

    public static Query getQuery(Node node) {
        return QueryUtils.getQuery(node, null, null);
    }

    public static Query getQuery(Node node, XLIFFHelper xliffHelper) {
        return QueryUtils.getQuery(node, xliffHelper, null);
    }

    public static Query getQuery(Node node, XLIFFHelper xliffHelper, ClassLoader cl) {
        String md = null;
        try {
            md = new String(MessageDigest.getInstance("SHA").digest(node.getTextContent().getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        Query ret = null;
        if (!QueryDB.getDatabase().containsChecksum(md)) {
            String id;
            String refId = XMLHelper.getAttributeNode(node, "sharedId");
            if (refId != null && !refId.equals("")) {
                ret = QueryCache.getQuery(refId);
            }
            if ((id = XMLHelper.getAttributeNode(node, "id")) != null && !id.equals("") && (ret = QueryCache.getQuery(id)) != null) {
                ret.buildQuery(node, xliffHelper, null);
            }
            if (ret == null) {
                ret = new Query(node, xliffHelper, cl);
            }
        } else {
            ret = new Query(node, xliffHelper);
        }
        return ret;
    }

    public static List<Column> getNodeCols(Node node) {
        return QueryUtils.getNodeCols(node, null);
    }

    public static List<Column> getNodeCols(Node node, ClassLoader cl) {
        XMLNode[] children;
        ArrayList<Column> cols = new ArrayList<Column>();
        Node colsNode = XMLHelper.getChildNode(node, "columns");
        if (colsNode == null) {
            return cols;
        }
        for (XMLNode child : children = XMLHelper.getChildNodes(colsNode, "column")) {
            String name = XMLHelper.getNodeValue((Node)child, "colName");
            if (name != null) {
                name = name.trim();
            }
            if (!ModelUtil.hasLength(name)) continue;
            String align = XMLHelper.getAttributeNode((Node)child, "align");
            String vAlign = XMLHelper.getAttributeNode((Node)child, "valign");
            String format = XMLHelper.getAttributeNode((Node)child, "colFormat");
            Column oCol = new Column(name, align, vAlign, format);
            oCol.setType(XMLHelper.getNodeValue((Node)child, "type"));
            oCol.setID(XMLHelper.getAttributeNode((Node)child, "id"));
            oCol.setSortable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)child, "sortable")));
            oCol.setFilterable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)child, "filterable")));
            oCol.setDefaultFilter(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)child, "defaultFilter")));
            oCol.setEditable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)child, "isEditable")));
            oCol.setHidden(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)child, "hidden")));
            oCol.setCellEditor(XMLHelper.getAttributeNode((Node)child, "cellEditor"));
            oCol.setCellRenderer(XMLHelper.getAttributeNode((Node)child, "cellRenderer"));
            oCol.setCellPopup(XMLHelper.getAttributeNode((Node)child, "cellPopup"));
            oCol.setClassLoader(cl);
            cols.add(oCol);
        }
        return cols;
    }

    public static List<Query> getQueries(Node node) {
        return QueryUtils.getQueries(node, null);
    }

    public static List<Query> getQueries(Node node, ClassLoader cl) {
        List<Object> ret = null;
        if (node != null) {
            String shareId = XMLHelper.getAttributeNode(node, "sharedId");
            if (shareId != null && !shareId.equals("")) {
                ret = QueryCache.getQueries(shareId);
            }
            if (ret == null) {
                XMLNode[] children;
                ret = new ArrayList();
                for (XMLNode child : children = XMLHelper.getChildNodes(node, "query")) {
                    Query query = Query.getQuery((Node)child, null, cl);
                    ret.add(query);
                }
                List<Bind> globalBinds = QueryUtils.getNodeBinds(node);
                List<Column> globalCols = QueryUtils.getNodeCols(node);
                List<Bind> globalOptionalBinds = QueryUtils.getNodeBinds(node, "optionalBinds", null);
                for (Query query : ret) {
                    for (Bind b : globalBinds) {
                        query.addBind(b);
                    }
                    for (Column c : globalCols) {
                        query.addColumn(c);
                    }
                    for (Bind b : globalOptionalBinds) {
                        query.addOptionalBind(b);
                    }
                }
                String id = XMLHelper.getAttributeNode(node, "id");
                if (id != null && !id.equals("")) {
                    QueryCache.putQuery(id, ret);
                }
            }
        }
        return ret;
    }

    public static Query getQuery(List<Query> queries, ConnectionIdentifier id) {
        return QueryUtils.getQuery(queries, id, false, false, false);
    }

    public static Query promoteToDba(Query input, ConnectionIdentifier id) {
        LinkedList<Query> tmp = new LinkedList<Query>();
        tmp.add(input);
        QueryUtils.prependDbaVersion(tmp);
        return QueryUtils.getQuery(tmp, id, true, false, false);
    }

    public static String promoteToDba(String sql, ConnectionIdentifier id) {
        boolean matchesAllUser;
        Map<String, Boolean> knownObjects = connection2objectDba.get(id);
        if (knownObjects == null) {
            knownObjects = new HashMap<String, Boolean>();
            connection2objectDba.put(id, knownObjects);
        }
        if (matchesAllUser = QueryUtils.matchesAnyPrefix(sql, new String[]{"all_", "user_"})) {
            List<LexerToken> src = Query.lex(sql);
            ParseNode root = Query.parse(src);
            Map<Integer, String> tabAtPos = Query.getAllTablePos(root, src);
            if (tabAtPos.size() == 0) {
                return null;
            }
            String ret = sql;
            for (Integer p : tabAtPos.keySet()) {
                String dbao = DBA_PREFIX + tabAtPos.get(p).substring(DBA_PREFIX.length());
                Boolean hasAccess = knownObjects.get(dbao);
                if (hasAccess == null) {
                    Connection conn = id.getConnection();
                    try (Statement stmt = conn.createStatement();){
                        String tmp = "select 1 from " + dbao + " where 1=2";
                        stmt.execute(tmp);
                        hasAccess = true;
                    }
                    catch (SQLException e) {
                        hasAccess = false;
                    }
                    knownObjects.put(dbao, hasAccess);
                }
                if (!hasAccess.booleanValue()) continue;
                ret = ret.substring(0, p) + DBA_PREFIX + ret.substring(p + DBA_PREFIX.length());
            }
            if (ret.toLowerCase().contains("dba_tab_privs") || ret.toLowerCase().contains("dba_col_privs")) {
                ret = ret.replace("table_schema", "OwNeR");
            }
            return ret;
        }
        return sql;
    }

    public static Query getQuery(List<Query> queries, ConnectionIdentifier id, boolean prependDbaVersion, boolean cacheOnlyCheck) {
        return QueryUtils.getQuery(queries, id, prependDbaVersion, cacheOnlyCheck, false);
    }

    public static Query getQuery(List<Query> queries, ConnectionIdentifier id, boolean prependDbaVersion, boolean cacheOnlyCheck, boolean skipAccessCache) {
        ArrayList<Query> validForVersion = new ArrayList<Query>();
        for (Query q : queries) {
            if (!QueryUtils.hasRequiredFeatures(id, q.getRequiredFeatures()) || !VersionTracker.checkVersion(id, q.getMaxversion(), q.getMinversion())) continue;
            List check = (List)validForVersion.clone();
            VersionComp comp = new VersionComp();
            for (Query q1 : check) {
                if (comp.compare(q.getMinversion(), q1.getMinversion()) > 0) {
                    validForVersion.remove(q1);
                    if (validForVersion.contains(q)) continue;
                    validForVersion.add(q);
                    continue;
                }
                if (comp.compare(q.getMinversion(), q1.getMinversion()) != 0) continue;
                if (q.getRequiredObjects() != null) {
                    if (validForVersion.size() <= 0 || validForVersion.get(0) == q) continue;
                    validForVersion.add(0, q);
                    continue;
                }
                validForVersion.add(q);
            }
            if (validForVersion.size() != 0) continue;
            validForVersion.add(q);
        }
        boolean isTimesTen = false;
        Connection conn = id.getConnection();
        if (!ConnectionResolver.isOracle(conn)) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                String database = dbmd.getDatabaseProductName();
                if (database.indexOf("TimesTen") != -1) {
                    isTimesTen = true;
                }
            }
            catch (Exception dbmd) {
                // empty catch block
            }
        }
        if ((prependDbaVersion || QueryUtils.calledfromObjectViewer()) && !isTimesTen) {
            QueryUtils.prependDbaVersion(validForVersion);
        }
        if (validForVersion.size() == 1 && (validForVersion.get(0).getRequiredObjects() == null || validForVersion.get(0).getRequiredObjects().size() == 0)) {
            return validForVersion.get(0);
        }
        Query ret = null;
        ret = QueryUtils.checkNonOracleAccess(id, validForVersion, cacheOnlyCheck, skipAccessCache);
        return ret;
    }

    public static boolean hasRequiredFeatures(ConnectionIdentifier id, String[] reqFeatures) {
        if (reqFeatures != null) {
            for (String feature : reqFeatures) {
                if (QueryUtils.hasRequiredFeature(id, feature)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hasRequiredFeature(ConnectionIdentifier id, String feature) {
        boolean invert = (feature = feature.trim()).startsWith("!");
        if (invert) {
            feature = feature.substring(1);
        }
        return feature.length() == 0 || invert ^ DatabaseFeatureRegistry.isFeatureEnabled(id, feature);
    }

    private static boolean hasDBAQuery(Query q) {
        Set<String> reqs = q.getRequiredObjects();
        if (reqs != null) {
            for (String req : reqs) {
                int idx = req.indexOf(46);
                if (idx > 0) {
                    req = req.substring(idx + 1);
                }
                if (req.length() <= DBA_PREFIX.length() || !req.substring(0, DBA_PREFIX.length()).equalsIgnoreCase(DBA_PREFIX)) continue;
                return true;
            }
        }
        return false;
    }

    private static void prependDbaVersion(List<Query> validForVersion) {
        boolean hasDbaVersion = false;
        for (Query q : validForVersion) {
            if (!QueryUtils.hasDBAQuery(q)) continue;
            hasDbaVersion = true;
            break;
        }
        if (!hasDbaVersion) {
            LinkedList<Query> addendum = new LinkedList<Query>();
            for (Query q : validForVersion) {
                Query dbaVersion;
                String sql = q.getSql();
                if (sql == null) continue;
                boolean matchesAllUser = QueryUtils.matchesAnyPrefix(sql, new String[]{"all_", "user_"});
                boolean matchesColPrivs = QueryUtils.matchesAnyPostfix(sql, new String[]{"col_privs"});
                if (!matchesAllUser || matchesColPrivs || (dbaVersion = q.dbaVersion()) == null) continue;
                addendum.add(dbaVersion);
            }
            validForVersion.addAll(0, addendum);
        }
    }

    private static boolean matchesAnyPrefix(String input, String[] prefixes) {
        List<LexerToken> src = LexerToken.parse(input);
        for (LexerToken t : src) {
            if (t.type != Token.IDENTIFIER && t.type != Token.DQUOTED_STRING) continue;
            String cmp = t.content.toUpperCase();
            for (String pref : prefixes) {
                if (cmp.startsWith(pref.toUpperCase())) {
                    return true;
                }
                if ('\"' != cmp.charAt(0) || !t.content.substring(1).startsWith(pref.toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchesAnyPostfix(String input, String[] prefixes) {
        List<LexerToken> src = LexerToken.parse(input);
        for (LexerToken t : src) {
            String cmp = t.content.toUpperCase();
            for (String pref : prefixes) {
                if (!cmp.endsWith(pref.toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean calledfromObjectViewer() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean ret = false;
        for (StackTraceElement e : stackTrace) {
            String line = e.toString();
            if (line.contains("oviewer")) {
                ret = true;
            }
            if (!line.contains("ViewerEditorAddin.getEditorWeight")) continue;
            return false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Query checkNonOracleAccess(ConnectionIdentifier id, ArrayList<Query> validForVersion, boolean cacheOnlyCheck, boolean skipAccessCache) {
        if (validForVersion.size() == 0) {
            return null;
        }
        Query ret = null;
        Connection conn = id.getConnection();
        if (conn == null) {
            return validForVersion.get(0);
        }
        boolean lock = false;
        if (!cacheOnlyCheck) {
            lock = LockManager.lock(conn);
        }
        if (cacheOnlyCheck || lock) {
            try {
                DBUtil dbUtil = DBUtil.getInstance(conn);
                for (Query q : validForVersion) {
                    Set<String> reqObjs = q.getRequiredObjects();
                    if (reqObjs != null) {
                        boolean ok = true;
                        block9: for (String s : reqObjs) {
                            boolean skipCache = false;
                            String objName = s;
                            if (s.startsWith("NOCACHE:")) {
                                skipCache = true;
                                objName = s.replace("NOCACHE:", "");
                            }
                            if (cacheOnlyCheck && !skipCache) {
                                switch (AccessCache.hasAccessCached(id, objName)) {
                                    case TRUE: {
                                        ok = true;
                                        continue block9;
                                    }
                                    case FALSE: {
                                        ok = false;
                                        continue block9;
                                    }
                                }
                                Query query = null;
                                return query;
                            }
                            if (skipAccessCache || skipCache) {
                                if (DBUtil.getInstance(id.getConnection()).checkAccess(objName)) continue;
                                ok = false;
                                break;
                            }
                            if (AccessCache.hasAccess(id, objName)) continue;
                            ok = false;
                            break;
                        }
                        if (!ok) continue;
                        ret = q;
                        break;
                    }
                    if (ret != null) continue;
                    ret = q;
                }
            }
            finally {
                if (lock) {
                    LockManager.unlock(conn);
                }
            }
        }
        return ret;
    }

    public static void loadFile(String s, BufferedOutputStream out) {
        DOMParser parser = new DOMParser();
        parser.setPreserveWhitespace(false);
        try {
            File f;
            InputStream in = QueryUtils.class.getResourceAsStream(s.trim());
            if (in == null && (f = new File(s.trim())).exists()) {
                in = new FileInputStream(f);
            }
            parser.parse(in);
            XMLDocument document = parser.getDocument();
            NodeList nl = document.selectNodes("//query");
            for (int i = 0; i < nl.getLength(); ++i) {
                XMLElement el = (XMLElement)nl.item(i);
                if (el.getAttribute("id") == null || el.getAttribute("id").equals("")) continue;
                LOGGER.info(Messages.getString("QueryUtils.36") + el.getNodeName() + ":" + el.getAttribute("id") + "\n");
                try {
                    out.write((Messages.getString("QueryUtils.40") + el.getAttribute("id") + "\n").getBytes());
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.43"), e);
                }
                QueryUtils.getQuery((Node)el);
            }
        }
        catch (XMLParseException e) {
            LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.44"), e);
        }
        catch (SAXException e) {
            LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.45"), e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.46"), e);
        }
        catch (XSLException e) {
            LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.47"), e);
        }
    }

    public static String expandQuery(String sql, Map<String, Object> subs) {
        String ret = sql;
        if (subs != null) {
            for (String val : subs.keySet()) {
                if (ret.toUpperCase().indexOf("#" + val.toUpperCase() + "#") <= 0) continue;
                ret = QueryUtils.subHashMark(ret, val, subs.get(val));
            }
        }
        return ret;
    }

    private static String subHashMark(String s, String name, Object realValue) {
        Object value = realValue;
        if (realValue == null) {
            value = "";
        } else if (realValue instanceof Datum) {
            try {
                value = ((Datum)realValue).stringValue();
            }
            catch (SQLException e) {
                Logger.getLogger(QueryUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        String ret = s;
        StringBuilder sb = new StringBuilder();
        String subVal = null;
        String valString = value.toString();
        if (valString.indexOf(36) > 0) {
            for (int i = 0; i < valString.length(); ++i) {
                if (valString.charAt(i) == '$') {
                    sb.append("\\" + valString.charAt(i));
                    continue;
                }
                sb.append(valString.charAt(i));
            }
            subVal = sb.toString();
        } else {
            subVal = valString;
        }
        try {
            ret = ret.replaceAll("((?i)#" + name + "#)", subVal);
            ret = ret.replaceAll("((?i)#\"" + name + "\"#)", "\"" + subVal + "\"");
            ret = ret.replaceAll("((?i)#," + name + "#)", "".equals(subVal) ? "" : "," + subVal);
            ret = ret.replaceAll("((?i)#,\"" + name + "\"#)", "".equals(subVal) ? "" : ",\"" + subVal + "\"");
            ret = ret.replaceAll("((?i)#esc(" + name + ")#)", "".equals(subVal) ? "" : subVal.replaceAll("'", "''"));
        }
        catch (Exception e) {
            Logger.getLogger(QueryUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection c = DriverManager.getConnection("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521/DB12PERF", "hr", "hr");
        System.out.println(c.toString());
        System.out.println(QueryUtils.promoteToDba("select * from \"ALL_OBJECTS\" where rownum < 10", DefaultConnectionIdentifier.createIdentifier(c)));
        System.out.println(QueryUtils.promoteToDba("select * from \"SYS\".\"ALL_OBJECTS\" where rownum < 3", DefaultConnectionIdentifier.createIdentifier(c)));
        System.out.println(QueryUtils.promoteToDba("select * from aLL_oBjects where rownum < 5", DefaultConnectionIdentifier.createIdentifier(c)));
    }

    private static class VersionComp
    implements Comparator<Version> {
        private VersionComp() {
        }

        @Override
        public int compare(Version v1, Version v2) {
            if (v1 == null) {
                return v2 == null ? 0 : -1;
            }
            return v2 == null ? 1 : v1.compareTo(v2);
        }
    }
}

