/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils.oerr;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import oracle.dbtools.raptor.utils.oerr.OerrArb;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Oerr {
    private SAXParserFactory _factory = null;

    public static void main(String[] args) throws Exception {
        Oerr oerr = new Oerr();
        try {
            oerr.oerr("ORA-0100");
        }
        catch (OerrException oe) {
            System.out.println(oe.getMessage());
        }
        try {
            System.out.println(oerr.oerr("ora", "2082"));
            System.out.println("-ora 2082");
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
        try {
            System.out.println(oerr.oerr("ora", "44004"));
            System.out.println("-ora 44004");
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
        try {
            System.out.println(oerr.oerr("tns", "100"));
            System.out.println("-tns 100");
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
        try {
            System.out.println(oerr.oerr("tns", "100"));
            System.out.println("-tns 100");
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
        try {
            System.out.println(oerr.oerr("xyz", "100"));
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
        System.out.println("-xyz 100");
        try {
            System.out.println(oerr.oerr("tns", "error"));
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
        System.out.println("-tns error");
        try {
            System.out.println(oerr.oerr("ORA-2082"));
            System.out.println("-ORA-2082");
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
        try {
            System.out.println(oerr.oerr("ORA-44004"));
            System.out.println("-ORA-44004");
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
        try {
            System.out.println(oerr.oerr("TNS-0100:"));
            System.out.println("-TNS-0100:");
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
        try {
            System.out.println(oerr.oerr("TNS-0999999"));
            System.out.println("-TNS-0999999");
        }
        catch (OerrException e) {
            System.out.println("Oerr" + e.getMessage());
        }
    }

    public String oerr(String typeAndNum) throws OerrException {
        int minus;
        String retVal = "";
        String baseName = "";
        String errNo = "";
        if (typeAndNum == null) {
            throw new OerrException(OerrArb.getString("OERR_NULL"));
        }
        if ((typeAndNum = typeAndNum.trim()).indexOf("\n") != -1) {
            typeAndNum = typeAndNum.substring(0, typeAndNum.indexOf("\n"));
        }
        if (typeAndNum.indexOf("\r") != -1) {
            typeAndNum = typeAndNum.substring(0, typeAndNum.indexOf("\r"));
        }
        if ((minus = typeAndNum.indexOf(45)) != -1) {
            baseName = typeAndNum.substring(0, minus);
            String rest = typeAndNum.substring(minus);
            if (rest.matches("^-[0-9]+.*")) {
                int i = 0;
                for (i = 1; i < rest.length(); ++i) {
                    if (Character.isDigit(rest.charAt(i))) continue;
                    errNo = rest.substring(1, i);
                    break;
                }
                if (i == rest.length()) {
                    errNo = rest.substring(1);
                }
                retVal = this.oerr(baseName, errNo);
            }
        }
        if (retVal == null || retVal.equals("")) {
            throw new OerrException(OerrArb.getString("NO_VALUE_OERR_STRING"));
        }
        return retVal;
    }

    public String oerr(String baseName, String errNo) throws OerrException {
        String retVal = "";
        try {
            if (baseName == null || errNo == null) {
                throw new OerrException(OerrArb.getString("OERR_NULL"));
            }
            if (!(baseName = baseName.toLowerCase()).equals("tns") && !baseName.equals("ora")) {
                throw new OerrException(OerrArb.getString("ONLY_ORA_TNS"));
            }
            String sequenceFile = this.getIndexFile(baseName, errNo);
            if (sequenceFile != null && sequenceFile != "") {
                retVal = this.outputMatch(sequenceFile, errNo);
            }
            if (retVal == null || retVal.equals("")) {
                throw new OerrException(OerrArb.getString("NO_VALUE_OERR_STRING_STRING"));
            }
        }
        catch (NumberFormatException nfe) {
            throw new OerrException(OerrArb.getString("OERR_NUMBER"));
        }
        return retVal.trim();
    }

    private String getIndexFile(String baseName, String errNo) throws OerrException {
        try {
            GetFile getoutput;
            BufferedInputStream in = null;
            InputStream nobuf = this.getClass().getResourceAsStream("index.xml");
            if (nobuf == null) {
                throw new OerrException(OerrArb.format("GET_RESOURCE_AS_STREAM", "index.xml"));
            }
            in = new BufferedInputStream(nobuf);
            if (this._factory == null) {
                this._factory = SAXParserFactory.newInstance();
                this._factory.setValidating(false);
                this._factory.setNamespaceAware(true);
            }
            GetFile handler = getoutput = new GetFile(baseName, errNo);
            this._factory.newSAXParser().parse((InputStream)in, (DefaultHandler)handler);
            if (getoutput.lookfor == null || getoutput.lookfor.equals("")) {
                throw new OerrException(OerrArb.format("GET_FILE_ERROR", baseName, errNo));
            }
            return getoutput.lookfor;
        }
        catch (IOException e) {
            throw new OerrException(e);
        }
        catch (SAXException e) {
            throw new OerrException(e);
        }
        catch (ParserConfigurationException e) {
            throw new OerrException(e);
        }
    }

    private String outputMatch(String sequenceFile, String errNo) throws OerrException {
        String retVal = "";
        try {
            SAXHandler getoutput;
            BufferedInputStream in = null;
            InputStream nobuf = this.getClass().getResourceAsStream(sequenceFile);
            if (nobuf == null) {
                throw new OerrException(OerrArb.format("GET_RESOURCE_AS_STREAM", sequenceFile));
            }
            in = new BufferedInputStream(nobuf);
            if (this._factory == null) {
                this._factory = SAXParserFactory.newInstance();
                this._factory.setValidating(false);
                this._factory.setNamespaceAware(true);
            }
            SAXHandler handler = getoutput = new SAXHandler(errNo);
            InputSource is = new InputSource(in);
            is.setEncoding("UTF-8");
            this._factory.newSAXParser().parse(is, (DefaultHandler)handler);
            if (getoutput.lookfor.toString() != null && !getoutput.lookfor.toString().equals("")) {
                retVal = getoutput.lookfor.toString();
            }
            if (getoutput.lookfor == null || getoutput.lookfor.equals("")) {
                throw new OerrException(OerrArb.getString("NO_VALUE_OERR_STRING"));
            }
        }
        catch (IOException e) {
            throw new OerrException(e);
        }
        catch (SAXException e) {
            throw new OerrException(e);
        }
        catch (ParserConfigurationException e) {
            throw new OerrException(e);
        }
        return retVal;
    }

    private class GetFile
    extends DefaultHandler {
        public boolean match = false;
        public String lookfor = null;
        private String _baseName = null;
        private int _errNo = 0;
        boolean matchFound = false;

        public GetFile(String baseName, String errNo) {
            this._baseName = baseName;
            this._errNo = new Integer(errNo);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.matchFound && "fileIndex".equals(localName) && this._baseName.equals(attributes.getValue("", "basename"))) {
                int min = new Integer(attributes.getValue("", "min"));
                int max = new Integer(attributes.getValue("", "max"));
                if (this._errNo >= min && this._errNo <= max) {
                    this.lookfor = attributes.getValue("", "basename") + attributes.getValue("", "sequence") + attributes.getValue("", "language") + ".xml";
                    this.matchFound = true;
                }
            }
        }
    }

    private class SAXHandler
    extends DefaultHandler {
        public boolean match = false;
        public StringBuffer lookfor = new StringBuffer();
        public int ami = 0;

        public SAXHandler(String getme) {
            this.ami = new Integer(getme);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("payload".equals(localName) && this.ami == new Integer(attributes.getValue("", "number"))) {
                this.match = true;
                this.lookfor = new StringBuffer();
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) {
            if (this.match) {
                this.lookfor.append(chars, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.match = false;
        }
    }
}

