/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.vault;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.logging.Logger;

public class VaultResponse {
    private int _responseCode;
    private String _responseBody;
    private Map<String, ?> _responseData;
    private String _url = null;
    private Logger LOGGER = Logger.getLogger(VaultResponse.class.getClass().getName());

    public VaultResponse(HttpURLConnection con) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        this._responseCode = con.getResponseCode();
        this._url = con.getURL().toString();
        this.LOGGER.fine("\tResponse Code :: " + this._responseCode + "> " + con.getURL());
        StringBuffer response = null;
        if (this._responseCode < 400) {
            String inputLine;
            response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            this._responseBody = response.toString();
            if (this._responseBody != null) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    this._responseData = (Map)mapper.readValue(this._responseBody, Map.class);
                }
                catch (Exception e) {
                    this.LOGGER.info("Invalid json response:" + this._responseBody);
                }
            }
        }
    }

    public String getURL() {
        return this._url;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getResponseBody() {
        return this._responseBody;
    }

    public Map<String, ?> getFullResponseData() {
        return this._responseData;
    }

    public Map<String, ?> getResponseData() {
        return this._responseData == null ? null : (Map)this._responseData.get("data");
    }
}

