/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scripting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.scripting.Messages;
import oracle.dbtools.scripting.Script;
import oracle.dbtools.scripting.ScriptingUtils;

public class ScriptCommand
extends CommandListener
implements IHelp {
    private static Logger LOGGER = Logger.getLogger(ScriptCommand.class.getName());

    @Override
    public String getCommand() {
        return "SCRIPT";
    }

    @Override
    public String getHelp() {
        return Messages.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        int noslines = cmd.getSql().split("\r\n|\r|\n").length;
        if (cmd.getSql().split("\\s+").length == 1) {
            return true;
        }
        if (noslines > 1) {
            String code = cmd.getSql().substring(cmd.getSql().indexOf(10) + 1);
            Script s = new Script();
            s.setExtension("js");
            s.setScript(code);
            this.runScript(conn, ctx, cmd, s, new String[0]);
        } else {
            Script s = new Script();
            String fullCmd = cmd.getSql().substring(cmd.getSql().indexOf(" ")).trim();
            String regex = "\"?( |$)(?=(([^\"]*\"){2})*[^\"]*$)\"?";
            String[] parts = fullCmd.split(regex);
            parts = this.trimQuotes(parts);
            String location = parts[0];
            String ext = "js";
            if (location.indexOf(".", location.lastIndexOf(File.separator)) > 0) {
                ext = location.substring(location.indexOf(".", location.lastIndexOf(File.separator)) + 1);
            } else {
                location = location + ".js";
            }
            try {
                URLConnection uc = FileUtils.getFile(ctx, location);
                if (uc == null) {
                    throw new IOException(location);
                }
                InputStream in = uc.getInputStream();
                byte[] contents = new byte[1024];
                int bytesRead = 0;
                StringBuilder strFileContents = new StringBuilder();
                while ((bytesRead = in.read(contents)) != -1) {
                    strFileContents.append(new String(contents, 0, bytesRead));
                }
                String content = strFileContents.toString();
                s.setScript(content);
            }
            catch (IOException e1) {
                ctx.write(MessageFormat.format(Messages.getString("ScriptCommand.8"), location));
                ctx.write("\n");
                return true;
            }
            if (ext != null) {
                s.setExtension(ext);
            } else {
                s.setExtension("js");
            }
            ScriptEngineManager mgr = new ScriptEngineManager();
            if (mgr.getEngineByExtension(s.getExtension()) == null) {
                ctx.write(MessageFormat.format(Messages.getString("ScriptCommand.1"), s.getExtension()));
                return true;
            }
            this.runScript(conn, ctx, cmd, s, parts);
        }
        return true;
    }

    private String[] trimQuotes(String[] parts) {
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith("\"")) {
                parts[i] = parts[i].substring(1);
            }
            if (!parts[i].endsWith("\"")) continue;
            parts[i] = parts[i].substring(0, parts[i].length());
        }
        return parts;
    }

    private void runScript(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, Script script, String[] scriptArgs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (conn != null) {
            map.put("conn", conn);
            map.put("isConnected", true);
        } else {
            map.put("isConnected", false);
        }
        map.put("ctx", ctx);
        map.put("out", ctx.getOutputStream());
        DBUtil dbUtil = null;
        if (conn != null) {
            dbUtil = DBUtil.getInstance(conn);
        }
        map.put("util", dbUtil);
        map.put("commands", CommandRegistry.class);
        ScriptExecutor sqlcl = new ScriptExecutor(conn);
        sqlcl.setScriptRunnerContext(ctx);
        map.put("sqlcl", sqlcl);
        map.put("args", scriptArgs);
        try {
            ScriptingUtils.runScript(ctx, script, map);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }
}

