/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;

public class Service {
    static boolean isRunning = false;

    public static void main(String[] args) throws Exception {
        String input = "\u0439";
        String coded = Service.into4chars(input);
        System.out.println("'" + input + "' -> '" + coded + "' -> '" + Service.from4chars(coded) + "'");
        System.out.println("'" + Service.from4chars("JJJF") + "'");
        System.out.println("'" + Service.from4chars("JLFFOIJF") + "'");
    }

    public static String readFile(Class<?> c, String file) throws IOException {
        URL u = c.getResource(file);
        if (u == null) {
            u = Service.fileNameGitResource(c, file);
        }
        if (u == null) {
            throw new FileNotFoundException(file);
        }
        return Service.readFile(u.openStream());
    }

    public static URL fileNameGitResource(Class<?> c, String file) throws MalformedURLException {
        String tmp = c.getResource("").toString();
        String pattern = "/classes/";
        int pos = tmp.indexOf("/classes/") + "/classes/".length();
        String pkg = tmp.substring(pos);
        tmp = tmp.substring(0, pos);
        pos = tmp.lastIndexOf("common");
        pos = tmp.indexOf("/", pos);
        tmp = tmp.substring(0, pos);
        tmp = tmp + "/src/main/resources";
        if (file.startsWith(pkg)) {
            file = file.substring(pkg.length());
        }
        if (file.startsWith("/" + pkg)) {
            file = file.substring(pkg.length() + 1);
        }
        tmp = tmp + '/' + pkg + file;
        return new URL(tmp);
    }

    public static String readFile(String file) throws FileNotFoundException, IOException {
        return Service.readFile(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream is) throws IOException {
        byte[] bytes = new byte[4096];
        int bytesRead = 0;
        StringBuffer ret = new StringBuffer();
        try (BufferedInputStream bin = null;){
            bin = new BufferedInputStream(is);
            bytesRead = bin.read(bytes, 0, bytes.length);
            while (bytesRead != -1) {
                ret.append(new String(bytes).substring(0, bytesRead));
                bytesRead = bin.read(bytes, 0, bytes.length);
            }
        }
        return ret.toString();
    }

    public static String cleanFileName(String fileName) {
        return Service.cleanFileName(fileName, "@");
    }

    public static String cleanFileName(String fileName, String replace) {
        String clean = fileName.replaceAll("[<>:/\\|?*]", replace);
        return clean;
    }

    public static String cleanScriptFileName(String fileName) {
        return Service.cleanScriptFileName(fileName, "_", "_");
    }

    public static String cleanScriptFileName(String fileName, String replace, String replaceSpace) {
        String clean = fileName.replaceAll("[<>:/\\|?*()%&'$@^~/#]", replace);
        clean = clean.replaceAll(" ", replaceSpace);
        return clean;
    }

    public static String convertNonAsciiFileName(String fileName) {
        if (!Service.isAscii(fileName)) {
            return Integer.valueOf(fileName.hashCode()).toString();
        }
        return fileName;
    }

    public static boolean isAscii(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c <= 'z') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL url, String dstdir) {
        InputStream in = null;
        OutputStream out = null;
        ZipFile jar = null;
        try {
            int len;
            String name;
            if (url.toString().startsWith("jar:file:")) {
                int end = url.toString().indexOf(33);
                String jarFile = url.toString().substring("jar:file:".length(), end);
                jar = new JarFile(jarFile);
                JarEntry je = ((JarFile)jar).getJarEntry(url.toString().substring(end + 2));
                in = ((JarFile)jar).getInputStream(je);
                String path = je.getName();
                File file = new File(path);
                name = file.getName();
            } else {
                String path = url.getPath();
                File file = new File(path);
                name = file.getName();
                in = new FileInputStream(path);
            }
            out = new FileOutputStream(new File(dstdir + File.separator + name));
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String fromPath, String fromEncoding, String toPath, String toEncoding) {
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            FileInputStream fin = new FileInputStream(fromPath);
            BufferedInputStream bin = new BufferedInputStream(fin);
            reader = fromEncoding == null ? new InputStreamReader(bin) : new InputStreamReader((InputStream)bin, fromEncoding);
            File toFile = new File(toPath);
            File toDir = toFile.getParentFile();
            if (!toDir.isDirectory()) {
                toDir.mkdirs();
            }
            if (!toFile.isFile()) {
                toFile.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(toPath);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            writer = toEncoding == null ? new OutputStreamWriter(bout) : new OutputStreamWriter((OutputStream)bout, toEncoding);
            int len = 0;
            char[] buf = new char[1024];
            while ((len = reader.read(buf, 0, 1024)) > 0) {
                writer.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            Logger.getLogger(Service.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                Logger.getLogger(Service.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            try {
                writer.close();
            }
            catch (Exception e) {
                Logger.getLogger(Service.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public static String toNull(String src) {
        return "".equals(src) ? null : src;
    }

    public static String identln(int level, String txt) {
        return Service.identln(level, txt, " ");
    }

    public static String identln(int level, String txt, String filling) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            b.append(filling);
        }
        b.append(txt);
        return b.toString();
    }

    public static int charPos2LineNo(String txt, int pos) {
        int ret = 1;
        for (int i = 0; i < pos; ++i) {
            if (txt.charAt(i) != '\n') continue;
            ++ret;
        }
        return ret;
    }

    public static String padln(String txt, int newsize) {
        StringBuffer b = new StringBuffer(txt);
        for (int i = txt.length(); i < newsize; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    public static int pair(int x, int y) {
        return y << 16 | x;
    }

    public static int Y(int p) {
        return p >> 16;
    }

    public static int X(int p) {
        return p & 0xFFFF;
    }

    public static long lPair(int x, int y) {
        return (long)y << 32 | (long)x;
    }

    public static int lY(long pair) {
        return (int)(pair >> 32);
    }

    public static int lX(long pair) {
        return (int)pair;
    }

    public static int decrPair(int p) {
        return p - 65537;
    }

    public static long addlX(long pair, int x) {
        return pair + (long)x;
    }

    public static long addlY(long pair, int y) {
        return pair + ((long)y << 32);
    }

    public static String handleMixedCase(String name) {
        return Service.handleMixedCase(name, true);
    }

    public static String handleMixedCase(String name, boolean unquote) {
        List<LexerToken> out = LexerToken.parse(name, true);
        StringBuilder ret = new StringBuilder();
        for (LexerToken t : out) {
            String s = t.content;
            if (t.type == Token.DQUOTED_STRING) {
                if (unquote && 1 < s.length()) {
                    s = s.substring(1, s.length() - 1);
                }
            } else {
                s = s.toUpperCase();
            }
            ret.append(s);
        }
        return ret.toString();
    }

    public static String addDoubleQuote(String s) {
        return Service.quoteIdentifier(s, '\"');
    }

    public static String quoteIdentifier(String s, char quoteChar) {
        String quoteString = String.valueOf(quoteChar);
        if (s == null) {
            return null;
        }
        boolean quote = false;
        String legitimateChars = "$#_";
        if (!s.startsWith(quoteString) && !quote) {
            char[] chars = new char[s.length()];
            s.getChars(0, chars.length, chars, 0);
            if (chars.length > 0 && '0' <= chars[0] && chars[0] <= '9') {
                quote = true;
            } else {
                for (char c : chars) {
                    if (legitimateChars.indexOf(c) >= 0 || c >= '0' && ('9' >= c || c >= 'A') && 'Z' >= c) continue;
                    quote = true;
                    break;
                }
            }
        }
        if (s.startsWith("_") || s.startsWith("$") || s.startsWith("#")) {
            quote = true;
        }
        return quote ? MessageFormat.format("{0}{1}{0}", quoteString, s) : s;
    }

    public static String into2chars(String data) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length(); ++i) {
            ret.append(Service.into2chars(data.charAt(i)));
        }
        return ret.toString();
    }

    public static String from2chars(String data) {
        if (data == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < data.length()) {
            char[] chunk = new char[2];
            chunk[0] = data.charAt(i++);
            if (i >= data.length()) {
                return null;
            }
            chunk[1] = data.charAt(i++);
            ret.append(Service.from2chars(chunk));
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    static char[] into2chars(char input) {
        char[] ret = new char[]{(char)(Service.periodicRemainder(input, 16) + 70), (char)(Service.periodicDivision(input, 16) + 70)};
        return ret;
    }

    static char from2chars(char[] input) {
        return (char)((input[1] - 70) * 16 + (input[0] - 70));
    }

    static int periodicRemainder(int i, int j) {
        int ret = i % j;
        if (ret < 0) {
            ret += j;
        }
        return ret;
    }

    static int periodicDivision(int i, int j) {
        int ret = i / j;
        if (ret < 0) {
            --ret;
        }
        return ret;
    }

    public static String into4chars(String data) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length(); ++i) {
            ret.append(Service.into4chars(data.charAt(i)));
        }
        return ret.toString();
    }

    public static String from4chars(String data) {
        if (data == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < data.length()) {
            char[] chunk = new char[4];
            chunk[0] = data.charAt(i++);
            if (i >= data.length()) {
                return null;
            }
            chunk[1] = data.charAt(i++);
            if (i >= data.length()) {
                return null;
            }
            chunk[2] = data.charAt(i++);
            if (i >= data.length()) {
                return null;
            }
            chunk[3] = data.charAt(i++);
            ret.append(Service.from4chars(chunk));
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    static char[] into4chars(char input) {
        char[] ret = new char[4];
        int mod = Service.periodicRemainder(input, 4096);
        int div = Service.periodicDivision(input, 4096);
        ret[3] = (char)(div + 70);
        div = Service.periodicDivision(mod, 256);
        mod = Service.periodicRemainder(mod, 256);
        ret[2] = (char)(div + 70);
        ret[0] = (char)(Service.periodicRemainder(mod, 16) + 70);
        ret[1] = (char)(Service.periodicDivision(mod, 16) + 70);
        return ret;
    }

    static char from4chars(char[] input) {
        return (char)((input[3] - 70) * 16 * 16 * 16 + (input[2] - 70) * 16 * 16 + (input[1] - 70) * 16 + (input[0] - 70));
    }

    public static int[] toArray(Set<Integer> s) {
        int[] ret = new int[s.size()];
        int i = 0;
        for (int ii : s) {
            ret[i++] = ii;
        }
        return ret;
    }

    public static void profile(int duration, int granularity) {
        Service.profile(duration, granularity, 5);
    }

    public static void profile(final int duration, final int granularity, final int stackDepth) {
        if (isRunning) {
            System.out.println("********fired more than once********");
            return;
        }
        isRunning = true;
        String threadName = Thread.currentThread().getName();
        System.out.println("threadName=" + threadName);
        new Thread(){

            @Override
            public void run() {
                String threadName1 = Thread.currentThread().getName();
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() < start + (long)duration) {
                    try {
                        Thread.sleep(granularity);
                        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                        ThreadInfo[] infos = bean.dumpAllThreads(true, true);
                        boolean divide = false;
                        boolean divide2 = false;
                        for (ThreadInfo info : infos) {
                            StackTraceElement elem;
                            if (threadName1.equals(info.getThreadName())) continue;
                            if (divide) {
                                System.out.println("----------------");
                            }
                            divide = false;
                            StackTraceElement[] elems = info.getStackTrace();
                            int i = 0;
                            StackTraceElement[] stackTraceElementArray = elems;
                            int n = stackTraceElementArray.length;
                            for (int j = 0; !(j >= n || (elem = stackTraceElementArray[j]).toString().startsWith("org") || elem.toString().startsWith("oracle.dbtools.raptor.plsql.BackgroundParser") || elem.toString().startsWith("oracle.ide.model.FacadeBufferReference$PollingThread") || elem.toString().startsWith("oracle.ide.util.WeakDataReference$Cleaner") || elem.toString().startsWith("oracle.ide.status.StatusExecutor") || elem.toString().startsWith("oracle.ide.log.QueuedLoggingHandler")); ++j) {
                                if (elem.toString().startsWith("java") || elem.toString().startsWith("sun") || elem.toString().startsWith("oracle.net.ns") || elem.toString().startsWith("oracle.jdbc") || elem.toString().startsWith("oracle.dbtools.raptor.backgroundTask") || elem.toString().startsWith("oracle.javatools.db.execute.QueryWrapper") || elem.toString().startsWith("oracle.javatools.db.execute.ConnectionWrapper") || i >= stackDepth) continue;
                                System.out.println(elem.toString());
                                divide = true;
                                divide2 = true;
                                ++i;
                            }
                        }
                        if (!divide2) continue;
                        System.out.println("=================" + (System.currentTimeMillis() - start));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
    }
}

