/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.adapter.JDBCParameterInfo;
import oracle.jdeveloper.db.adapter.JDBCParametersParser;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public abstract class AbstractConnectionCreator
implements ConnectionCreator {
    @Deprecated
    protected ResourceBundle getBundle() {
        return DBAdapterBundle.getBundle();
    }

    protected Logger getLogger() {
        return DatabaseProviderHelper.getLogger();
    }

    @Override
    public boolean shouldEncrypt(String string) {
        return "password".equals(string);
    }

    @Override
    public boolean isPassword(String string) {
        return this.shouldEncrypt(string);
    }

    @Override
    public boolean shouldSave(String string, DatabaseProvider databaseProvider) {
        String string2;
        boolean bl = "password".equals(string) ? (string2 = databaseProvider.getProperty("SavePassword")) == null || Boolean.valueOf(string2) != false : !"INTERNAL_STRINGS_TO_FILE".equals(string);
        return bl;
    }

    @Override
    public boolean shouldPromptForPassword(Properties properties) {
        String string;
        String string2;
        boolean bl = false;
        Collection<String> collection = this.listAllowedProperties();
        if (collection.contains("password") && (string2 = properties.getProperty("password")) == null && (string = properties.getProperty("SavePassword")) != null && !Boolean.valueOf(string).booleanValue()) {
            bl = true;
        }
        return bl;
    }

    protected void setCustomProperties(Properties properties, Properties properties2) {
        String string = properties.getProperty("parameters");
        JDBCParametersParser.parseParameterString(string, properties2);
    }

    @Override
    public final Properties getJDBCProperties(Properties properties) throws SQLException {
        String string = this.trimINN(properties.getProperty("user"));
        String string2 = properties.getProperty("password");
        if (this.hasLength(string) && !this.hasLength(string2) && !this.allowNullPassword()) {
            throw new SQLException(DBAdapterBundle.get("ERROR_MISSING_PASS"), "");
        }
        Properties properties2 = new Properties();
        if (this.hasLength(string)) {
            properties2.put("user", string);
        }
        if (this.hasLength(string2)) {
            properties2.put("password", string2);
        }
        this.setCustomProperties(properties, properties2);
        return properties2;
    }

    @Override
    public Connection getConnection(Properties properties) throws SQLException {
        Connection connection;
        block4: {
            String string = this.getConnectionURL(properties);
            Properties properties2 = this.getJDBCProperties(properties);
            Driver driver = this.getDriver(properties);
            connection = null;
            try {
                connection = driver.connect(string, properties2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new SQLException(unsatisfiedLinkError.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!(driver instanceof OracleDriver)) break block4;
                throw new SQLException(DBAdapterBundle.get("ERROR_UNSUPPORTED_ORACLE_VERSION"));
            }
        }
        if (connection == null) {
            throw new SQLException(this.getInvalidURLMessage());
        }
        return connection;
    }

    protected String getInvalidURLMessage() {
        return DBAdapterBundle.get("ERROR_INVALID_URL");
    }

    private String trimINN(String string) {
        return string == null ? string : string.trim();
    }

    protected boolean allowNullPassword() {
        Collection<String> collection = this.listAllowedProperties();
        return !collection.contains("password");
    }

    protected final boolean hasLength(String string) {
        return string != null && string.length() > 0;
    }

    protected final String getPropertyOrThrow(Properties properties, String string) throws SQLException {
        String string2 = properties.getProperty(string);
        if (!this.hasLength(string2 = this.trimINN(string2))) {
            this.throwMissingPropertyException(string);
        }
        return string2;
    }

    protected final void throwMissingPropertyException(String string) throws SQLException {
        throw new SQLException("Required property '" + string + "' cannot be null or empty");
    }

    @Override
    public String getConnectionURL(Properties properties) throws SQLException {
        return properties.getProperty("customUrl");
    }

    @Override
    public String getDriverClassName(Properties properties) throws SQLException {
        return properties.getProperty("driver");
    }

    protected Driver getDriver(Properties properties) throws SQLException {
        String string = this.getDriverClassName(properties);
        return this.loadDriver(string);
    }

    protected Driver loadDriver(String string) throws SQLException {
        try {
            ClassLoader classLoader = DatabaseProvider.getClassLoader(string, this.getClass().getClassLoader());
            Class<?> clazz = Class.forName(string, true, classLoader);
            return (Driver)clazz.newInstance();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(DBAdapterBundle.get("ERROR_DRIVER_CLASS_NOT_FOUND"));
        }
        catch (Throwable throwable) {
            SQLException sQLException = new SQLException(throwable.getLocalizedMessage());
            sQLException.initCause(throwable);
            throw sQLException;
        }
    }

    @Override
    public Collection<String> listAllowedProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("user");
        hashSet.add("password");
        hashSet.add("customUrl");
        hashSet.add("driver");
        hashSet.add("parameters");
        hashSet.add("subtype");
        return hashSet;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        return Collections.emptySet();
    }

    @Override
    public Collection<JDBCParameterInfo> listJDBCParameterInfos(Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        for (String object2 : properties.stringPropertyNames()) {
            properties2.put(object2, properties.getProperty(object2));
        }
        for (String string : this.listRequiredProperties()) {
            if (this.hasLength(properties2.getProperty(string))) continue;
            properties2.setProperty(string, "testValue");
        }
        String string = this.getConnectionURL(properties2);
        Driver driver = this.getDriver(properties2);
        DriverPropertyInfo[] driverPropertyInfoArray = null;
        try {
            driverPropertyInfoArray = driver.getPropertyInfo(string, properties);
        }
        catch (RuntimeException runtimeException) {
            this.getLogger().log(Level.FINE, "getPropertyInfo failed", runtimeException);
        }
        return this.convertToJDBCParameterInfos(driverPropertyInfoArray);
    }

    protected Collection<JDBCParameterInfo> convertToJDBCParameterInfos(DriverPropertyInfo[] driverPropertyInfoArray) {
        ArrayList<JDBCParameterInfo> arrayList = new ArrayList<JDBCParameterInfo>();
        if (driverPropertyInfoArray != null) {
            for (DriverPropertyInfo driverPropertyInfo : driverPropertyInfoArray) {
                if ("user".equals(driverPropertyInfo.name) || "password".equals(driverPropertyInfo.name)) continue;
                arrayList.add(new JDBCParameterInfo(driverPropertyInfo));
            }
        }
        return arrayList;
    }
}

