/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class DB2ConnectionCreator
extends AbstractConnectionCreator {
    public static final String DB2_DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    public static final String DB2_WEBLOGIC_DRIVER_CLASS = "weblogic.jdbc.db2.DB2Driver";
    public static final String SUBTYPE_DB2 = "DB2";

    @Override
    public String getDriverClassName(Properties properties) throws SQLException {
        String string = super.getDriverClassName(properties);
        if (!this.hasLength(string)) {
            string = DB2_DRIVER_CLASS;
        }
        return string;
    }

    @Override
    public String getConnectionURL(Properties properties) throws SQLException {
        String string;
        String string2 = super.getConnectionURL(properties);
        if (this.hasLength(string2)) {
            string = string2;
        } else {
            String string3 = this.getPropertyOrThrow(properties, "hostname");
            String string4 = properties.getProperty("port");
            String string5 = this.getPropertyOrThrow(properties, "dataSourceName");
            boolean bl = DB2_WEBLOGIC_DRIVER_CLASS.equals(this.getDriverClassName(properties));
            StringBuilder stringBuilder = new StringBuilder("jdbc:");
            if (bl) {
                stringBuilder.append("weblogic:");
            }
            stringBuilder.append("db2://").append(string3);
            if (this.hasLength(string4)) {
                stringBuilder.append(":").append(string4);
            }
            if (bl) {
                stringBuilder.append(";DatabaseName=").append(string5);
            } else {
                stringBuilder.append("/").append(string5);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> collection = super.listAllowedProperties();
        collection.add("hostname");
        collection.add("port");
        collection.add("dataSourceName");
        return collection;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("hostname");
        hashSet.add("dataSourceName");
        return hashSet;
    }
}

