/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.sql.DataSource;
import oracle.dbtools.connections.ConnectionReferenceable;
import oracle.javatools.annotations.Concealed;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.CustomConnectionCreator;
import oracle.jdeveloper.db.adapter.DB2ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProviderClassLoaderFactory;
import oracle.jdeveloper.db.adapter.DerbyConnectionCreator;
import oracle.jdeveloper.db.adapter.MySQLConnectionCreator;
import oracle.jdeveloper.db.adapter.ODBCConnectionCreator;
import oracle.jdeveloper.db.adapter.OracleConnectionCreator;
import oracle.jdeveloper.db.adapter.OracleLiteConnectionCreator;
import oracle.jdeveloper.db.adapter.SQLServerConnectionCreator;
import oracle.jdeveloper.db.adapter.SQLiteConnectionCreator;
import oracle.jdevimpl.db.adapter.DatabaseProviderFactory1212;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.ReferenceWorker;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public class DatabaseProvider
implements ConnectionReferenceable,
DataSource {
    static final Class PROVIDER_CLASS = DatabaseProvider.class;
    static final String PROVIDER_CLASSNAME = PROVIDER_CLASS.getName();
    public static final String SUBTYPE_CLASS_REFTYPE = "subtype";
    public static final String CUSTOM_URL_CLASS_REFTYPE = "customUrl";
    public static final String DRIVER_CLASS_REFTYPE = "driver";
    public static final String USERNAME_CLASS_REFTYPE = "user";
    public static final String PASSWORD_CLASS_REFTYPE = "password";
    public static final String ROLE_CLASS_REFTYPE = "role";
    public static final String HOSTNAME_CLASS_REFTYPE = "hostname";
    public static final String PORT_CLASS_REFTYPE = "port";
    public static final String SID_CLASS_REFTYPE = "sid";
    public static final String DSN_CLASS_REFTYPE = "dataSourceName";
    @Deprecated
    public static final String INSTANCE_CLASS_REFTYPE = "instanceName";
    public static final String PARAMETERS_CLASS_REFTYPE = "parameters";
    public static final String SERVICENAME_CLASS_REFTYPE = "serviceName";
    public static final String SAVE_PASSWORD_CLASS_REFTYPE = "SavePassword";
    @Deprecated
    public static final String DEPLOY_PASSWORD_CLASS_REFTYPE = "DeployPassword";
    @Deprecated
    public static final String ALL_SCHEMAS_REFTYPE = "allSchemas";
    private static DatabaseProviderClassLoaderFactory s_clFactory;
    private static Map<String, Object> s_creators;
    private final Map<String, Object> m_properties = new ConcurrentHashMap<String, Object>();
    private final String m_name;
    private ReferenceWorker m_worker;
    private PrintWriter m_pw;
    private int m_timeout;

    public DatabaseProvider() {
        this(null, null);
    }

    public DatabaseProvider(Properties properties) {
        this(null, properties);
    }

    public DatabaseProvider(String string, Properties properties) {
        this.m_name = string;
        if (properties != null) {
            ConnectionCreator connectionCreator = DatabaseProvider.getCreatorImpl(properties.getProperty(SUBTYPE_CLASS_REFTYPE), true);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object object = entry.getKey();
                if (!(object instanceof String)) continue;
                Object object2 = entry.getValue();
                if (object2 instanceof char[]) {
                    this.setCredential((String)object, (char[])object2);
                    continue;
                }
                if (object2 == null) continue;
                this.setPropertyImpl((String)object, String.valueOf(object2), connectionCreator);
            }
        }
    }

    @Concealed
    public void setReferenceWorker(ReferenceWorker referenceWorker) {
        this.m_worker = referenceWorker;
    }

    public String getName() {
        return this.m_name;
    }

    public Reference getReference() {
        ConnectionCreator connectionCreator = DatabaseProvider.getCreatorImpl(this, true);
        ReferenceWorker referenceWorker = this.m_worker == null ? DatabaseProviderHelper.getDefaultWorker() : this.m_worker;
        Class clazz = referenceWorker == null ? DatabaseProviderFactory1212.class : referenceWorker.getFactoryClass();
        Reference reference = new Reference(PROVIDER_CLASSNAME, clazz.getName(), null);
        boolean bl = false;
        Object object = this.m_properties.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<String, Object> entry = object.next();
            String string = entry.getKey();
            Object object2 = entry.getValue();
            boolean bl2 = object2 instanceof char[];
            boolean bl3 = bl2 || connectionCreator.shouldEncrypt(string);
            boolean bl4 = connectionCreator.shouldSave(string, this);
            if (!bl2 && !(object2 instanceof String)) {
                DatabaseProvider.getLogger().warning(this.m_name + ": invalid value for property " + string);
                continue;
            }
            if (bl4) {
                if (bl3) {
                    char[] cArray = bl2 ? (char[])object2 : ((String)object2).toCharArray();
                    RefAddr refAddr = referenceWorker == null ? new StringRefAddr(string, null) : referenceWorker.encrypt(string, cArray, this.m_name);
                    if (refAddr == null) {
                        DatabaseProvider.getLogger().info(DBAdapterBundle.format("ERROR_NO_ENCRYPTION", string));
                        continue;
                    }
                    reference.add(refAddr);
                    continue;
                }
                reference.add(new StringRefAddr(string, (String)object2));
                continue;
            }
            if (!bl3 || object2 == null) continue;
            bl = true;
        }
        if (bl && (object = DatabaseProviderHelper.getPasswordPrompter()) != null) {
            ((DatabaseProviderHelper.PasswordPrompter)object).cache(this);
        }
        return reference;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getProperties());
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Properties properties = this.getProperties();
        properties.setProperty(USERNAME_CLASS_REFTYPE, string);
        properties.setProperty(PASSWORD_CLASS_REFTYPE, string2);
        return this.getConnection(properties);
    }

    private Connection getConnection(Properties properties) throws SQLException {
        Object object;
        ConnectionCreator connectionCreator = DatabaseProvider.getCreator(this);
        if (connectionCreator.shouldPromptForPassword(properties) && (object = DatabaseProviderHelper.getPasswordPrompter()) != null) {
            return ((DatabaseProviderHelper.PasswordPrompter)object).promptForPassword(this);
        }
        object = connectionCreator.getConnection(properties);
        return object;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pw;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.m_pw = printWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_timeout;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.m_timeout = n;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() {
        return DatabaseProvider.getLogger();
    }

    public String getConnectionURL() throws SQLException {
        return DatabaseProvider.getCreator(this).getConnectionURL(this.getProperties());
    }

    public Properties getJDBCProperties() throws SQLException {
        return DatabaseProvider.getCreator(this).getJDBCProperties(this.getProperties());
    }

    public String getDriverClassName() throws SQLException {
        return DatabaseProvider.getCreator(this).getDriverClassName(this.getProperties());
    }

    public boolean shouldPromptForCredentials() {
        ConnectionCreator connectionCreator = DatabaseProvider.getCreatorImpl(this, false);
        return connectionCreator != null && connectionCreator.shouldPromptForPassword(this.getProperties());
    }

    public String getProperty(String string) {
        Object object = this.m_properties.get(string);
        String string2 = object instanceof char[] ? new String((char[])object) : (object instanceof String ? (String)object : null);
        return string2;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (String string : this.m_properties.keySet()) {
            String string2 = this.getProperty(string);
            if (string2 == null) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            this.m_properties.remove(string);
        } else {
            ConnectionCreator connectionCreator = DatabaseProvider.getCreatorImpl(this, true);
            this.setPropertyImpl(string, string2, connectionCreator);
        }
    }

    private void setPropertyImpl(String string, String string2, ConnectionCreator connectionCreator) {
        if (connectionCreator.shouldEncrypt(string)) {
            this.setCredential(string, string2.toCharArray());
        } else {
            this.m_properties.put(string, string2);
        }
    }

    public char[] getCredential(String string) {
        Object object = this.m_properties.get(string);
        Object object2 = object instanceof char[] ? (char[])object : (Object)(object instanceof String ? ((String)object).toCharArray() : null);
        return object2;
    }

    public void setCredential(String string, char[] cArray) {
        if (cArray == null) {
            this.m_properties.remove(string);
        } else {
            this.m_properties.put(string, cArray);
        }
    }

    public void disconnect() {
        DatabaseProviderHelper.PasswordPrompter passwordPrompter = DatabaseProviderHelper.getPasswordPrompter();
        if (passwordPrompter != null) {
            passwordPrompter.disconnect(this);
        }
    }

    public int hashCode() {
        return this.m_properties.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseProvider && this.equalsImpl((DatabaseProvider)object);
    }

    private boolean equalsImpl(DatabaseProvider databaseProvider) {
        return DatabaseProvider.areEqual(this.m_name, databaseProvider.m_name) && DatabaseProvider.areEqual(this.m_properties, databaseProvider.m_properties);
    }

    @Deprecated
    public Attributes getAttributes() {
        return null;
    }

    @Deprecated
    static ClassLoader getClassLoader(String string) {
        return DatabaseProvider.getClassLoader(string, null);
    }

    static ClassLoader getClassLoader(String string, ClassLoader classLoader) {
        ClassLoader classLoader2 = null;
        if (s_clFactory != null) {
            classLoader2 = s_clFactory.getClassLoader(string);
        }
        if (classLoader2 == null && classLoader != null) {
            classLoader2 = DatabaseProvider.tryLoad(classLoader, string);
        }
        if (classLoader2 == null) {
            classLoader2 = DatabaseProvider.tryLoad(Thread.currentThread().getContextClassLoader(), string);
        }
        ClassLoader classLoader3 = PROVIDER_CLASS.getClassLoader();
        if (classLoader2 == null && classLoader != classLoader3) {
            classLoader2 = DatabaseProvider.tryLoad(classLoader3, string);
        }
        if (classLoader2 == null) {
            classLoader2 = DatabaseProvider.tryLoad(ClassLoader.getSystemClassLoader(), string);
        }
        return classLoader2;
    }

    private static ClassLoader tryLoad(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            return null;
        }
        try {
            classLoader.loadClass(string);
            return classLoader;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Concealed
    public static void setClassLoaderFactory(DatabaseProviderClassLoaderFactory databaseProviderClassLoaderFactory) {
        s_clFactory = databaseProviderClassLoaderFactory;
    }

    private static boolean areEqual(Object object, Object object2) {
        boolean bl;
        if (object == object2) {
            bl = true;
        } else if (object == null || object2 == null) {
            bl = false;
        } else if (object instanceof Map && object2 instanceof Map) {
            boolean bl2 = true;
            Map map = (Map)object;
            Map map2 = (Map)object2;
            HashSet hashSet = new HashSet();
            hashSet.addAll(map.keySet());
            hashSet.addAll(map2.keySet());
            for (Object e : hashSet) {
                Object v;
                Object v2 = map.get(e);
                if (DatabaseProvider.areEqual(v2, v = map2.get(e))) continue;
                bl2 = false;
                break;
            }
            bl = bl2;
        } else {
            bl = object instanceof char[] && object2 instanceof char[] ? Arrays.equals((char[])object, (char[])object2) : object.equals(object2);
        }
        return bl;
    }

    public static ConnectionCreator getCreator(DatabaseProvider databaseProvider) throws SQLException {
        ConnectionCreator connectionCreator = DatabaseProvider.getCreatorImpl(databaseProvider, false);
        if (connectionCreator == null) {
            throw new SQLException(DBAdapterBundle.format("ERROR_INVALID_SUBTYPE", databaseProvider.getProperty(SUBTYPE_CLASS_REFTYPE)));
        }
        return connectionCreator;
    }

    private static ConnectionCreator getCreatorImpl(DatabaseProvider databaseProvider, boolean bl) {
        return DatabaseProvider.getCreatorImpl(databaseProvider.getProperty(SUBTYPE_CLASS_REFTYPE), bl);
    }

    private static ConnectionCreator getCreatorImpl(String string, boolean bl) {
        ConnectionCreator connectionCreator = null;
        if (string != null) {
            Object object = s_creators.get(string);
            if (object instanceof ConnectionCreator) {
                connectionCreator = (ConnectionCreator)object;
            } else if (object instanceof Callable) {
                try {
                    connectionCreator = (ConnectionCreator)((Callable)object).call();
                }
                catch (Exception exception) {
                    DatabaseProvider.getLogger().log(Level.SEVERE, string, exception);
                }
            }
        }
        if (connectionCreator == null && bl) {
            connectionCreator = new OracleConnectionCreator();
        }
        return connectionCreator;
    }

    public static synchronized void registerConnectionCreator(String string, ConnectionCreator connectionCreator) {
        DatabaseProvider.registerCCImpl(string, connectionCreator);
    }

    public static synchronized void registerLazyConnectionCreator(String string, Callable<ConnectionCreator> callable) {
        DatabaseProvider.registerCCImpl(string, callable);
    }

    private static void registerCCImpl(String string, Object object) {
        Object object2 = object == null ? s_creators.remove(string) : s_creators.put(string, object);
        if (object2 != null) {
            DatabaseProvider.getLogger().fine("DB Adapter warning: Replacing connection creator  for subtype " + string);
        }
    }

    private static Logger getLogger() {
        return DatabaseProviderHelper.getLogger();
    }

    private static void registerLegacyCreators() {
        s_creators.put("ODBCBridge", new ODBCConnectionCreator());
    }

    static {
        s_creators = new ConcurrentHashMap<String, Object>();
        s_creators.put("oraJDBC", new OracleConnectionCreator());
        s_creators.put("oraLite", new OracleLiteConnectionCreator());
        s_creators.put("thirdParty", new CustomConnectionCreator());
        s_creators.put("MYSQL", new MySQLConnectionCreator());
        s_creators.put("DB2", new DB2ConnectionCreator());
        s_creators.put("SQLServer", new SQLServerConnectionCreator());
        s_creators.put("SQLite", new SQLiteConnectionCreator());
        s_creators.put("derby", new DerbyConnectionCreator());
        DatabaseProvider.registerLegacyCreators();
    }
}

