/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.ReferenceWorker;

public class DatabaseProviderFactory1212
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object instanceof Reference) {
            ConnectionCreator connectionCreator;
            DatabaseProvider databaseProvider;
            String string;
            Reference reference = (Reference)object;
            if (name != null && name.size() > 0) {
                string = name.toString();
                databaseProvider = new DatabaseProvider(string, null);
            } else {
                string = null;
                databaseProvider = new DatabaseProvider();
            }
            ReferenceWorker referenceWorker = this.getReferenceWorker(true, hashtable);
            databaseProvider.setReferenceWorker(referenceWorker);
            RefAddr refAddr = reference.get("subtype");
            databaseProvider.setProperty("subtype", refAddr == null ? null : (String)refAddr.getContent());
            try {
                connectionCreator = DatabaseProvider.getCreator(databaseProvider);
            }
            catch (SQLException sQLException) {
                connectionCreator = null;
            }
            Enumeration<RefAddr> enumeration = reference.getAll();
            while (enumeration.hasMoreElements()) {
                Object object2;
                RefAddr refAddr2 = enumeration.nextElement();
                String string2 = refAddr2.getType();
                if (connectionCreator != null && connectionCreator.shouldEncrypt(string2)) {
                    ReferenceWorker referenceWorker2 = this.getReferenceWorker(false, hashtable);
                    if (referenceWorker2 == null) {
                        DatabaseProviderHelper.getLogger().warning("Cannot decrypt password, don't know how.");
                        object2 = null;
                    } else {
                        object2 = referenceWorker2.decrypt(refAddr2, string);
                    }
                } else {
                    object2 = refAddr2.getContent();
                }
                if (object2 instanceof String) {
                    databaseProvider.setProperty(string2, (String)object2);
                    continue;
                }
                if (object2 instanceof char[]) {
                    databaseProvider.setCredential(string2, (char[])object2);
                    continue;
                }
                if (object2 == null) continue;
                DatabaseProviderHelper.getLogger().warning(string + ": invalid value for property " + string2);
            }
            return databaseProvider;
        }
        return null;
    }

    protected ReferenceWorker getReferenceWorker(boolean bl, Hashtable hashtable) {
        Object v;
        ReferenceWorker referenceWorker = null;
        if (hashtable != null && (v = hashtable.get(ReferenceWorker.KEY)) instanceof ReferenceWorker) {
            referenceWorker = (ReferenceWorker)v;
        }
        if (referenceWorker == null) {
            referenceWorker = DatabaseProviderHelper.getDefaultWorker(bl);
        }
        return referenceWorker;
    }
}

