/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import javax.naming.RefAddr;
import javax.naming.Reference;
import oracle.dbtools.connections.ConnectionFactory;
import oracle.dbtools.connections.StorageException;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.ReferenceWorker;

public class DatabaseProviderStorageFactory
implements ConnectionFactory<DatabaseProvider> {
    public static final String TYPE = "jdbc";

    private static ReferenceWorker getReferenceWorker(boolean bl, Map<String, ?> map) {
        Object obj;
        ReferenceWorker referenceWorker = null;
        if (map != null && (obj = map.get(ReferenceWorker.KEY)) instanceof ReferenceWorker) {
            referenceWorker = (ReferenceWorker)obj;
        }
        if (referenceWorker == null) {
            referenceWorker = DatabaseProviderHelper.getDefaultWorker(bl);
        }
        return referenceWorker;
    }

    public Class<DatabaseProvider> getConnectionClass() {
        return DatabaseProvider.class;
    }

    public String getConnectionType() {
        return TYPE;
    }

    public DatabaseProvider createObject(String string, Reference reference, Map<String, ?> map) throws StorageException {
        ConnectionCreator connectionCreator;
        DatabaseProvider databaseProvider;
        String string2;
        if (string != null && string.length() > 0) {
            string2 = string;
            databaseProvider = new DatabaseProvider(string2, null);
        } else {
            string2 = null;
            databaseProvider = new DatabaseProvider();
        }
        ReferenceWorker referenceWorker = DatabaseProviderStorageFactory.getReferenceWorker(true, map);
        databaseProvider.setReferenceWorker(referenceWorker);
        RefAddr refAddr = reference.get("subtype");
        databaseProvider.setProperty("subtype", refAddr == null ? null : (String)refAddr.getContent());
        try {
            connectionCreator = DatabaseProvider.getCreator(databaseProvider);
        }
        catch (SQLException sQLException) {
            connectionCreator = null;
        }
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            Object object;
            RefAddr refAddr2 = enumeration.nextElement();
            String string3 = refAddr2.getType();
            if (connectionCreator != null && connectionCreator.shouldEncrypt(string3)) {
                ReferenceWorker referenceWorker2 = DatabaseProviderStorageFactory.getReferenceWorker(false, map);
                if (referenceWorker2 == null) {
                    DatabaseProviderHelper.getLogger().warning("Cannot decrypt password, don't know how.");
                    object = null;
                } else {
                    object = referenceWorker2.decrypt(refAddr2, string2);
                }
            } else {
                object = refAddr2.getContent();
            }
            if (object instanceof String) {
                databaseProvider.setProperty(string3, (String)object);
                continue;
            }
            if (object instanceof char[]) {
                databaseProvider.setCredential(string3, (char[])object);
                continue;
            }
            if (object == null) continue;
            DatabaseProviderHelper.getLogger().warning(string2 + ": invalid value for property " + string3);
        }
        return databaseProvider;
    }
}

