/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import javax.xml.namespace.QName;
import oracle.dbtools.json.JSONValue;

public class JSONProperty {
    private final QName name;
    private final JSONValue<?> value;

    JSONProperty(QName name, JSONValue<?> value) {
        this.name = name;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONProperty other = (JSONProperty)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public QName name() {
        return this.name;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JSONProperty [name=");
        builder.append(this.name);
        builder.append(", value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }

    public JSONValue<?> value() {
        return this.value;
    }
}

