/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import oracle.as.management.tracing.TraceProviderParameterType;

public class TraceProviderParameterInfo
implements Serializable {
    private String m_name;
    private String m_userVisibleName;
    private String m_description;
    private TraceProviderParameterType m_type;
    private Map<String, String> m_lov;
    private String m_defaultValue;
    private static final long serialVersionUID = 20110725L;
    private static CompositeType s_allowedValuesCompositeType;
    private static TabularType s_allowedValuesTabularType;
    private static CompositeType s_compositeType;
    private static final String TYPE_NAME;
    private static final String[] ITEM_NAMES;
    private static final String ALLOWED_VALUES_TYPE_NAME = "java.util.Map<java.lang.String,java.lang.String>";
    private static final String[] ALLOWED_VALUES_ITEM_NAMES;

    public String getName() {
        return this.m_name;
    }

    public String getUserVisibleName() {
        return this.m_userVisibleName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public TraceProviderParameterType getType() {
        return this.m_type;
    }

    public Map<String, String> getAllowedValues() {
        return this.m_lov;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setUserVisibleName(String userVisibleName) {
        this.m_userVisibleName = userVisibleName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setType(TraceProviderParameterType type) {
        this.m_type = type;
    }

    public void setAllowedValues(Map<String, String> allowedValues) {
        this.m_lov = allowedValues;
    }

    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    public static TraceProviderParameterInfo from(CompositeData cd) throws OpenDataException {
        CompositeType ct = cd.getCompositeType();
        if (!TraceProviderParameterInfo.class.getName().equals(ct.getTypeName())) {
            throw new IllegalArgumentException("Invalid argument");
        }
        TraceProviderParameterInfo pi = new TraceProviderParameterInfo();
        pi.setName((String)cd.get("name"));
        pi.setUserVisibleName((String)cd.get("userVisibleName"));
        pi.setDescription((String)cd.get("description"));
        pi.setType(TraceProviderParameterType.valueOf((String)cd.get("type")));
        pi.setDefaultValue((String)cd.get("defaultValue"));
        return pi;
    }

    public CompositeData toCompositeData(CompositeType ct) throws OpenDataException {
        if (ct == null) {
            ct = TraceProviderParameterInfo.toCompositeType();
        } else if (!TraceProviderParameterInfo.toCompositeType().equals(ct)) {
            throw new IllegalArgumentException("Invalid argument CompositeType");
        }
        return new CompositeDataSupport(ct, ITEM_NAMES, new Object[]{this.getName(), this.getUserVisibleName(), this.getDescription(), this.m_type != null ? this.m_type.toString() : null, this.toOpenType(this.getAllowedValues()), this.getDefaultValue()});
    }

    private TabularData toOpenType(Map<String, String> map) throws OpenDataException {
        if (map == null) {
            return null;
        }
        TabularDataSupport td = new TabularDataSupport(s_allowedValuesTabularType);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CompositeDataSupport cd = new CompositeDataSupport(s_allowedValuesCompositeType, ALLOWED_VALUES_ITEM_NAMES, new Object[]{entry.getKey(), entry.getValue()});
            td.put(cd);
        }
        return td;
    }

    public static CompositeType toCompositeType() {
        return s_compositeType;
    }

    static {
        TYPE_NAME = TraceProviderParameterInfo.class.getName();
        ITEM_NAMES = new String[]{"name", "userVisibleName", "description", "type", "allowedValues", "defaultValue"};
        ALLOWED_VALUES_ITEM_NAMES = new String[]{"key", "value"};
        try {
            s_allowedValuesCompositeType = new CompositeType(ALLOWED_VALUES_TYPE_NAME, ALLOWED_VALUES_TYPE_NAME, ALLOWED_VALUES_ITEM_NAMES, ALLOWED_VALUES_ITEM_NAMES, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            s_allowedValuesTabularType = new TabularType(ALLOWED_VALUES_TYPE_NAME, ALLOWED_VALUES_TYPE_NAME, s_allowedValuesCompositeType, new String[]{"key"});
            s_compositeType = new CompositeType(TYPE_NAME, TYPE_NAME, ITEM_NAMES, ITEM_NAMES, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, s_allowedValuesTabularType, SimpleType.STRING});
        }
        catch (OpenDataException e) {
            Logger.getLogger("oracle.odl.tracing").log(Level.FINE, "Unable to initialize CompositeType: " + e, e);
        }
    }
}

