/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import oracle.core.ojdl.logging.HandlerFactory;
import oracle.core.ojdl.logging.HandlerFactoryException;
import oracle.core.ojdl.logging.ODLHandlerBase;

public class ConsoleHandler
extends ODLHandlerBase
implements HandlerFactory {
    private boolean m_closed = false;
    private boolean m_jdevMode = false;
    private static final int INFO_LEVEL = Level.INFO.intValue();

    public ConsoleHandler() {
        LogManager lm = LogManager.getLogManager();
        String jdevModeProp = lm.getProperty(this.getClass().getName() + ".jdevmode");
        this.m_jdevMode = "true".equalsIgnoreCase(jdevModeProp);
        this.setLevel(Level.INFO);
        this.setFormatter(new SimpleFormatter());
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_closed = true;
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord rec) {
        this.m_rwLock.readLock().lock();
        try {
            String msg;
            if (this.m_closed || !this.isLoggable(rec)) {
                return;
            }
            try {
                msg = this.getFormatter().format(rec);
            }
            catch (Exception e) {
                this.reportError(null, e, 5);
                this.m_rwLock.readLock().unlock();
                return;
            }
            PrintStream out = this.m_jdevMode && rec.getLevel().intValue() > INFO_LEVEL ? System.err : System.out;
            out.print(msg);
            out.flush();
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    @Override
    public Handler create(Properties properties) throws HandlerFactoryException {
        ConsoleHandler h = new ConsoleHandler();
        if ("true".equalsIgnoreCase(properties.getProperty("jdevmode", "false"))) {
            h.m_jdevMode = true;
        }
        return h;
    }
}

