/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.logging.ODLFormatter;

public class SimpleFormatter
extends ODLFormatter {
    private boolean m_writeThrowable = false;
    private SimpleDateFormat m_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String LSEP = System.getProperty("line.separator");
    private static final String WRITE_THROWABLE_PROP = SimpleFormatter.class.getName() + ".writeThrowable";

    public SimpleFormatter() {
        this(SimpleFormatter.getWriteThrowableProp());
    }

    public SimpleFormatter(boolean writeThrowable) {
        super((LogFormatter)null);
        this.m_writeThrowable = writeThrowable;
    }

    @Override
    public String format(LogRecord rec) {
        LogMessage msg = this.toLogMessage(rec);
        StringBuffer sb = new StringBuffer(80);
        sb.append(this.m_dateFormat.format(new Date(msg.getTimestamp())));
        sb.append(" ");
        MessageType msgtype = msg.getMessageType();
        sb.append(msgtype.toString());
        if (msg.getMessageLevel() > 1 && msgtype != MessageType.UNKNOWN) {
            sb.append(":");
            sb.append(msg.getMessageLevel());
        }
        sb.append(" ");
        String msgId = msg.getMessageId();
        if (msgId != null) {
            sb.append(msgId);
            sb.append(" ");
        }
        sb.append(msg.getMessageText());
        sb.append(LSEP);
        if (this.m_writeThrowable && rec.getThrown() != null) {
            sb.append(this.writeStackTrace(rec.getThrown()));
        }
        return sb.toString();
    }

    @Override
    public String getHead(Handler h) {
        return "";
    }

    @Override
    public String getTail(Handler h) {
        return "";
    }

    private static boolean getWriteThrowableProp() {
        String prop = LogManager.getLogManager().getProperty(WRITE_THROWABLE_PROP);
        return "true".equalsIgnoreCase(prop);
    }
}

