/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.plugin.DB2Capturer;
import oracle.dbtools.migration.workbench.plugin.DB2Plugin;

public class DB2Provider
extends ThirdPartyDbProvider {
    private DB2Capturer m_capturer;
    private String m_label;
    private DB2Plugin m_plugin;

    public DB2Provider(DB2Plugin dB2Plugin, Connection connection) {
        super(connection);
        this.m_plugin = dB2Plugin;
    }

    public OnlineCapturer getCapturer(MigrationStorer migrationStorer) {
        if (this.m_capturer == null) {
            this.m_capturer = this.m_plugin.getCapturer(migrationStorer, this._conn);
        }
        return this.m_capturer;
    }

    public String getConnectionLabel() {
        if (this.m_label == null) {
            try {
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                String string = databaseMetaData.getURL();
                String[] stringArray = string.split("/");
                this.m_label = "\\\\" + stringArray[2] + "\\" + this.getConnection().getCatalog() + " (" + databaseMetaData.getDatabaseProductName() + ")";
            }
            catch (SQLException sQLException) {
                this.m_label = null;
            }
        }
        return this.m_label;
    }
}

