/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ddtestframework;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import oracle.dbtools.ddtestframework.DDTestResult;
import oracle.dbtools.ddtestframework.DDTestSuite;
import oracle.dbtools.ddtestframework.FileUtil;

public abstract class ADDTestCase
extends TestCase {
    protected String m_rootPath;
    protected String m_extPathToSourceFile;
    protected String m_testFileName = null;
    protected String m_pathSourceFile;
    protected String m_pathGoldFile;
    protected String m_pathGenFile;
    protected String m_testRunName = null;
    protected String m_sourceText = null;
    protected String m_goldText = null;
    protected String m_genText = null;
    protected TestSuite m_testsuite = null;
    protected static TestResult m_result = null;

    public String getExtPathToSourceFile() {
        return this.m_extPathToSourceFile;
    }

    protected void setUp() {
        this.m_sourceText = this.getSourceText();
        this.m_goldText = this.getGoldText();
        if (this.m_goldText == null || this.m_goldText.trim().equals("")) {
            ((DDTestSuite)this.m_testsuite).addGoldNotFound(this);
        }
    }

    public void setExtPathToSourceFile(String string) {
        this.m_extPathToSourceFile = string;
    }

    protected void tearDown() {
        this.m_sourceText = null;
        this.m_goldText = null;
    }

    public ADDTestCase(String string) {
        super(string);
    }

    public ADDTestCase(String string, File file, String string2, TestSuite testSuite) {
        super(string);
        this.init(string, file, string2, testSuite);
    }

    public void init(String string, File file, String string2, TestSuite testSuite) {
        this.m_testRunName = string;
        this.m_testFileName = file.getName();
        this.m_rootPath = string2;
        this.m_testsuite = testSuite;
        String string3 = file.getPath();
        this.m_extPathToSourceFile = string3.substring(string3.indexOf(File.separator + "source" + File.separator) + 7);
        this.m_pathSourceFile = this.m_rootPath + File.separator + "source" + this.m_extPathToSourceFile;
        this.m_pathGoldFile = this.m_rootPath + File.separator + "gold" + this.m_extPathToSourceFile;
        this.m_pathGenFile = this.m_rootPath + File.separator + "gen" + this.m_extPathToSourceFile;
    }

    public String toString() {
        String string = this.m_extPathToSourceFile;
        return string;
    }

    public String getSourceText() {
        return FileUtil.readFile(this.m_pathSourceFile);
    }

    public String getGoldText() {
        return FileUtil.readFile(this.m_pathGoldFile);
    }

    public void saveGen(String string) {
        this.saveTarget(string, this.m_pathGenFile);
    }

    public void saveTarget(String string, String string2) {
        File file = new File(string2);
        try {
            file.getParentFile().mkdirs();
            FileUtil.appendToFile(file, string);
        }
        catch (IOException iOException) {
            ADDTestCase.fail((String)("\nproblem writing to file :" + string2));
        }
    }

    public boolean compareTexts(String string, String string2) {
        return string.equals(string2);
    }

    public boolean compareTextsIgnoreWS(String string, String string2) {
        string = this.removeWS(string);
        string2 = this.removeWS(string2);
        return string.equals(string2);
    }

    private String removeWS(String string) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("");
        for (String string2 : stringArray = string.trim().split("\\s")) {
            stringBuffer = stringBuffer.append(string2.trim());
        }
        return stringBuffer.toString().toLowerCase();
    }

    public void run(TestResult testResult) {
        m_result = testResult;
        super.run(testResult);
    }

    public TestResult run() {
        return super.run();
    }

    public void runBare() throws Throwable {
        super.runBare();
    }

    public void assertTrueDDTest(boolean bl) {
        TestCase.assertTrue((boolean)bl);
        if (bl && m_result instanceof DDTestResult) {
            ((DDTestResult)m_result).addSuccess(this);
        }
    }

    public void assertTrueDDTest(String string, boolean bl) {
        TestCase.assertTrue((String)string, (boolean)bl);
        if (bl && m_result instanceof DDTestResult) {
            ((DDTestResult)m_result).addSuccess(this);
        }
    }

    public void testGoldComparisonIgnoreWS() {
        this.m_genText = this.generateResult();
        this.saveGen(this.m_genText);
        boolean bl = this.compareTextsIgnoreWS(this.m_genText, this.m_goldText);
        this.assertTrueDDTest("\n" + this.m_extPathToSourceFile + "\n", bl);
    }

    protected abstract String generateResult();

    public void testGoldComparison() {
        this.m_genText = this.generateResult();
        boolean bl = this.compareTexts(this.m_genText, this.m_goldText);
        this.assertTrueDDTest("\n" + this.m_extPathToSourceFile + "\n", bl);
    }

    public static TestResult getResult() {
        return m_result;
    }

    public static void setResult(TestResult testResult) {
        m_result = testResult;
    }

    public String getGenText() {
        return this.m_genText;
    }

    public void setGenText(String string) {
        this.m_genText = string;
    }

    public String getPathGenFile() {
        return this.m_pathGenFile;
    }

    public void setPathGenFile(String string) {
        this.m_pathGenFile = string;
    }

    public String getPathGoldFile() {
        return this.m_pathGoldFile;
    }

    public void setPathGoldFile(String string) {
        this.m_pathGoldFile = string;
    }

    public String getPathSourceFile() {
        return this.m_pathSourceFile;
    }

    public void setPathSourceFile(String string) {
        this.m_pathSourceFile = string;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public void setRootPath(String string) {
        this.m_rootPath = string;
    }

    public String getTestFileName() {
        return this.m_testFileName;
    }

    public void setTestFileName(String string) {
        this.m_testFileName = string;
    }

    public String getTestRunName() {
        return this.m_testRunName;
    }

    public void setTestRunName(String string) {
        this.m_testRunName = string;
    }

    public void setGoldText(String string) {
        this.m_goldText = string;
    }

    public void setSourceText(String string) {
        this.m_sourceText = string;
    }
}

