/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.sql.CHAR;

public class RaptorGridCopyAdapter {
    protected final RaptorGridTable _grid;
    protected final String EMPTY_STRING = "";
    protected String _nullValue = "";

    public RaptorGridCopyAdapter(RaptorGridTable raptorGridTable) {
        this._grid = raptorGridTable;
    }

    public void setNullString(String string) {
        this._nullValue = string;
    }

    public String getNullString() {
        return this._nullValue;
    }

    public boolean canCopy() {
        return this._grid.getColumnSelectionAllowed() && !this._grid.getRowSelectionAllowed() || !this._grid.getColumnSelectionAllowed() && this._grid.getRowSelectionAllowed() || this._grid.getCellSelectionEnabled();
    }

    public boolean canCopyHeader() {
        return this.canCopy();
    }

    public boolean canCut() {
        if (this._grid.isEditable()) {
            return this.canCopy();
        }
        return false;
    }

    public boolean canPaste() {
        return this._grid.isEditable();
    }

    public boolean copyToClipboard(String string, String string2, CopyData copyData, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = this.copyToBuffer(stringBuilder, string, string2, copyData, bl);
        if (bl2) {
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            ClipboardStack.pushCurrentClipboard();
            clipboard.setContents(stringSelection, stringSelection);
        }
        return bl2;
    }

    public boolean copyToClipboard() {
        return this.copyToClipboard(false, false);
    }

    public boolean copyToClipboard(boolean bl) {
        return this.copyToClipboard(bl, false);
    }

    public void copyHeadertoClipboard() {
        this.copyToClipboard(", ", null, CopyData.SKIP, true);
    }

    public boolean copyToClipboard(boolean bl, boolean bl2) {
        return this.copyToClipboard("\t", "\n", bl ? CopyData.CUT : CopyData.COPY, bl2);
    }

    public boolean copyToBuffer(StringBuilder stringBuilder, String string, String string2, CopyData copyData, boolean bl) {
        return this.copyToBuffer(stringBuilder, string, string2, copyData, bl, false);
    }

    public boolean copyToBuffer(StringBuilder stringBuilder, String string, String string2, CopyData copyData, boolean bl, boolean bl2) {
        RaptorGridTable.RowSelectionIterator rowSelectionIterator = this._grid.iterator();
        if (rowSelectionIterator != null) {
            int n = 0;
            while (rowSelectionIterator.hasNext()) {
                String string3;
                int n2;
                int n3;
                RaptorGridTable.ColumnSelectionIterator columnSelectionIterator = rowSelectionIterator.next();
                int n4 = columnSelectionIterator.getRowIndex();
                if (bl && n == 0) {
                    n3 = 0;
                    while (columnSelectionIterator.hasNext()) {
                        n2 = columnSelectionIterator.next();
                        if (n3 > 0) {
                            stringBuilder.append(string);
                        }
                        string3 = this.sanitizeStringForCopy(this.getColumnName(n2));
                        stringBuilder.append(string3);
                        ++n3;
                    }
                    columnSelectionIterator.setNext(n4);
                    if (copyData != CopyData.SKIP && n3 > 0) {
                        stringBuilder.append(string2);
                    }
                }
                if (copyData != CopyData.SKIP) {
                    if (n > 0) {
                        stringBuilder.append(string2);
                    }
                    n3 = 0;
                    while (columnSelectionIterator.hasNext()) {
                        n2 = columnSelectionIterator.next();
                        if (n3 > 0) {
                            stringBuilder.append(string);
                        }
                        string3 = this.getPastableCellValue(n4, n2);
                        string3 = this.decodeDrillLink(string3);
                        if (bl2) {
                            Class<?> clazz;
                            Object object = this._grid.getValueAt(n4, n2);
                            Class<?> clazz2 = clazz = null == object ? null : object.getClass();
                            if (CHAR.class == clazz) {
                                string3 = '\'' + string3 + '\'';
                            }
                        }
                        stringBuilder.append(this.sanitizeStringForCopy(string3));
                        if (copyData == CopyData.CUT && this._grid.isEditable()) {
                            if (this._grid.isEditing()) {
                                this._grid.getCellEditor().cancelCellEditing();
                            }
                            this.pasteCellValue("", n4, n2);
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            if (copyData == CopyData.CUT) {
                this._grid.repaint();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteToJTable() {
        block19: {
            RaptorGridTable.RowSelectionIterator rowSelectionIterator;
            if (this._grid.isEditable() && (rowSelectionIterator = this._grid.iterator()) != null) {
                try {
                    int n = rowSelectionIterator.getRowCount();
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    String string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                    ClipBoardPasteAdapter clipBoardPasteAdapter = new ClipBoardPasteAdapter(string);
                    try {
                        List list = clipBoardPasteAdapter.readAllRows();
                        if (list.size() <= 0) break block19;
                        int[] nArray = null;
                        int[] nArray2 = new int[list.size()];
                        while (rowSelectionIterator.hasNext()) {
                            int n2;
                            int n3;
                            String[] stringArray;
                            int n4;
                            RaptorGridTable.ColumnSelectionIterator columnSelectionIterator;
                            int n5 = 0;
                            while (n5 < nArray2.length && rowSelectionIterator.hasNext()) {
                                columnSelectionIterator = rowSelectionIterator.next();
                                if (nArray == null) {
                                    nArray = columnSelectionIterator.getSelectedColumns();
                                }
                                nArray2[n5++] = columnSelectionIterator.getRowIndex();
                            }
                            if (n5 <= 0) continue;
                            columnSelectionIterator = list.iterator();
                            if (n == 1 && n5 == 1 && nArray.length == 1 && !rowSelectionIterator.hasNext()) {
                                for (n4 = nArray2[0]; n4 < this._grid.getRowCount() && columnSelectionIterator.hasNext(); ++n4) {
                                    stringArray = (String[])columnSelectionIterator.next();
                                    n3 = nArray[0];
                                    for (n2 = 0; n2 < stringArray.length && n3 < this._grid.getColumnCount(); ++n2, ++n3) {
                                        if (!this.valueCanBePasted(n4, n3)) continue;
                                        if (this._grid.isEditing()) {
                                            this._grid.getCellEditor().cancelCellEditing();
                                        }
                                        this.pasteCellValue(stringArray[n2], n4, n3);
                                    }
                                }
                                break;
                            }
                            if (n5 < list.size()) {
                                break;
                            }
                            block9: for (n4 = 0; n4 < nArray2.length && columnSelectionIterator.hasNext(); ++n4) {
                                stringArray = (String[])columnSelectionIterator.next();
                                n3 = nArray2[n4];
                                if (stringArray.length > 0 && n3 < this._grid.getRowCount()) {
                                    for (n2 = 0; n2 < nArray.length && (n2 <= 0 || stringArray.length == 1); n2 += stringArray.length) {
                                        for (int i = 0; i < stringArray.length && i + n2 < nArray.length; ++i) {
                                            int n6 = nArray[i + n2];
                                            if (n6 >= this._grid.getColumnCount()) continue block9;
                                            if (!this.valueCanBePasted(n3, n6)) continue;
                                            if (this._grid.isEditing()) {
                                                this._grid.getCellEditor().cancelCellEditing();
                                            }
                                            this.pasteCellValue(stringArray[i], n3, n6);
                                        }
                                    }
                                    continue;
                                }
                                break block19;
                            }
                        }
                    }
                    finally {
                        clipBoardPasteAdapter.close();
                        this._grid.repaint();
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
    }

    protected static int[] _getColumnList(RaptorGridTable raptorGridTable) {
        if (raptorGridTable == null) {
            return new int[0];
        }
        int n = raptorGridTable.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    protected String getPastableCellValue(int n, int n2) {
        String string;
        Object object = this._grid.getValueAt(n, n2);
        if (object instanceof JLabel) {
            AccessibleContext accessibleContext;
            JLabel jLabel = (JLabel)object;
            string = jLabel.getText();
            if (!(string != null && string.length() != 0 || (string = (accessibleContext = jLabel.getAccessibleContext()).getAccessibleName()) != null && string.length() != 0)) {
                string = accessibleContext.getAccessibleDescription();
            }
        } else {
            string = object != null ? this.getValue(n, n2, Integer.MAX_VALUE) : this._nullValue;
        }
        return string;
    }

    protected String decodeDrillLink(String string) {
        String string2 = string;
        try {
            String string3 = ":";
            if (string != null && string.startsWith("SQLDEV:LINK")) {
                if (string2.startsWith("SQLDEV:LINK{")) {
                    int n = string2.indexOf(123) + 1;
                    int n2 = string2.indexOf(125);
                    string3 = string2.substring(n, n2);
                    string2 = string2.substring(n2 + 1);
                } else if (string2.startsWith("SQLDEV:LINK:")) {
                    string2 = string2.substring(string2.indexOf("LINK:") + 5);
                }
                String[] stringArray = string2.split(string3);
                string2 = stringArray[stringArray.length - 2];
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return string2 != null && string2.length() > 0 ? string2 : string;
    }

    protected void pasteCellValue(String string, int n, int n2) {
        this.setValue(string, n, n2);
    }

    protected String getValue(int n, int n2, int n3) {
        String string = this._grid.getDisplayValueAt(n, n2, n3);
        return string != null ? string : this._nullValue;
    }

    protected void setValue(String string, int n, int n2) {
        this._grid.setFromDisplayValueAt(string, n, n2);
    }

    private String sanitizeStringForCopy(String string) {
        String string2 = "\r\n|[\r\n\u2028\u2029\u0085]|\t";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return "\"" + string + "\"";
        }
        return string;
    }

    protected String getColumnName(int n) {
        return this._grid.getColumnName(n);
    }

    protected boolean valueCanBePasted(int n, int n2) {
        return this._grid.isCellEditable(n, n2);
    }

    private class ClipBoardPasteAdapter {
        private BufferedReader _reader;
        public boolean _hasMore = true;
        private char _separator = (char)9;
        private char _quotechar = (char)34;

        public ClipBoardPasteAdapter(String string) {
            this(new BufferedReader(new StringReader(string)));
        }

        public ClipBoardPasteAdapter(BufferedReader bufferedReader) {
            this._reader = bufferedReader;
        }

        public List readAllRows() throws IOException {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while (this._hasMore) {
                String[] stringArray = this.readNextRow();
                if (stringArray == null) continue;
                arrayList.add(stringArray);
            }
            return arrayList;
        }

        public String[] readNextRow() throws IOException {
            String string = this.getNextRow();
            return this._hasMore ? this.parseRow(string) : null;
        }

        private String getNextRow() throws IOException {
            String string = this._reader.readLine();
            if (string == null) {
                this._hasMore = false;
            }
            return this._hasMore ? string : null;
        }

        private String[] parseRow(String string) throws IOException {
            if (string == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            do {
                if (bl) {
                    stringBuffer.append("\n");
                    string = this.getNextRow();
                    if (string == null) break;
                }
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == this._separator && !bl) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                    stringBuffer.append(c);
                }
            } while (bl);
            arrayList.add(stringBuffer.toString());
            return arrayList.toArray(new String[0]);
        }

        public void close() throws IOException {
            this._reader.close();
        }
    }

    public static enum CopyData {
        SKIP,
        COPY,
        CUT;

    }
}

