/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyListener;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.icons.OracleIcons;

public class CountRows
extends GridContextMenuItem {
    private static CountRows _instance = null;
    public static final String _cmdGridCountRows = "cmdGridCountRows";
    public static final int _cmdIdGridCountRows = Ide.findOrCreateCmdID((String)"cmdGridCountRows");
    private IdeAction _actionGridCountRows;
    private String total_Rows_Message = "<html><font color={0} size=+{1}><b>{2}</b></font>{3}</html>";
    private String total_Rows_Message_Selected = "<html><u><font color={0} size=+{1}><b>{2}</b></font>{3}</u></html>";
    private JEWTDialog dialog = null;
    private int totalrows;

    private CountRows() {
        this.initAction();
    }

    public static CountRows getInstance() {
        if (_instance == null) {
            _instance = new CountRows();
        }
        return _instance;
    }

    private void initAction() {
        if (this._actionGridCountRows == null) {
            this._actionGridCountRows = this.createAction(_cmdIdGridCountRows, Messages.getString("CountRows.1"), null);
        }
    }

    @Override
    protected boolean canShow(ContextMenu contextMenu) {
        return true;
    }

    @Override
    protected void createAndShowMenu(ContextMenu contextMenu) {
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._actionGridCountRows);
        contextMenu.add((Component)jMenuItem);
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        AbstractRaptorGridModel abstractRaptorGridModel;
        if (ideAction.getCommandId() == _cmdIdGridCountRows && this._table != null && (abstractRaptorGridModel = this._table.getGridModel()) != null) {
            CountRowsTask countRowsTask = new CountRowsTask((String)this._actionGridCountRows.getValue("Name"));
            RaptorTaskManager.getInstance().addTask((RaptorTask)countRowsTask);
            return true;
        }
        return false;
    }

    protected void showCountRowsDialog() {
        Object object;
        AbstractRaptorGridModel abstractRaptorGridModel = this._table.getGridModel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        String string = MessageFormat.format(this.total_Rows_Message, "black", 1.5, this.totalrows, Messages.getString("CountRows.2"));
        JLabel jLabel = new JLabel(string);
        jPanel.add((Component)jLabel, gridBagConstraints);
        final boolean bl = this._table.isFilterApplied();
        final int n = abstractRaptorGridModel.getTotalRows(true);
        JLabel jLabel2 = new JLabel();
        if (bl) {
            object = MessageFormat.format(this.total_Rows_Message, "black", 1.5, n, Messages.getString("CountRows.3"));
            jLabel2.setText((String)object);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            jPanel.add((Component)jLabel2, gridBagConstraints);
        }
        object = new SmallSquareButton(OracleIcons.getIcon((String)"copy.png"), Messages.getString("CountRows.0"));
        object.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CountRows.this.totalrows + " " + Messages.getString("CountRows.2");
                if (bl) {
                    string = string + "\n" + n + " " + Messages.getString("CountRows.3");
                }
                StringSelection stringSelection = new StringSelection(string);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                ClipboardStack.pushCurrentClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        if (bl) {
            gridBagConstraints.gridheight = 2;
        }
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        jPanel.add((Component)object, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(16, 10, 10, 10);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, gridBagConstraints);
        this.dialog = UIUtils.createPanelDialog(jPanel2, Messages.getString("CountRows.4"), null, 1);
        for (ComponentListener componentListener : this.dialog.getComponentListeners()) {
            if (componentListener.getClass().getEnclosingClass() != DialogSizeKeeper.class) continue;
            this.dialog.removeComponentListener(componentListener);
            this.dialog.removeHierarchyListener((HierarchyListener)((Object)componentListener));
        }
        this.dialog.setMinimumSize(200, 100);
        this.dialog.runDialog();
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private class CountRowsTask
    extends RaptorTask<Void> {
        public CountRowsTask(String string) {
            super(string, true, IRaptorTaskRunMode.TASKVIEWER);
            CountRows.this.totalrows = 0;
            this.getDescriptor().addListener((IRaptorTaskListener)new WaitOver());
        }

        protected Void doWork() throws TaskException {
            try {
                CountRows.this.totalrows = CountRows.this._table.getGridModel().getTotalRows(false);
                return null;
            }
            catch (Throwable throwable) {
                throw new TaskException(throwable);
            }
        }

        protected void invokeLater() {
            CountRows.this.showCountRowsDialog();
        }

        private class WaitOver
        extends RaptorTaskAdapter {
            private WaitOver() {
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        CountRowsTask.this.invokeLater();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

