/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.awt.Font;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.NLSUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelFormatter
extends ResultsFormatter {
    public static final String TYPE = "Excel 95-2003 ( XLS)";
    public static final String EXT = "xls";
    public static final String KEY_HEADER = "EXPORT_XLS_HEADER";
    public static final String KEY_DATA_NAME = "EXPORT_XLS_WS_NAME";
    public static final String KEY_QUERY = "EXPORT_XLS_SAVE_QUERY";
    public static final String KEY_QUERY_NAME = "EXPORT_XLS_QUERY_WS_NAME";
    protected Workbook _wb;
    protected Sheet _ws;
    protected int _sheetIndex = 0;
    protected long _rownum;
    protected Row _currRow;
    private Cell _currCell;
    private CellStyle _rightAlign;
    private long _cell;
    private boolean _isHeader;
    private boolean _saveQuery;
    private boolean _isDataNameUser = false;
    private String _queryName;
    private String _dataName;
    private String _dataNameUser;
    private String _tableName;

    public ExcelFormatter() {
        super(TYPE, "XLS", EXT);
    }

    public ExcelFormatter(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public void startExport() {
        this._isDataNameUser = false;
        this._dataNameUser = "";
    }

    public boolean isTextEditorReadable() {
        return false;
    }

    protected Workbook newWorkbook() {
        return new HSSFWorkbook();
    }

    protected void createWorkBook() {
        if (this._sheetIndex == 0) {
            this._wb = this.newWorkbook();
        }
        this._dataName = this._isDataNameUser ? this._dataNameUser : (this._tableName != null && this._tableName.trim().length() > 0 ? this._tableName : Messages.getString((String)"ExcelFormatter.3"));
        this._dataName = this.getUniqueSheetName(this._dataName);
        this._ws = this._wb.createSheet(this._dataName);
    }

    private String getUniqueSheetName(String string) {
        Integer n = new Integer(1);
        String string2 = string.replaceAll("[\\\\\\[\\]\\?\\*\\:\\/]", "");
        int n2 = string.length();
        if (n2 > 30) {
            string2 = string.substring(0, 30);
        }
        String string3 = string2;
        Sheet sheet = this._wb.getSheet(string2);
        while (sheet != null) {
            n = n + 1;
            string2 = string3 + "_" + n.toString();
            sheet = this._wb.getSheet(string2);
            if (sheet != null || string2.length() <= 30) continue;
            if ((string3 = string3.substring(0, string3.length() - 1)).length() < 2) {
                return string3;
            }
            n = 1;
            string2 = string3;
            sheet = this._wb.getSheet(string2);
        }
        return string2;
    }

    public void start() throws IOException {
        this.createWorkBook();
        this._rightAlign = this._wb.createCellStyle();
        this._rightAlign.setAlignment(HorizontalAlignment.RIGHT);
        org.apache.poi.ss.usermodel.Font font = this._wb.createFont();
        font.setFontName(Font.decode(null).getName());
        this._rightAlign.setFont(font);
        this._currRow = null;
        this._currCell = null;
        if (this.isHeader()) {
            this._rownum = 0L;
            short s = Short.valueOf("" + this._rownum);
            this._currRow = this._ws.createRow((int)s);
            int n = 0;
            int n2 = this.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                this._currCell = this._currRow.createCell(n);
                this._currCell.setCellValue(this.getColumnName(i));
                ++n;
            }
            this._ws.createFreezePane(0, 1, 0, 1);
        } else {
            this._rownum = -1L;
        }
    }

    public void startRow() throws IOException {
        if (this._rownum > (long)this.getRowLimit()) {
            this._ws = this._wb.createSheet();
            this._rownum = 0L;
        }
        ++this._rownum;
        int n = Integer.valueOf(new String("" + this._rownum));
        this._currRow = this._ws.createRow(n);
    }

    protected int getRowLimit() {
        return 65000;
    }

    public void printColumn(Object object, int n) throws IOException {
    }

    public void endRow() throws IOException {
        this._cell = 0L;
    }

    public void end() throws IOException {
        String string;
        if (this._saveQuery && (string = this.getWrapper().getSQL()) != null) {
            this._ws = this._wb.getSheetAt(this._sheetIndex);
            this._ws.setFitToPage(true);
            if (this._queryName == null || this._queryName.trim().length() == 0) {
                this._queryName = "SQL";
            }
            this._ws = this._wb.getSheet(this._queryName);
            if (this._ws == null) {
                this._ws = this._wb.createSheet(this._queryName);
            }
            this._currRow = this._ws.createRow(this._sheetIndex + 1);
            int n = 0;
            this._currCell = this._currRow.createCell(n);
            this._currCell.setCellValue(string);
            n = 1;
        }
        ++this._sheetIndex;
    }

    public boolean isStreamHandler() {
        return true;
    }

    public void closeStream() {
        try {
            this._wb.write(this.getOutputStream());
            this.getOutputStream().close();
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this._sheetIndex = 0;
        this._wb = null;
        this._ws = null;
    }

    public void setTableName(String string) {
        this._tableName = string;
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        this._currCell = this._currRow.createCell(n);
        ++this._cell;
        int n3 = 0;
        try {
            n3 = this.getDataType(n);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        switch (n3) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                BigDecimal bigDecimal = null;
                if (object != null) {
                    this._currCell.setCellStyle(this._rightAlign);
                    try {
                        bigDecimal = new BigDecimal(object.toString());
                    }
                    catch (Exception exception) {
                        bigDecimal = new BigDecimal(this.getValue(object).replace(",", "."));
                    }
                    NLSUtils.format((Connection)this.getConnection(), (Object)bigDecimal);
                    this._currCell.setCellValue(bigDecimal.doubleValue());
                    break;
                }
                this._currCell.setCellValue("");
                break;
            }
            case 12: {
                if (object == null) break;
                this._currCell.setCellValue(this.getValue(object));
                break;
            }
            default: {
                if (object == null) break;
                this._currCell.setCellValue(this.getValue(object));
            }
        }
    }

    public boolean allowsLobs() {
        return true;
    }

    public boolean isHeaderOptionSupported() {
        return true;
    }

    public void isHeader(boolean bl) {
        this._isHeader = bl;
    }

    public boolean isHeader() {
        return this._isHeader;
    }

    public boolean isDataNameSupported() {
        return true;
    }

    public String getDataName() {
        return this._dataName;
    }

    public void setDataName(String string) {
        if (string != null & string.length() > 0) {
            this._isDataNameUser = true;
            this._dataNameUser = string;
        }
    }

    public boolean isQuerySupported() {
        return true;
    }

    public boolean isQuerySaved() {
        return this._saveQuery;
    }

    public void isQuerySaved(boolean bl) {
        this._saveQuery = bl;
    }

    public String getQueryName() {
        return this._queryName;
    }

    public void setQueryName(String string) {
        this._queryName = string;
    }

    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    public String getDataNameConfigKey() {
        return KEY_DATA_NAME;
    }

    public String getQueryConfigKey() {
        return KEY_QUERY;
    }

    public String getQueryNameConfigKey() {
        return KEY_QUERY_NAME;
    }

    public int validateOptions() {
        int n = 0;
        try {
            if (this._saveQuery && this._queryName != null && this._dataName != null && this._queryName.trim().equals(this._dataName.trim()) && this._queryName.trim().length() > 0) {
                this.setValidationMessage(Messages.getString((String)"XLSFormatter.NameError"));
                n = 1;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return n;
    }

    protected String getValue(Object object) {
        try {
            if (object instanceof Clob) {
                Clob clob = (Clob)object;
                int n = 4000;
                StringBuffer stringBuffer = new StringBuffer();
                while ((long)stringBuffer.length() < clob.length()) {
                    stringBuffer.append(clob.getSubString(stringBuffer.length() + 1, n));
                }
                return stringBuffer.toString();
            }
            return super.getValue(object).toString();
        }
        catch (Exception exception) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }
}

