/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.javatools.util.PlatformUtils;

public class LDAPHelper {
    private static final String NETWORK_ADMIN_PATH = File.separator + "network" + File.separator + "admin";
    private static final String LDAP_ADMIN_PATH = File.separator + "ldap" + File.separator + "admin";
    private static FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.equalsIgnoreCase(".ldap") || string.toLowerCase().equals("ldap.ora");
        }
    };
    private static final String LDAP_DB_FILTER = "(|(objectClass=orclNetService)(objectClass=orclService)(objectClass=orclDBServer)(objectClass=orclNetServiceAlias))";
    private static final String LDAP_CONTEXT_FILTER = "(objectClass=orclContext)";
    private static Map<String, TCPTNSEntry> dbServices = null;

    public static void main(String[] stringArray) throws Exception {
        List<String> list = LDAPHelper.getLDAPServers();
        if (list != null) {
            for (String string : list) {
                System.out.println("Server: " + string);
                List<String> list2 = LDAPHelper.getLDAPContexts(string);
                if (list2 == null) continue;
                for (String string2 : list2) {
                    System.out.println("  Context: " + string2);
                    List<String> list3 = LDAPHelper.getOrclServiceEntries(string, string2);
                    if (list3 == null) continue;
                    for (String string3 : list3) {
                        System.out.println("    Entry: " + string3 + ":" + dbServices.get(string3).getDescriptor());
                    }
                }
            }
        }
    }

    public static List<String> getOrclServiceEntries(String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.security.authentication", "simple");
            String string3 = LDAPHelper.stripLdapHost(string);
            String string4 = LDAPHelper.stripLdapPort(string);
            String string5 = new String("ldap://" + string3 + ":" + string4);
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            hashtable.put("java.naming.provider.url", string5);
            hashtable.put("java.naming.ldap.derefAliases", "never");
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String[] stringArray = new String[]{"cn", "orclsid", "orcldbglobalname", "orclnetdescstring", "aliasedobjectname", "orclnetdescname"};
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(stringArray);
            searchControls.setSearchScope(2);
            SearchControls searchControls2 = new SearchControls();
            searchControls2.setReturningAttributes(stringArray);
            searchControls2.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string2, LDAP_DB_FILTER, searchControls);
            ArrayList arrayList2 = new ArrayList();
            if (namingEnumeration != null) {
                dbServices = new HashMap<String, TCPTNSEntry>();
                while (namingEnumeration.hasMoreElements()) {
                    try {
                        SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                        Attribute attribute = searchResult.getAttributes().get("cn");
                        Attribute attribute2 = searchResult.getAttributes().get("orclnetdescstring");
                        Attribute attribute3 = searchResult.getAttributes().get("orclnetdescname");
                        if (attribute2 == null) {
                            if (attribute3 != null && attribute3.get() != null && attribute3.get().toString() != null && attribute3.get().toString().replaceAll("\\s+", "").toLowerCase().startsWith("(desc")) {
                                attribute2 = attribute3;
                            } else if (searchResult.getAttributes().get("aliasedobjectname") != null) {
                                attribute2 = LDAPHelper.getAliasDescription(string, searchResult.getAttributes().get("aliasedobjectname").get().toString(), hashtable, new HashSet<String>());
                            }
                        }
                        if (attribute2 != null && attribute != null) {
                            TCPTNSEntry tCPTNSEntry = new TCPTNSEntry(attribute.get().toString(), attribute2.get().toString());
                            dbServices.put(attribute.get().toString(), tCPTNSEntry);
                            arrayList.add(attribute.get().toString());
                            continue;
                        }
                        if (attribute == null) continue;
                        Logger.getLogger(LDAPHelper.class.getClass().getName()).log(Level.WARNING, "LDAP:" + attribute.get().toString());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(LDAPHelper.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            }
        }
        catch (NamingException namingException) {
            throw new Exception(namingException.getMessage());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attribute getAliasDescription(String string, String string2, Hashtable<String, String> hashtable, Set<String> set) throws Exception {
        if (!set.add(string2)) {
            return null;
        }
        Attribute attribute = null;
        Attribute attribute2 = null;
        SearchControls searchControls = new SearchControls();
        try (InitialDirContext initialDirContext = null;){
            initialDirContext = new InitialDirContext(hashtable);
            String[] stringArray = new String[]{"cn", "orclsid", "orcldbglobalname", "orclnetdescstring", "aliasedobjectname", "orclnetdescname"};
            searchControls.setReturningAttributes(stringArray);
            searchControls.setSearchScope(2);
            if (string2 != null) {
                NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string2, LDAP_DB_FILTER, searchControls);
                SearchResult searchResult = null;
                if (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                    searchResult = (SearchResult)namingEnumeration.nextElement();
                    attribute = searchResult.getAttributes().get("orclnetdescstring");
                    attribute2 = searchResult.getAttributes().get("orclnetdescname");
                }
                if (attribute == null && attribute2 != null && attribute2.get() != null && attribute2.get().toString() != null && attribute2.get().toString().replaceAll("\\s+", "").toLowerCase().startsWith("(desc")) {
                    attribute = attribute2;
                } else if (attribute == null && searchResult.getAttributes().get("aliasedobjectname") != null && searchResult.getAttributes().get("aliasedobjectname").get() != null) {
                    String string3 = searchResult.getAttributes().get("aliasedobjectname").get().toString();
                    attribute = LDAPHelper.getAliasDescription(string, string3, hashtable, set);
                }
            }
        }
        return attribute;
    }

    public static List<String> getLDAPContexts(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList();
        List<String> list = LDAPHelper.getLDAPDefaultAdmin();
        if (list != null) {
            arrayList = list;
        }
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.security.authentication", "simple");
            String string2 = LDAPHelper.stripLdapHost(string);
            String string3 = LDAPHelper.stripLdapPort(string);
            String string4 = new String("ldap://" + string2 + ":" + string3);
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            hashtable.put("java.naming.provider.url", string4);
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String[] stringArray = new String[]{"cn", "DN"};
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(stringArray);
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(initialDirContext.getNameInNamespace(), LDAP_CONTEXT_FILTER, searchControls);
            if (namingEnumeration != null) {
                while (namingEnumeration.hasMoreElements()) {
                    SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                    String string5 = searchResult.getNameInNamespace();
                    if (string5 == null || list != null && list.contains(string5)) continue;
                    arrayList.add(string5);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(LDAPHelper.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    public static List<String> getLDAPServers() {
        List<String> list = null;
        try {
            File file = LDAPHelper.getLDAPFile();
            if (file != null) {
                list = LDAPHelper.getLDAPServerEntries(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private static File getLDAPFile() {
        boolean bl;
        String string = System.getenv("ORACLE_HOME");
        String string2 = System.getenv("LDAP_ADMIN");
        String string3 = System.getenv("TNS_ADMIN");
        String string4 = System.getProperty("jdbc.driver.home");
        String string5 = System.getProperty("user.home");
        String string6 = null;
        if (LDAPHelper.checkForLDAP(string5)) {
            string6 = string5;
        }
        if (!(bl = PlatformUtils.isWindows()) && string6 == null && LDAPHelper.checkForLDAP("/etc")) {
            string6 = "/etc";
        }
        if (string6 == null && LDAPHelper.checkForLDAP(string2)) {
            string6 = string2;
        }
        if (string4 != null && string6 == null && LDAPHelper.checkForLDAP(string4 + LDAP_ADMIN_PATH)) {
            string6 = string4 + LDAP_ADMIN_PATH;
        }
        if (string != null && string6 == null && LDAPHelper.checkForLDAP(string + LDAP_ADMIN_PATH)) {
            string6 = string + LDAP_ADMIN_PATH;
        }
        if (string3 != null && string6 == null && LDAPHelper.checkForLDAP(string3)) {
            string6 = string3;
        }
        if (string4 != null && string6 == null && LDAPHelper.checkForLDAP(string4 + NETWORK_ADMIN_PATH)) {
            string6 = string4 + NETWORK_ADMIN_PATH;
        }
        if (string != null && string6 == null && LDAPHelper.checkForLDAP(string + NETWORK_ADMIN_PATH)) {
            string6 = string + NETWORK_ADMIN_PATH;
        }
        if (string6 == null && bl) {
            string = null;
            try {
                RegistryKey registryKey;
                String string7 = "SOFTWARE\\ORACLE";
                String string8 = null;
                NativeHandler nativeHandler = new NativeHandler();
                nativeHandler.initialize();
                RegistryKey registryKey2 = NativeHandler.getRegistry().getLocalMachineKey().openKey(string7, 131097L);
                Iterator iterator = registryKey2.iterateSubKeys();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    e.toString();
                    try {
                        String string9 = string7 + "\\" + e.toString();
                        registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(string9, 131097L);
                        string8 = registryKey.getStringValue("ORACLE_HOME_KEY");
                    }
                    catch (RegistryException registryException) {}
                }
                if (string8 != null) {
                    registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(string8, 131097L);
                    string = registryKey.getStringValue("ORACLE_HOME");
                }
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                Logger.getLogger(LDAPHelper.class.getClass().getName()).log(Level.WARNING, registryNotAvailableException.getStackTrace()[0].toString(), registryNotAvailableException);
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
            if (string != null) {
                string6 = string + NETWORK_ADMIN_PATH;
            }
        }
        return string6 != null ? new File(string6) : null;
    }

    private static List<String> getLDAPDefaultAdmin() {
        List<String> list = null;
        try {
            File file = LDAPHelper.getLDAPFile();
            if (file != null) {
                list = LDAPHelper.getLDAPDefaultAdminEntries(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private static List<String> getLDAPDefaultAdminEntries(File file) {
        ArrayList<String> arrayList;
        block6: {
            block5: {
                arrayList = new ArrayList<String>();
                if (file == null || !file.exists() || !file.isDirectory()) break block5;
                for (File file2 : file.listFiles(filter)) {
                    arrayList.addAll(LDAPHelper.getLDAPDefaultAdminEntries(file2));
                }
                break block6;
            }
            if (file == null || !file.exists()) break block6;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.trim().startsWith("DEFAULT_ADMIN_CONTEXT")) continue;
                    int n = string.indexOf("\"");
                    int n2 = string.lastIndexOf("\"");
                    if (n == -1 || n2 == -1 || n2 <= n) continue;
                    string = string.substring(n + 1, n2);
                    arrayList.add(string);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static List<String> getLDAPServerEntries(File file) {
        ArrayList<String> arrayList;
        block7: {
            block6: {
                arrayList = new ArrayList<String>();
                if (file == null || !file.exists() || !file.isDirectory()) break block6;
                for (File file2 : file.listFiles(filter)) {
                    arrayList.addAll(LDAPHelper.getLDAPServerEntries(file2));
                }
                break block7;
            }
            if (file == null || !file.exists()) break block7;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("DIRECTORY_SERVERS")) continue;
                    string = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (string2 == null) continue;
                        arrayList.add(string2.trim());
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static boolean checkForLDAP(String string) {
        File file;
        boolean bl = false;
        if (string != null && (file = new File(string)).exists() && file.listFiles(filter).length > 0) {
            bl = true;
        }
        return bl;
    }

    public static TCPTNSEntry getEntry(String string) {
        return dbServices.get(string);
    }

    public static String stripLdapHost(String string) {
        String string2 = string.substring(0, string.indexOf(":"));
        return string2.trim();
    }

    public static String stripLdapPort(String string) {
        String string2;
        String string3 = string2 = string.substring(string.indexOf(":") + 1);
        if (string2.indexOf(":") != -1) {
            string3 = string2.substring(0, string2.indexOf(":"));
        }
        return string3.trim();
    }
}

