/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.objectpriv.IObjectCheck;

public class HCSObjectCheck
implements IObjectCheck {
    private static final Logger LOG = Logger.getLogger(HCSObjectCheck.class.getName());
    private static String[] CREATE_PRIVS = new String[]{"CREATE ANY ATTRIBUTE DIMENSION", "CREATE ANY HIERARCHY", "CREATE ANY ANALYTIC VIEW"};
    private static String[] ALTER_PRIVS = new String[]{"ATTRIBUTE DIMENSION", "ALTER ANY ATTRIBUTE DIMENSION", "HIERARCHY", "ALTER ANY HIERARCHY", "ANALYTIC VIEW", "ALTER ANY ANALYTIC VIEW"};
    private static String[] DROP_PRIVS = new String[]{"ATTRIBUTE DIMENSION", "DROP ANY ATTRIBUTE DIMENSION", "HIERARCHY", "DROP ANY HIERARCHY", "ANALYTIC VIEW", "DROP ANY ANALYTIC VIEW"};
    private static String[] TYPES = new String[]{"ATTRIBUTE DIMENSION", "HIERARCHY", "ANALYTIC VIEW"};

    public boolean canCreate(DBObject dBObject) {
        return this.checkPriv(dBObject, CREATE_PRIVS);
    }

    public boolean canAlter(DBObject dBObject) {
        boolean bl = this.checkPriv(dBObject, ALTER_PRIVS);
        if (!bl) {
            String string = dBObject.getObjectType();
            String string2 = this.getType(string, TYPES);
            bl = this.checkObjectPriv(dBObject, string, string2);
        }
        return bl;
    }

    public boolean canDrop(DBObject dBObject) {
        boolean bl = this.checkPriv(dBObject, DROP_PRIVS);
        if (!bl) {
            String string = dBObject.getObjectType();
            String string2 = this.getType(string, TYPES);
            bl = this.checkObjectPriv(dBObject, string, string2);
        }
        return bl;
    }

    private boolean checkPriv(DBObject dBObject, String[] stringArray) {
        String string = dBObject.getObjectType();
        String string2 = this.getType(string, stringArray);
        boolean bl = false;
        if (string2 != null) {
            bl = this.checkPriv(dBObject, string2);
        }
        return bl;
    }

    private boolean checkPriv(DBObject dBObject, String string) {
        String string2 = null;
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("privilege", string);
            string2 = dBUtil.executeReturnOneCol("select count(*) from session_privs where privilege = :privilege", hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
        }
        return string2 != null && string2.equals("1");
    }

    private boolean checkObjectPriv(DBObject dBObject, String string, String string2) {
        String string3 = null;
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("schema", dBObject.getSchemaName());
            hashMap.put("name", dBObject.getObjectName());
            hashMap.put("type", string);
            hashMap.put("privilege", string2);
            string3 = dBUtil.executeReturnOneCol("select count(*) from all_tab_privs where table_schema = :schema and table_name = :name and type = :type and privilege = :privilege", hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
        }
        return string3 != null && string3.equals("1");
    }

    private String getType(String string, String[] stringArray) {
        String string2 = null;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            string2 = stringArray[i + 1];
            break;
        }
        return string2;
    }
}

