/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.CompileConfirmPanel;
import oracle.hcs.db.model.NamedObjectWithDesc;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;

public class CompileMultipleObjectsConfirmPanel
extends CompileConfirmPanel {
    private List<NamedObjectWithDesc> namedObjects;
    private DefaultTableModel compileModel;
    private GenericTable compileMultipleObjectsTable;
    private String confirmTableTitle;

    public CompileMultipleObjectsConfirmPanel(List<NamedObjectWithDesc> list, String string, String string2, String string3) {
        super(string, string2);
        this.namedObjects = list;
        this.confirmTableTitle = string3;
        this.initComponents();
        this.layoutCompileMultipleObjectsPanel();
    }

    private void initComponents() {
        this.showNameField(false);
        this.setLabelConfirmMssg(HCSArb.get("COMPILE_MULTIPLE_OBJECTS_CONFIRM_MSSG"));
        this.compileModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.compileModel.addColumn(HCSArb.getString("MULTIPLE_OBJECTS_NAME_COLUMN"));
        this.compileModel.addColumn(HCSArb.getString("MULTIPLE_OBJECTS_CAPTION_COLUMN"));
        this.compileModel.addColumn(HCSArb.getString("MULTIPLE_OBJECTS_DESCRIPTION_COLUMN"));
        this.compileMultipleObjectsTable = new GenericTable((TableModel)this.compileModel);
        this.populateTable();
    }

    private void layoutCompileMultipleObjectsPanel() {
        JScrollPane jScrollPane = new JScrollPane((Component)this.compileMultipleObjectsTable);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(this.confirmTableTitle));
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.c.gridx = 0;
        ++this.c.gridy;
        this.c.gridwidth = 0;
        this.c.gridheight = 2;
        this.c.weightx = 0.5;
        this.c.weighty = 2.0;
        this.add((Component)componentWithTitlebar, this.c);
    }

    private void populateTable() {
        Object[] objectArray = null;
        for (NamedObjectWithDesc namedObjectWithDesc : this.namedObjects) {
            objectArray = new Object[]{namedObjectWithDesc.getName(), namedObjectWithDesc.getCaption(), namedObjectWithDesc.getDescription()};
            this.compileModel.addRow(objectArray);
        }
    }
}

