/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AbstractModifyObjectsPropertiesAction;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.ConfirmModifyObjectsPropertiesPanel;
import oracle.hcs.actions.DescriptionParentObjects;
import oracle.hcs.actions.ModifyObjectsPropertiesHelper;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.javatools.db.DBUtil;

public class ModifyAnalyticViewsPropertiesAction
extends AbstractModifyObjectsPropertiesAction {
    private static final String ANALYTIC_VIEW_TYPE = "ANALYTIC VIEW";
    private Map<String, List<Descriptions>> measuresDescObjectsMap;
    private Map<String, List<Descriptions>> calcMeasuresDescObjectsMap;
    private static final String HELP_ID = "obj_properties";

    @Override
    protected Map<String, DescriptionParentObjects> createOriginalAndUpdatedTopDescObjects() {
        HashMap<String, DescriptionParentObjects> hashMap = new HashMap<String, DescriptionParentObjects>();
        for (DBObject dBObject : this.getSelection()) {
            DescriptionParentObjects descriptionParentObjects = new DescriptionParentObjects();
            AnalyticView analyticView = this.getSchema().findAV(dBObject.getObjectName());
            this.initForceCreateOption(analyticView);
            AnalyticView analyticView2 = (AnalyticView)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)analyticView);
            descriptionParentObjects.setOriginalDescParentObj(analyticView);
            descriptionParentObjects.setUpdatedDescParentObj(analyticView2);
            hashMap.put(dBObject.getObjectName(), descriptionParentObjects);
        }
        return hashMap;
    }

    @Override
    protected void initChildrenDescriptionObjects() {
        this.initMeasures();
        this.initCalculatedtMeasures();
    }

    private void initMeasures() {
        this.measuresDescObjectsMap = new HashMap<String, List<Descriptions>>();
        ArrayList<AVMeasure> arrayList = new ArrayList<AVMeasure>();
        for (String string : this.getOriginalAndUpdatedTopDescObjects().keySet()) {
            DescriptionParentObjects descriptionParentObjects = this.getOriginalAndUpdatedTopDescObjects().get(string);
            AnalyticView analyticView = (AnalyticView)descriptionParentObjects.getUpdatedDescParentObj();
            for (AVMeasure aVMeasure : analyticView.getMeasures()) {
                if (this.measuresDescObjectsMap.containsKey(string)) {
                    this.measuresDescObjectsMap.get(string).add(aVMeasure);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(aVMeasure);
                this.measuresDescObjectsMap.put(analyticView.getName(), arrayList);
            }
        }
    }

    private void initCalculatedtMeasures() {
        this.calcMeasuresDescObjectsMap = new HashMap<String, List<Descriptions>>();
        ArrayList<AVCalculatedMeasure> arrayList = new ArrayList<AVCalculatedMeasure>();
        for (String string : this.getOriginalAndUpdatedTopDescObjects().keySet()) {
            DescriptionParentObjects descriptionParentObjects = this.getOriginalAndUpdatedTopDescObjects().get(string);
            AnalyticView analyticView = (AnalyticView)descriptionParentObjects.getUpdatedDescParentObj();
            for (AVCalculatedMeasure aVCalculatedMeasure : analyticView.getCalculatedMeasures()) {
                if (this.calcMeasuresDescObjectsMap.containsKey(string)) {
                    this.calcMeasuresDescObjectsMap.get(string).add(aVCalculatedMeasure);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(aVCalculatedMeasure);
                this.calcMeasuresDescObjectsMap.put(analyticView.getName(), arrayList);
            }
        }
    }

    @Override
    protected AlterHCSObjectHelper createModifyObjectsPropertiesHelper() {
        return new ModifyObjectsPropertiesHelper(this.getSchema(), this.getOriginalAndUpdatedTopDescObjects(), this.getDatabase(), this.getDiffProperty(), HCSSyntaxType.ANALYTIC_VIEW){

            @Override
            public String getTitle() {
                return HCSArb.get("MODIFY_ANALYTIC_VIEWS_PROPERTIES_TITLE");
            }
        };
    }

    @Override
    protected String getParentDescObjectName() {
        return "";
    }

    @Override
    protected Icon getTopObjectIcon() {
        return HCSNavigatorResource.getIcon("AV_ICON");
    }

    @Override
    protected String getTableTitle() {
        if (this.getSelection().size() == 1) {
            return HCSArb.get("MODIFY_ANALYTIC_VIEW_PROPS_TABLE_TITLE_LABEL");
        }
        return HCSArb.get("MODIFY_ANALYTIC_VIEWS_PROPS_TABLE_TITLE_LABEL");
    }

    @Override
    protected String getDiffProperty() {
        return "";
    }

    @Override
    protected String getParentObjectType() {
        return ANALYTIC_VIEW_TYPE;
    }

    @Override
    protected String getProgressMessage() {
        return HCSArb.get("MODIFY_OBJS_PROPS_AVS_PROGRESS_MSSG");
    }

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        return new ConfirmModifyObjectsPropertiesPanel(this.getParentDescObjects(), this.getProvider(), this.tableTitle, this.getObjectTypesForView()){

            @Override
            protected Icon getRendererIcon(String string) {
                if (string.equals(HCSArb.get("MODIFY_MEASURES_PROPS_MEAS_VIEW"))) {
                    return HCSNavigatorResource.getIcon("MEASURE_ICON");
                }
                if (string.equals(HCSArb.get("MODIFY_CALC_MEASURES_PROPS_CALCS_VIEW"))) {
                    return HCSNavigatorResource.getIcon("HCSCALCMEASURE_ICON");
                }
                return ModifyAnalyticViewsPropertiesAction.this.getTopObjectIcon();
            }

            @Override
            protected boolean showFormatStringPropertyCombo(String string) {
                return string.equals(HCSArb.get("MODIFY_MEASURES_PROPS_MEAS_VIEW")) || string.equals(HCSArb.get("MODIFY_CALC_MEASURES_PROPS_CALCS_VIEW"));
            }

            @Override
            protected Map<String, List<Descriptions>> getDescObjectsToPopulateModel(String string) {
                if (string.equals(HCSArb.get("MODIFY_MEASURES_PROPS_MEAS_VIEW"))) {
                    return ModifyAnalyticViewsPropertiesAction.this.measuresDescObjectsMap;
                }
                if (string.equals(HCSArb.get("MODIFY_CALC_MEASURES_PROPS_CALCS_VIEW"))) {
                    return ModifyAnalyticViewsPropertiesAction.this.calcMeasuresDescObjectsMap;
                }
                return ModifyAnalyticViewsPropertiesAction.this.getParentDescObjects();
            }
        };
    }

    @Override
    protected List<String> getObjectTypesForView() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getSelection().size() == 1) {
            arrayList.add(HCSArb.get("MODIFY_ANALYTIC_VIEW_PROPS_AV_VIEW"));
        } else {
            arrayList.add(HCSArb.get("MODIFY_ANALYTIC_VIEWS_PROPS_AVS_VIEW"));
        }
        arrayList.add(HCSArb.get("MODIFY_MEASURES_PROPS_MEAS_VIEW"));
        arrayList.add(HCSArb.get("MODIFY_CALC_MEASURES_PROPS_CALCS_VIEW"));
        return arrayList;
    }

    @Override
    protected String getHelpID() {
        return HELP_ID;
    }
}

