/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheMeasureGroup;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupMeasure;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.util.SourceValidator;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;

public class AVValidator
extends SchemaObjectValidator<AnalyticView>
implements SourceValidator {
    private String schemaName;
    private String objectName;
    private String objectType;
    private SourceMetadata sourceMetaData;
    private final String SOURCE_QUERY_XML_FILE = "sourcequeries.xml";
    private OracleDatabaseImpl db = (OracleDatabaseImpl)this.getProvider();

    public AVValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateObjectProperty(AnalyticView analyticView, AnalyticView analyticView2, String string) throws ValidationException {
        if (analyticView2.isSkipValidation()) {
            return;
        }
        if (string.equalsIgnoreCase("caption")) {
            return;
        }
        if (string.toLowerCase().indexOf("description") != -1) {
            return;
        }
        super.validateObjectProperty((DBObject)analyticView, (DBObject)analyticView2, string);
    }

    @DBObjectValidator.PropertyValidator(value={"dimensions"})
    public void validateDimensionality(AnalyticView analyticView, AnalyticView analyticView2) throws ValidationException {
        int n = analyticView2.getDimensions().length;
        if (n == 0) {
            throw new ValidationException((DBObject)analyticView2, HCSArb.get("AV_VALIDATE_DIMENSIONS_ERROR"));
        }
        DBObjectProvider dBObjectProvider = this.getProvider();
        for (AVDimensionality aVDimensionality : analyticView2.getDimensions()) {
            String string;
            AVHierarchy[] aVHierarchyArray;
            AttributeDimension attributeDimension = aVDimensionality.getDimension();
            if (aVDimensionality.getMappedDimensions().length == 1) {
                aVHierarchyArray = aVDimensionality.getMappedDimensions()[0];
                this.validateDimensionalityMapping((String)aVHierarchyArray, attributeDimension, analyticView2);
            }
            aVHierarchyArray = aVDimensionality.getHierarchies();
            this.validateHierarchies(analyticView2, aVDimensionality, aVHierarchyArray);
            if (this.isMappingExpressionEmpty(aVDimensionality.getMapExpressions())) {
                throw new ValidationException((DBObject)analyticView2, HCSArb.get("AV_VALIDATE_EMPTY_KEY_SOURCE_MAPPING_ERROR"));
            }
            if (this.isMappingExpressionEmpty(aVDimensionality.getMappedDimensions())) {
                throw new ValidationException((DBObject)analyticView2, HCSArb.get("AV_VALIDATE_EMPTY_DIMENSION_ATTRIBUTE_MAPPING_ERROR"));
            }
            DimensionLevel[] dimensionLevelArray = attributeDimension.getLevels();
            for (String string2 : aVDimensionality.getMappedDimensions()) {
                for (DimensionLevel dimensionLevel : dimensionLevelArray) {
                    boolean bl;
                    string = dimensionLevel.getLevelKey();
                    if (!string2.equals(string) || !(bl = dimensionLevel.getLevelSkipNullValues())) continue;
                    throw new ValidationException((DBObject)analyticView2, HCSArb.format("AV_VALIDATE_DIM_ATTR_REFERENCE_LEVEL_WITH_SKIP_NULL", string2));
                }
            }
            Object object = aVDimensionality.getDimensionAlias();
            if (object != null && ((String)object).length() == 0 || object == null) {
                throw new ValidationException((DBObject)analyticView2, HCSArb.get("NO_ALIAS_HIERARCHY_DIMENSION_ERROR"));
            }
            try {
                object = dBObjectProvider.getExternalName((String)object);
                dBObjectProvider.validateName("ATTRIBUTE DIMENSION", (String)object);
            }
            catch (InvalidNameException invalidNameException) {
                throw new ValidationException((DBObject)analyticView2, HCSArb.get("ATTRIBUTE_DIMENSION_ALIAS_ERROR_NAME"));
            }
            String string3 = dBObjectProvider.getInternalName((String)object);
            AVDimensionality[] aVDimensionalityArray = analyticView2.getDimensions();
            int n2 = 0;
            for (AbstractChildDBObject abstractChildDBObject : aVDimensionalityArray) {
                string = abstractChildDBObject.getDimensionAlias();
                if (!string.equals(string3)) continue;
                ++n2;
            }
            if (n2 <= true) continue;
            throw new ValidationException((DBObject)analyticView2, HCSArb.format("ATTRIBUTE_DIMENSION_ALIAS_ERROR_DUPLICATE_NAME", string3));
        }
    }

    private boolean isMappingExpressionEmpty(String[] stringArray) {
        return Arrays.asList(stringArray).contains("");
    }

    private void validateDimensionalityMapping(String string, AttributeDimension attributeDimension, AnalyticView analyticView) throws ValidationException {
        if (attributeDimension.getLevels().length > 1) {
            boolean bl = false;
            for (DimensionLevel dimensionLevel : attributeDimension.getLevels()) {
                for (String string2 : dimensionLevel.getLevelDeterminesKeys()) {
                    DimensionLevel dimensionLevel2 = this.findLevelByAttributeKey(attributeDimension, string2);
                    if (dimensionLevel2 == null) continue;
                    bl = true;
                }
            }
            if (!bl) {
                throw new ValidationException((DBObject)analyticView, HCSArb.format("ATTRIBUTE_DIMENSION_LEVEL_MISSING_DETERMINES", attributeDimension.getName()));
            }
        }
    }

    private DimensionLevel findLevelByAttributeKey(AttributeDimension attributeDimension, String string) {
        for (DimensionLevel dimensionLevel : attributeDimension.getLevels()) {
            String string2 = dimensionLevel.getLevelKey();
            if (string2 == null || !string2.equals(string)) continue;
            return dimensionLevel;
        }
        return null;
    }

    private void validateHierarchies(AnalyticView analyticView, AVDimensionality aVDimensionality, AVHierarchy[] aVHierarchyArray) throws ValidationException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (aVHierarchyArray.length == 0) {
            throw new ValidationException((DBObject)analyticView, HCSArb.get("EMPTY_HIERARCHY_DIMENSION_ERROR"));
        }
        for (AVHierarchy aVHierarchy : aVHierarchyArray) {
            String string = aVHierarchy.getHierarchyAlias();
            if (string != null && string.length() == 0 || string == null) {
                throw new ValidationException((DBObject)analyticView, HCSArb.get("NO_ALIAS_HIERARCHY_ERROR"));
            }
            try {
                string = dBObjectProvider.getExternalName(string);
                dBObjectProvider.validateName("HIERARCHY", string);
            }
            catch (InvalidNameException invalidNameException) {
                throw new ValidationException((DBObject)analyticView, HCSArb.get("HIERARCHY_ALIAS_ERROR_NAME"));
            }
            String string2 = dBObjectProvider.getInternalName(string);
            AVHierarchy[] aVHierarchyArray2 = aVDimensionality.getHierarchies();
            int n = 0;
            for (AVHierarchy aVHierarchy2 : aVHierarchyArray2) {
                String string3;
                if (!aVHierarchy2.isHierarchyIncluded() || !(string3 = aVHierarchy2.getHierarchyAlias()).equalsIgnoreCase(string2)) continue;
                ++n;
            }
            if (n <= true) continue;
            throw new ValidationException((DBObject)analyticView, HCSArb.format("HIERARCHY_ALIAS_ERROR_DUPLICATE_NAME", string2));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"calculatedMeasures"})
    public void validateCalculatedMeasures(AnalyticView analyticView, AnalyticView analyticView2) throws ValidationException {
        Properties properties = new Properties();
    }

    @DBObjectValidator.PropertyValidator(value={"measures"})
    public void validateMeasures(AnalyticView analyticView, AnalyticView analyticView2) throws ValidationException {
        int n = analyticView2.getMeasures().length;
        if (n == 0) {
            throw new ValidationException((DBObject)analyticView2, HCSArb.get("AV_VALIDATE_MEASURES_ERROR"));
        }
        for (AVMeasure aVMeasure : analyticView2.getMeasures()) {
            String string = aVMeasure.getMapExpression();
            try {
                this.getProvider().validateName("MEASURE2", string);
            }
            catch (InvalidNameException invalidNameException) {
                throw new ValidationException((DBObject)analyticView2, HCSArb.format("AV_VALIDATE_MEASURES_INVALID_MAP_ERROR", string, aVMeasure.getName()));
            }
        }
        if (!analyticView2.isForceCreate()) {
            List<ColumnIdentifier> list = analyticView2.getSourceColumns();
            int n2 = 0;
            for (AVMeasure aVMeasure : analyticView2.getMeasures()) {
                String string = aVMeasure.getMapExpression();
                n2 = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ColumnIdentifier columnIdentifier = (ColumnIdentifier)iterator.next();
                    String string2 = columnIdentifier.getIdentifier();
                    if (string2.startsWith("\"") && string2.endsWith("\"")) {
                        string2 = string2.replace("\"", "");
                    }
                    if (!string2.equals(string)) continue;
                    n2 = 1;
                    break;
                }
                if (n2 != 0) continue;
                throw new ValidationException((DBObject)analyticView2, HCSArb.format("AV_VALIDATE_MEASURES_MAP_ERROR", string, aVMeasure.getName()));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"avSourceTable"})
    public void validateSource(AnalyticView analyticView, AnalyticView analyticView2) throws ValidationException {
        String string = analyticView2.getavSourceTable();
        boolean bl = analyticView2.isForceCreate();
        if (string == null || string.trim().length() == 0) {
            throw new ValidationException((DBObject)analyticView2, HCSArb.get("AV_VALIDATE_SOURCE_TABLE_ERROR"));
        }
        String string2 = analyticView2.getSchema().getName();
        this.setSchemaName(string2);
        this.setObjectName(analyticView2.getName());
        this.setObjectType(analyticView2.getType());
        this.setSourceMetadata();
        string = this.db.getExternalName(string);
        if (!string2.equals(analyticView2.getavSourceTableOwner())) {
            string = analyticView2.getavSourceTableOwner() + "." + string;
        }
        String string3 = this.validateSource(string);
        if (!bl && string3 != null) {
            throw new ValidationException((DBObject)analyticView2, HCSArb.getString("VALIDATION_ERROR_AV_INVALID_SOURCE_TABLE"));
        }
    }

    private void setSchemaName(String string) {
        this.schemaName = string;
    }

    private void setObjectName(String string) {
        this.objectName = string;
    }

    private void setObjectType(String string) {
        this.objectType = string;
    }

    private void setSourceMetadata() {
        this.sourceMetaData = new SourceMetadata("sourcequeries.xml", this.db.getConnection());
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getUpdObjectName() {
        return this.objectName;
    }

    @Override
    public String getUpdObjectType() {
        return this.objectType;
    }

    @Override
    public SourceMetadata getSourceMetadata() {
        return this.sourceMetaData;
    }

    @DBObjectValidator.PropertyValidator(value={"cacheMeasureGroups"})
    public void validateCacheMeasureGroup(AnalyticView analyticView, AnalyticView analyticView2) throws ValidationException {
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray;
        for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray = analyticView2.getCacheMeasureGroups()) {
            AVCacheMeasureGroupMeasure[] aVCacheMeasureGroupMeasureArray = aVCacheMeasureGroup.getCacheMeasureGroupMeasures();
            if (aVCacheMeasureGroupMeasureArray.length != 0) continue;
            throw new ValidationException((DBObject)analyticView2, HCSArb.get("AV_VALIDATE_CACHE_MEASURE_GROUP_ERROR"));
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }
}

