/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.cache.AVCacheLevelGroup;
import oracle.hcs.av.model.cache.AVCacheLevelGroupDimHierLevel;
import oracle.hcs.av.model.cache.AVCacheMeasureGroup;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupMeasure;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.util.UIStringUtils;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.Internal;

public class AnalyticView
extends AbstractMappableSchemaObjectWithDesc {
    public static final String TYPE = "ANALYTIC VIEW";
    public static final String MEASURE_SHARED = "SHARED";
    public static final int MAP_NO_MEASURES = 1;

    public AnalyticView() {
    }

    public AnalyticView(HCSSchema hCSSchema, String string) {
        this.setSchema(hCSSchema);
        this.setName(string);
    }

    public AnalyticView(HCSSchema hCSSchema, String string, String string2, String string3, String string4) {
        this.setSchema(hCSSchema);
        this.setName(string);
        this.setavSourceTable(string3);
        this.setavSourceTableOwner(string2);
        this.setDefaultMeasure(string4);
    }

    public String getType() {
        return TYPE;
    }

    public void setavSourceTableOwner(String string) {
        this.setProperty("avSourceTableOwner", string);
    }

    public String getavSourceTableOwner() {
        return (String)this.getProperty("avSourceTableOwner");
    }

    public boolean getSourceOwnerSameAsAVOwner() {
        String string = this.getavSourceTableOwner();
        Schema schema = this.getSchema();
        boolean bl = false;
        if (schema.getName().equals(string)) {
            bl = true;
        }
        return bl;
    }

    public void setavSourceTable(String string) {
        this.setProperty("avSourceTable", string);
    }

    public String getavSourceTable() {
        return (String)this.getProperty("avSourceTable");
    }

    public void setDefaultMeasure(String string) {
        this.setProperty("defaultMeasure", string);
    }

    public String getDefaultMeasure() {
        return (String)this.getProperty("defaultMeasure");
    }

    public AVMeasure[] getMeasures() {
        return (AVMeasure[])this.getChildSupport("measures").getChildArray(AVMeasure.class);
    }

    public List<AVMeasure> getMeasuresList() {
        AVMeasure[] aVMeasureArray = (AVMeasure[])this.getChildSupport("measures").getChildArray(AVMeasure.class);
        ArrayList<AVMeasure> arrayList = new ArrayList<AVMeasure>(Arrays.asList(aVMeasureArray));
        return arrayList;
    }

    public void removeBaseMeasure(AVBaseMeasure aVBaseMeasure) {
        if (aVBaseMeasure != null) {
            String string = aVBaseMeasure.getType();
            if (string.equals("MEASURE2")) {
                this.removeMeasure((AVMeasure)aVBaseMeasure);
            } else {
                this.removeCalculatedMeasure((AVCalculatedMeasure)aVBaseMeasure);
            }
        }
    }

    public void removeMeasure(AVMeasure aVMeasure) {
        this.getChildSupport("measures").removeChild((Object)aVMeasure);
    }

    public void removeAllMeasures() {
        this.getChildSupport("measures").clearChildren();
    }

    public void setMeasures(AVMeasure[] aVMeasureArray) {
        this.getChildSupport("measures").setChildArray((Object[])aVMeasureArray);
    }

    public AVMeasure addMeasure(String string) {
        AVMeasure aVMeasure = new AVMeasure(string);
        this.getChildSupport("measures").addChild((Object)aVMeasure);
        return aVMeasure;
    }

    public void addMeasure(AVMeasure aVMeasure) {
        this.getChildSupport("measures").addChild((Object)aVMeasure);
        String string = aVMeasure.getName();
    }

    public AVMeasure findMeasure(String string) {
        AVMeasure[] aVMeasureArray = (AVMeasure[])this.getChildSupport("measures").getChildArray(AVMeasure.class);
        String string2 = UIStringUtils.stripDoubleQuotes(string);
        for (AVMeasure aVMeasure : aVMeasureArray) {
            if (!aVMeasure.getName().equals(string2)) continue;
            return aVMeasure;
        }
        return null;
    }

    public AVCalculatedMeasure[] getCalculatedMeasures() {
        return (AVCalculatedMeasure[])this.getChildSupport("calculatedMeasures").getChildArray(AVCalculatedMeasure.class);
    }

    public List<AVCalculatedMeasure> getCalculatedMeasuresList() {
        AVCalculatedMeasure[] aVCalculatedMeasureArray = (AVCalculatedMeasure[])this.getChildSupport("calculatedMeasures").getChildArray(AVCalculatedMeasure.class);
        ArrayList<AVCalculatedMeasure> arrayList = new ArrayList<AVCalculatedMeasure>(Arrays.asList(aVCalculatedMeasureArray));
        return arrayList;
    }

    public void removeCalculatedMeasure(AVCalculatedMeasure aVCalculatedMeasure) {
        this.getChildSupport("calculatedMeasures").removeChild((Object)aVCalculatedMeasure);
    }

    public void removeAllCalculatedMeasures() {
        this.getChildSupport("calculatedMeasures").clearChildren();
    }

    public void setCalculatedMeasures(AVCalculatedMeasure[] aVCalculatedMeasureArray) {
        this.getChildSupport("calculatedMeasures").setChildArray((Object[])aVCalculatedMeasureArray);
    }

    public void addCalculatedMeasure(AVCalculatedMeasure aVCalculatedMeasure) {
        this.getChildSupport("calculatedMeasures").addChild((Object)aVCalculatedMeasure);
    }

    public AVCalculatedMeasure findCalculatedMeasure(String string) {
        AVCalculatedMeasure[] aVCalculatedMeasureArray = (AVCalculatedMeasure[])this.getChildSupport("calculatedMeasures").getChildArray(AVCalculatedMeasure.class);
        String string2 = UIStringUtils.stripDoubleQuotes(string);
        for (AVCalculatedMeasure aVCalculatedMeasure : aVCalculatedMeasureArray) {
            if (!aVCalculatedMeasure.getName().equals(string2)) continue;
            return aVCalculatedMeasure;
        }
        return null;
    }

    public AVBaseMeasure findBaseMeasure(String string) {
        AVMeasure aVMeasure = this.findMeasure(string);
        if (aVMeasure == null) {
            return this.findCalculatedMeasure(string);
        }
        return aVMeasure;
    }

    public List<AVBaseMeasure> getStoredAndCalculatedMeasures() {
        ArrayList<AVBaseMeasure> arrayList = new ArrayList<AVBaseMeasure>();
        arrayList.addAll(this.getMeasuresList());
        arrayList.addAll(this.getCalculatedMeasuresList());
        return arrayList;
    }

    public boolean isNewMeasure(String string) {
        AVCalculatedMeasure aVCalculatedMeasure = this.findCalculatedMeasure(string);
        if (aVCalculatedMeasure != null) {
            return aVCalculatedMeasure.isNewObject();
        }
        return true;
    }

    public StringBuffer getMeasureDependencies(String string) {
        AVCalculatedMeasure[] aVCalculatedMeasureArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (AVCalculatedMeasure aVCalculatedMeasure : aVCalculatedMeasureArray = (AVCalculatedMeasure[])this.getChildSupport("calculatedMeasures").getChildArray(AVCalculatedMeasure.class)) {
            if (aVCalculatedMeasure.getMeasureExpression().indexOf(string) < 0) continue;
            stringBuffer.append(aVCalculatedMeasure.getName() + ",");
        }
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        return stringBuffer;
    }

    public AVDimensionality[] getDimensions() throws IllegalStateException {
        return (AVDimensionality[])this.getChildSupport("dimensions").getChildArray(AVDimensionality.class);
    }

    public void setDimensions(AVDimensionality[] aVDimensionalityArray) {
        this.getChildSupport("dimensions").setChildArray((Object[])aVDimensionalityArray);
    }

    public void setDimensions(String[] stringArray) {
        this.getChildSupport("dimensions").setChildArray((Object[])stringArray);
    }

    public void addDimensionality(AVDimensionality aVDimensionality) {
        this.getChildSupport("dimensions").addChild((Object)aVDimensionality);
        String string = aVDimensionality.getName();
        if (aVDimensionality.getMapExpressions() == null && string.equalsIgnoreCase("TIME")) {
            string = "\"" + string + "\"";
        }
    }

    public AVDimensionality findDimensionality(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 2) {
            string = stringArray[1];
        }
        AVDimensionality[] aVDimensionalityArray = (AVDimensionality[])this.getChildSupport("dimensions").getChildArray(AVDimensionality.class);
        String string2 = UIStringUtils.stripDoubleQuotes(string);
        for (AVDimensionality aVDimensionality : aVDimensionalityArray) {
            if (!aVDimensionality.getName().equals(string2)) continue;
            return aVDimensionality;
        }
        return null;
    }

    public AVDimensionality findDimensionalityForAlias(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 2) {
            string = stringArray[1];
        }
        AVDimensionality[] aVDimensionalityArray = (AVDimensionality[])this.getChildSupport("dimensions").getChildArray(AVDimensionality.class);
        String string2 = UIStringUtils.stripDoubleQuotes(string);
        for (AVDimensionality aVDimensionality : aVDimensionalityArray) {
            if (!aVDimensionality.getDimensionAlias().equals(string2)) continue;
            return aVDimensionality;
        }
        return null;
    }

    public void removeAllDimensions() {
        this.getChildSupport("dimensions").clearChildren();
    }

    public String getConsistentSolveSpec() {
        return (String)this.getProperty("consistentSolveSpec");
    }

    public void setConsistentSolveSpec(String string) {
        this.setProperty("consistentSolveSpec", string);
    }

    public void setMapQuery(String string) {
        this.setProperty("mapQuery", string);
    }

    public String getHierarchyAlias(String string) {
        AVDimensionality[] aVDimensionalityArray;
        for (AVDimensionality aVDimensionality : aVDimensionalityArray = (AVDimensionality[])this.getChildSupport("dimensions").getChildArray(AVDimensionality.class)) {
            for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                if (!aVHierarchy.getHierarchyName().equals(string)) continue;
                String string2 = aVHierarchy.getHierarchyAlias();
                return string2;
            }
        }
        return string;
    }

    public String getMapQuery() {
        return (String)this.getProperty("mapQuery");
    }

    public void setMapWhereClause(String string) {
        this.setProperty("mapWhereClause", string);
    }

    public String getMapWhereClause() {
        return (String)this.getProperty("mapWhereClause");
    }

    public AVCacheMeasureGroup[] getCacheMeasureGroups() {
        return (AVCacheMeasureGroup[])this.getChildSupport("cacheMeasureGroups").getChildArray(AVCacheMeasureGroup.class);
    }

    public void setCacheMeasureGroups(AVCacheMeasureGroup[] aVCacheMeasureGroupArray) {
        this.getChildSupport("cacheMeasureGroups").setChildArray((Object[])aVCacheMeasureGroupArray);
    }

    public void removeCacheMeasureGroup(AVCacheMeasureGroup aVCacheMeasureGroup) {
        this.getChildSupport("cacheMeasureGroups").removeChild((Object)aVCacheMeasureGroup);
    }

    public void addCacheMeasureGroup(AVCacheMeasureGroup aVCacheMeasureGroup) {
        this.getChildSupport("cacheMeasureGroups").addChild((Object)aVCacheMeasureGroup);
    }

    public void manageCacheMeasureGroupMeasureAdded() {
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = this.getCacheMeasureGroups();
        if (aVCacheMeasureGroupArray != null && aVCacheMeasureGroupArray.length > 0) {
            for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray) {
                aVCacheMeasureGroup.setLifeCycleEditOccurred();
            }
        }
    }

    public void manageCacheMeasureGroupMeasureRenamed(DBObjectProvider dBObjectProvider, String string, String string2) {
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = this.getCacheMeasureGroups();
        if (aVCacheMeasureGroupArray != null && aVCacheMeasureGroupArray.length > 0) {
            for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray) {
                AVCacheMeasureGroupMeasure[] aVCacheMeasureGroupMeasureArray;
                aVCacheMeasureGroup.setLifeCycleEditOccurred();
                for (AVCacheMeasureGroupMeasure aVCacheMeasureGroupMeasure : aVCacheMeasureGroupMeasureArray = aVCacheMeasureGroup.getCacheMeasureGroupMeasures()) {
                    String string3 = dBObjectProvider.getExternalName(aVCacheMeasureGroupMeasure.getName());
                    if (!string3.equalsIgnoreCase(string)) continue;
                    aVCacheMeasureGroupMeasure.setName(dBObjectProvider.getInternalName(string2));
                }
            }
        }
    }

    public void manageCacheMeasureGroupMeasureDelete(String string) {
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = this.getCacheMeasureGroups();
        ArrayList<AVCacheMeasureGroup> arrayList = new ArrayList<AVCacheMeasureGroup>();
        if (aVCacheMeasureGroupArray != null && aVCacheMeasureGroupArray.length > 0) {
            for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray) {
                aVCacheMeasureGroup.setLifeCycleEditOccurred();
                AVCacheMeasureGroupMeasure[] aVCacheMeasureGroupMeasureArray = aVCacheMeasureGroup.getCacheMeasureGroupMeasures();
                boolean bl = false;
                AVCacheMeasureGroupMeasure aVCacheMeasureGroupMeasure = null;
                for (AVCacheMeasureGroupMeasure aVCacheMeasureGroupMeasure2 : aVCacheMeasureGroupMeasureArray) {
                    if (!aVCacheMeasureGroupMeasure2.getName().equalsIgnoreCase(string)) continue;
                    bl = true;
                    aVCacheMeasureGroupMeasure = aVCacheMeasureGroupMeasure2;
                    break;
                }
                if (!bl) continue;
                aVCacheMeasureGroup.removeCacheMeasureGroupMeasure(aVCacheMeasureGroupMeasure);
                if (aVCacheMeasureGroup.getCacheMeasureGroupMeasures().length != 0) continue;
                arrayList.add(aVCacheMeasureGroup);
            }
            for (AVCacheMeasureGroup aVCacheMeasureGroup : arrayList) {
                this.removeCacheMeasureGroup(aVCacheMeasureGroup);
            }
            if (this.getCacheMeasureGroups().length == 0) {
                this.setCacheMeasureGroups(null);
            }
        }
    }

    public void manageCacheMeasureGroupHierarchyAliasRename(DBObjectProvider dBObjectProvider, AVHierarchy aVHierarchy, String string, String string2) {
        Hierarchy hierarchy = aVHierarchy.getHierarchy();
        AttributeDimension attributeDimension = hierarchy.getDimension();
        String string3 = attributeDimension.getName();
        String string4 = null;
        AVDimensionality[] aVDimensionalityArray = (AVDimensionality[])this.getChildSupport("dimensions").getChildArray(AVDimensionality.class);
        AbstractChildDBObject[] abstractChildDBObjectArray = aVDimensionalityArray;
        int n = abstractChildDBObjectArray.length;
        for (int i = 0; i < n; ++i) {
            AVDimensionality aVDimensionality = abstractChildDBObjectArray[i];
            if (!aVDimensionality.getDimension().getName().equalsIgnoreCase(string3)) continue;
            string4 = aVDimensionality.getDimensionAlias();
            string4 = dBObjectProvider.getExternalName(string4);
            break;
        }
        if ((abstractChildDBObjectArray = this.getCacheMeasureGroups()) != null && abstractChildDBObjectArray.length > 0) {
            for (AbstractChildDBObject abstractChildDBObject : abstractChildDBObjectArray) {
                AVCacheLevelGroup[] aVCacheLevelGroupArray;
                abstractChildDBObject.setLifeCycleEditOccurred();
                for (AVCacheLevelGroup aVCacheLevelGroup : aVCacheLevelGroupArray = abstractChildDBObject.getCacheLevelGroups()) {
                    AVCacheLevelGroupDimHierLevel[] aVCacheLevelGroupDimHierLevelArray;
                    for (AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel : aVCacheLevelGroupDimHierLevelArray = aVCacheLevelGroup.getCacheLevelGroupHierLevels()) {
                        String string5 = aVCacheLevelGroupDimHierLevel.getName();
                        IdentifierElement identifierElement = new IdentifierElement(string5, true);
                        String string6 = identifierElement.getFirst();
                        String string7 = identifierElement.getSecond();
                        if (!string4.equalsIgnoreCase(string6) || !string.equalsIgnoreCase(string7)) continue;
                        aVCacheLevelGroupDimHierLevel.setName(string6 + "." + string2 + "." + identifierElement.getThird());
                    }
                }
            }
        }
    }

    public void manageCacheMeasureGroupHierarchyIncludeChanged(DBObjectProvider dBObjectProvider, AVHierarchy aVHierarchy, boolean bl, boolean bl2) {
        block7: {
            block6: {
                if (bl2) break block6;
                String string = aVHierarchy.getHierarchyAlias();
                Hierarchy hierarchy = aVHierarchy.getHierarchy();
                AttributeDimension attributeDimension = hierarchy.getDimension();
                String string2 = attributeDimension.getName();
                String string3 = null;
                AVDimensionality[] aVDimensionalityArray = (AVDimensionality[])this.getChildSupport("dimensions").getChildArray(AVDimensionality.class);
                AbstractChildDBObject[] abstractChildDBObjectArray = aVDimensionalityArray;
                int n = abstractChildDBObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    AVDimensionality aVDimensionality = abstractChildDBObjectArray[i];
                    if (!aVDimensionality.getDimension().getName().equalsIgnoreCase(string2)) continue;
                    string3 = aVDimensionality.getDimensionAlias();
                    string3 = dBObjectProvider.getExternalName(string3);
                    break;
                }
                if ((abstractChildDBObjectArray = this.getCacheMeasureGroups()) == null || abstractChildDBObjectArray.length <= 0) break block7;
                for (AbstractChildDBObject abstractChildDBObject : abstractChildDBObjectArray) {
                    AVCacheLevelGroup[] aVCacheLevelGroupArray;
                    abstractChildDBObject.setLifeCycleEditOccurred();
                    for (AVCacheLevelGroup aVCacheLevelGroup : aVCacheLevelGroupArray = abstractChildDBObject.getCacheLevelGroups()) {
                        AVCacheLevelGroupDimHierLevel[] aVCacheLevelGroupDimHierLevelArray = aVCacheLevelGroup.getCacheLevelGroupHierLevels();
                        boolean bl3 = false;
                        AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel = null;
                        for (AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel2 : aVCacheLevelGroupDimHierLevelArray) {
                            String string4 = aVCacheLevelGroupDimHierLevel2.getName();
                            IdentifierElement identifierElement = new IdentifierElement(string4, true);
                            String string5 = identifierElement.getFirst();
                            String string6 = identifierElement.getSecond();
                            if (!string3.equalsIgnoreCase(string5) || !string.equalsIgnoreCase(string6)) continue;
                            bl3 = true;
                            aVCacheLevelGroupDimHierLevel = aVCacheLevelGroupDimHierLevel2;
                            break;
                        }
                        if (!bl3) continue;
                        aVCacheLevelGroup.removeCacheLevelGroupHierLevel(aVCacheLevelGroupDimHierLevel);
                    }
                }
                break block7;
            }
            AVCacheMeasureGroup[] aVCacheMeasureGroupArray = this.getCacheMeasureGroups();
            if (aVCacheMeasureGroupArray != null && aVCacheMeasureGroupArray.length > 0) {
                for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray) {
                    aVCacheMeasureGroup.setLifeCycleEditOccurred();
                }
            }
        }
    }

    public void manageAVCacheMeasureGroupDimensionAliasRename(DBObjectProvider dBObjectProvider, String string, String string2) {
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = this.getCacheMeasureGroups();
        if (aVCacheMeasureGroupArray != null && aVCacheMeasureGroupArray.length > 0) {
            for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray) {
                AVCacheLevelGroup[] aVCacheLevelGroupArray;
                aVCacheMeasureGroup.setLifeCycleEditOccurred();
                for (AVCacheLevelGroup aVCacheLevelGroup : aVCacheLevelGroupArray = aVCacheMeasureGroup.getCacheLevelGroups()) {
                    AVCacheLevelGroupDimHierLevel[] aVCacheLevelGroupDimHierLevelArray;
                    for (AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel : aVCacheLevelGroupDimHierLevelArray = aVCacheLevelGroup.getCacheLevelGroupHierLevels()) {
                        String string3 = aVCacheLevelGroupDimHierLevel.getName();
                        IdentifierElement identifierElement = new IdentifierElement(string3, true);
                        String string4 = identifierElement.getFirst();
                        if (!string.equalsIgnoreCase(string4)) continue;
                        aVCacheLevelGroupDimHierLevel.setName(string2 + "." + identifierElement.getSecond() + "." + identifierElement.getThird());
                    }
                }
            }
        }
    }

    public void manageCacheMeasureGroupDimensionalityAdded() {
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = this.getCacheMeasureGroups();
        if (aVCacheMeasureGroupArray != null && aVCacheMeasureGroupArray.length > 0) {
            for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray) {
                aVCacheMeasureGroup.setLifeCycleEditOccurred();
            }
        }
    }

    public void manageCacheMeasureGroupDimensionalityDeleted(String string) {
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = this.getCacheMeasureGroups();
        if (aVCacheMeasureGroupArray != null && aVCacheMeasureGroupArray.length > 0) {
            ArrayList<AVCacheMeasureGroup> arrayList = new ArrayList<AVCacheMeasureGroup>();
            for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray) {
                aVCacheMeasureGroup.setLifeCycleEditOccurred();
                AVCacheLevelGroup[] aVCacheLevelGroupArray = aVCacheMeasureGroup.getCacheLevelGroups();
                ArrayList<AVCacheLevelGroup> arrayList2 = new ArrayList<AVCacheLevelGroup>();
                for (AVCacheLevelGroup aVCacheLevelGroup : aVCacheLevelGroupArray) {
                    AVCacheLevelGroupDimHierLevel[] aVCacheLevelGroupDimHierLevelArray = aVCacheLevelGroup.getCacheLevelGroupHierLevels();
                    boolean bl = false;
                    ArrayList<AVCacheLevelGroupDimHierLevel> arrayList3 = new ArrayList<AVCacheLevelGroupDimHierLevel>();
                    for (AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel : aVCacheLevelGroupDimHierLevelArray) {
                        String string2 = aVCacheLevelGroupDimHierLevel.getName();
                        IdentifierElement identifierElement = new IdentifierElement(string2, true);
                        String string3 = identifierElement.getFirst();
                        if (!string.equalsIgnoreCase(string3)) continue;
                        bl = true;
                        arrayList3.add(aVCacheLevelGroupDimHierLevel);
                    }
                    if (!bl) continue;
                    for (AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel : arrayList3) {
                        aVCacheLevelGroup.removeCacheLevelGroupHierLevel(aVCacheLevelGroupDimHierLevel);
                    }
                    if (aVCacheLevelGroup.getCacheLevelGroupHierLevels().length != 0) continue;
                    arrayList2.add(aVCacheLevelGroup);
                }
                for (AVCacheLevelGroup aVCacheLevelGroup : arrayList2) {
                    aVCacheMeasureGroup.removeCacheLevelGroup(aVCacheLevelGroup);
                }
                if (aVCacheMeasureGroup.getCacheLevelGroups().length != 0) continue;
                arrayList.add(aVCacheMeasureGroup);
            }
            for (AVCacheMeasureGroup aVCacheMeasureGroup : arrayList) {
                this.removeCacheMeasureGroup(aVCacheMeasureGroup);
            }
            if (this.getCacheMeasureGroups().length == 0) {
                this.setCacheMeasureGroups(null);
            }
        }
    }

    public void setName(String string) {
        String string2 = this.getName();
        super.setName(string);
        String string3 = this.getMapQuery();
        if (string3 == null || string3.equals(string2)) {
            string3 = string;
        }
    }

    public boolean isSupported(String string) {
        return true;
    }

    @Override
    public int getNotMappableCause() {
        if (this.getMeasures().length == 0) {
            return 1;
        }
        return 0;
    }

    @Internal
    public Map<String, AttributeDimension> getDimensionMap(Object object) {
        LinkedHashMap<String, AttributeDimension> linkedHashMap = new LinkedHashMap<String, AttributeDimension>();
        List list = (List)object;
        for (AVDimensionality aVDimensionality : this.getDimensions()) {
            for (AttributeDimension attributeDimension : list) {
                if (!aVDimensionality.getName().equals(attributeDimension.getName())) continue;
                linkedHashMap.put(aVDimensionality.getName(), attributeDimension);
            }
        }
        return linkedHashMap;
    }

    @Internal
    public AttributeDimension[] getDimensions(Object object) {
        Map<String, AttributeDimension> map = this.getDimensionMap(object);
        AttributeDimension[] attributeDimensionArray = new AttributeDimension[map.keySet().size()];
        int n = 0;
        for (String string : map.keySet()) {
            AttributeDimension attributeDimension = map.get(string);
            attributeDimensionArray[n++] = attributeDimension;
        }
        return attributeDimensionArray;
    }

    public AttributeDimension findDimension(Object object, String string) {
        String string2 = UIStringUtils.stripDoubleQuotes(string);
        for (AttributeDimension attributeDimension : this.getDimensions(object)) {
            if (!attributeDimension.getName().equals(string2)) continue;
            return attributeDimension;
        }
        return null;
    }

    public AttributeDimension findDimension(Object object, AVDimensionality aVDimensionality) {
        return this.findDimension(object, aVDimensionality.getName());
    }

    @Internal
    public boolean isMeasuresAndCalcMeasuresSelected() {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        AVMeasure[] aVMeasureArray = this.getMeasures();
        AVCalculatedMeasure[] aVCalculatedMeasureArray = this.getCalculatedMeasures();
        for (AVMeasure aVBaseMeasure : aVMeasureArray) {
            bl = aVBaseMeasure.isSelected();
            if (!bl) continue;
            bl3 = true;
            break;
        }
        if (bl3 && aVCalculatedMeasureArray.length > 0) {
            for (AVBaseMeasure aVBaseMeasure : aVCalculatedMeasureArray) {
                bl = aVBaseMeasure.isSelected();
                if (!bl) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }
}

