/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.avviewer;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import oracle.dss.dataView.LocalDataSource;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.sql.NUMBER;

public class AVDataSource
extends LocalDataSource {
    private static final Logger LOG = Logger.getLogger(AVDataSource.class.getName());
    private static Pattern numeric = Pattern.compile("-?\\d*(\\.\\d+)?");

    public AVDataSource() {
        this.rowCount = 1;
        this.columnCount = 1;
        this.defaultData1 = new double[this.rowCount][this.columnCount];
        this.defaultData1[0][0] = 0.0;
        this.populateCellData(this.columnCount, this.rowCount, this.defaultData1);
    }

    /*
     * WARNING - void declaration
     */
    public AVDataSource(AnalyticView analyticView, TableModel tableModel) {
        String string;
        int n = analyticView.getDimensions().length;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        for (AVMeasure object2 : analyticView.getMeasures()) {
            if (!object2.isSelected()) continue;
            string = object2.getDisplayLabel();
            arrayList.add(string);
            ++n2;
        }
        AVBaseMeasure[] aVBaseMeasureArray = analyticView.getCalculatedMeasures();
        int n3 = aVBaseMeasureArray.length;
        for (int i = 0; i < n3; ++i) {
            AVBaseMeasure aVBaseMeasure = aVBaseMeasureArray[i];
            if (!aVBaseMeasure.isSelected()) continue;
            string = aVBaseMeasure.getDisplayLabel();
            arrayList.add(string);
            ++n2;
        }
        n = tableModel.getColumnCount() - n2;
        this.rowCount = arrayList.size();
        this.rowLabels = arrayList.toArray(new String[this.rowCount]);
        if (tableModel != null) {
            int n4;
            this.columnCount = n4 = tableModel.getRowCount();
            this.defaultData1 = new double[this.rowCount][this.columnCount];
            this.columnLabels = new String[this.columnCount];
            for (n3 = 0; n3 < n4; ++n3) {
                Object object;
                void var9_16;
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                while (var9_16 < n) {
                    Object object2 = tableModel.getValueAt(n3, (int)var9_16);
                    if (object2 != null) {
                        object = object2.toString().trim();
                        stringBuffer.append((String)object + ",\n");
                    }
                    ++var9_16;
                }
                if (stringBuffer.length() > 0 && stringBuffer.substring(stringBuffer.length() - 2, stringBuffer.length()).equals(",\n")) {
                    stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                }
                this.columnLabels[n3] = stringBuffer.toString();
                NumberFormat numberFormat = NumberFormat.getInstance();
                for (int i = n; i < tableModel.getColumnCount(); ++i) {
                    object = tableModel.getValueAt(n3, i);
                    if (object == null) continue;
                    String string2 = object.toString();
                    double d = 0.0;
                    if (object instanceof NUMBER) {
                        NUMBER nUMBER = (NUMBER)object;
                        d = nUMBER.doubleValue();
                    } else if (this.isNumeric(string2)) {
                        try {
                            d = numberFormat.parse(string2).doubleValue();
                        }
                        catch (ParseException parseException) {
                            LOG.log(Level.WARNING, parseException.getLocalizedMessage(), parseException);
                        }
                    } else {
                        string2 = string2.replaceAll("[^\\d.,-<>]", "");
                        try {
                            if (string2.startsWith("<") && string2.endsWith(">")) {
                                string2 = "-" + string2.substring(1, string2.length() - 1);
                            }
                            if (string2.endsWith("-")) {
                                string2 = "-" + string2.substring(0, string2.length() - 1);
                            }
                            d = numberFormat.parse(string2).doubleValue();
                        }
                        catch (ParseException parseException) {
                            LOG.log(Level.WARNING, parseException.getLocalizedMessage(), parseException);
                        }
                    }
                    this.defaultData1[i - n][n3] = d;
                }
            }
            this.populateCellData(this.columnCount, this.rowCount, this.defaultData1);
        }
    }

    protected boolean isNumeric(String string) {
        return !string.isEmpty() && numeric.matcher(string).matches();
    }
}

