/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import oracle.hcs.util.HCSObjectsTimestamps;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;

public abstract class HCSObjectLister
extends DBObjectLister {
    private String dbCompatibleLevel;
    protected String hcsObjectType;
    protected String schemaName = "";

    public HCSObjectLister(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public Collection<DBObjectLister.ObjectInfo> listObjects(DBObjectCriteria dBObjectCriteria) throws DBException {
        boolean bl;
        Database database = (Database)this.getProvider();
        final Schema schema = database.getSchema(dBObjectCriteria.getSchemaName());
        this.schemaName = schema.getName();
        final QueryWrapper queryWrapper = this.getQueryWrapperForVersionCheck();
        final ArrayList<DBObjectLister.ObjectInfo> arrayList = new ArrayList<DBObjectLister.ObjectInfo>();
        final QueryWrapper queryWrapper2 = this.getQueryWrapperForObjectList(dBObjectCriteria);
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                try {
                    while (resultSet.next()) {
                        HCSObjectLister.this.dbCompatibleLevel = resultSet.getString(1);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException(sQLException);
                }
            }
        });
        boolean bl2 = bl = this.dbCompatibleLevel != null;
        if (bl) {
            queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            String string2 = resultSet.getString(2);
                            DBObjectLister.ObjectInfo objectInfo = new DBObjectLister.ObjectInfo(string2, schema, string, null);
                            arrayList.add(objectInfo);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper2.throwDBException(sQLException);
                    }
                }
            });
        }
        return arrayList;
    }

    private QueryWrapper getQueryWrapperForVersionCheck() {
        Database database = (Database)this.getProvider();
        QueryWrapper queryWrapper = new QueryWrapper(database, "select value from database_compatible_level v where v.value like '12.2%' or v.value like '18%' or v.value like '19%' or v.value like '2%'");
        return queryWrapper;
    }

    public boolean supportsTimestamps(String string) {
        return true;
    }

    public Long getExternalTimestamp(SystemObject systemObject) throws DBException {
        long l = 0L;
        Database database = (Database)this.getProvider();
        Connection connection = database.getConnection();
        String string = systemObject.getName();
        l = HCSObjectsTimestamps.getTimestampForHCSObject(connection, this.getObjectType(), this.schemaName, string);
        return l;
    }

    protected abstract String getObjectType();

    protected abstract QueryWrapper getQueryWrapperForObjectList(DBObjectCriteria var1) throws DBException;
}

