/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import oracle.hcs.db.DatabaseImpl;
import oracle.hcs.hierarchy.HierarchyBuilder;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSMetadataReader;
import oracle.hcs.metadata.HCSSchema;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class HierarchyList {
    private OracleDatabaseImpl db;
    private HCSSchema schema;
    private List<Hierarchy> hierarchies;
    private HierarchyBuilder hierBuilder;

    public HierarchyList(OracleDatabaseImpl oracleDatabaseImpl, HCSSchema hCSSchema) {
        this.db = oracleDatabaseImpl;
        this.schema = hCSSchema;
        this.hierarchies = new ArrayList<Hierarchy>();
        this.hierBuilder = new HierarchyBuilder(oracleDatabaseImpl);
    }

    private void addHierarchy(String string, String string2) throws DBException, SQLException, IOException, JAXBException {
        if (this.hierBuilder != null) {
            NameBasedID nameBasedID = new NameBasedID("HIERARCHY", this.schema.getName(), string, (AbstractDBObjectProvider)this.db);
            Hierarchy hierarchy = this.hierBuilder.createObject(string, this.schema, (DBObjectID)nameBasedID);
            hierarchy.setDimensionName(string2);
            this.hierBuilder.buildDetails(hierarchy);
            this.hierarchies.add(hierarchy);
        }
    }

    public void build(Hierarchy hierarchy, boolean bl) throws DBException, SQLException, IOException, JAXBException {
        if (bl) {
            this.hierBuilder.buildDetails(hierarchy);
        } else {
            this.hierBuilder.build(hierarchy);
        }
    }

    public List<Hierarchy> getHierarchies() throws DBException, SQLException, IOException, JAXBException {
        DatabaseImpl databaseImpl = new DatabaseImpl(this.db.getConnection());
        HCSMetadataReader hCSMetadataReader = new HCSMetadataReader(databaseImpl, this.schema);
        hCSMetadataReader.loadHierarchies();
        this.hierarchies = this.schema.getHierarchies();
        return this.hierarchies;
    }
}

