/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;

public class HCSCompileDDLGenerator {
    private static final String COMPILE_QUERY = "compileObject";
    protected static final String XMLFILE = "/oracle/hcs/actions/actionsQueries.xml";
    protected static final String QUERIES_PACKAGE = "oracle.hcs.table";
    private final String ERRORS_COUNT_QUERY_NAME = "objectErrorsCount";
    private static Queries queries;
    List<String> compileStatements = new ArrayList<String>();
    private static final Logger LOG;

    public String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = QUERIES_PACKAGE;
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, exception.getMessage());
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        HCSCompileDDLGenerator.queries = queries;
    }

    public List<String> generateCompileStatements(List<AbstractSchemaObjectWithDesc> list) {
        if (this.compileStatements != null && this.compileStatements.size() == 0) {
            String string = this.getQuery(COMPILE_QUERY);
            for (AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc : list) {
                String string2 = abstractSchemaObjectWithDesc.getSchema().getName();
                String string3 = String.format(string, abstractSchemaObjectWithDesc.getType(), string2, abstractSchemaObjectWithDesc.getName());
                this.compileStatements.add(string3);
            }
        }
        return this.compileStatements;
    }

    public void compileDependencies(List<AbstractSchemaObjectWithDesc> list, Connection connection) {
        try {
            List<String> list2 = this.generateCompileStatements(list);
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            for (String string : list2) {
                dBUtil.execute(string);
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException == null) continue;
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, sQLException.getMessage());
        }
    }

    public String generateCompileErrorsQuery(String string, List<AbstractSchemaObjectWithDesc> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc : list) {
            String string2 = String.format("'%s'", abstractSchemaObjectWithDesc.getName());
            arrayList.add(string2);
        }
        String string3 = String.join((CharSequence)",", arrayList);
        return String.format(this.getQuery(string), string3);
    }

    public int getCompileErrorsCount(Connection connection, List<AbstractSchemaObjectWithDesc> list) {
        String string = "";
        if (list.size() > 0) {
            try {
                String string2 = this.generateCompileErrorsQuery("objectErrorsCount", list);
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                string = dBUtil.executeReturnOneCol(string2);
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    throw sQLException;
                }
            }
            catch (SQLException sQLException) {
                LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
            }
            return Integer.valueOf(string);
        }
        return 0;
    }

    public void clearCompileStatements() {
        this.compileStatements.clear();
    }

    static {
        LOG = Logger.getLogger(HCSCompileDDLGenerator.class.getName());
    }
}

