/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.hcs.HCSArb;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.panels.DimensionGeneralPanel;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSpec;
import oracle.hcs.syntaxbuilder.SnippetBuilderPanel;
import oracle.hcs.syntaxbuilder.editor.SnippetValidator;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.syntaxbuilder.spectree.SpecJTree;
import oracle.hcs.templates.templatedialog.TemplateHelperFactoryImpl;
import oracle.hcs.templates.templateview.TemplateNodeRenderer;
import oracle.hcs.util.HCSErrorDisplay;
import oracle.hcs.util.HCSResources;
import oracle.hcs.util.NonLazyFetchIcon;
import oracle.i18n.util.OraLocaleInfo;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class HCSLanguageExpressionBuilder {
    private SnippetBuilderPanel languageEditorPanel;
    private static final String HCS_LANGUAGE_SNIPPETS = "/oracle/hcs/db/panels/HCSLanguageSnippetsSpec.xml";
    private static final Logger LOG = Logger.getLogger(HCSLanguageExpressionBuilder.class.getName());
    private String memberProperty;
    private HCSSpec spec;

    public HCSLanguageExpressionBuilder(OracleDatabaseImpl oracleDatabaseImpl, HCSSchema hCSSchema, Properties properties) {
        this(oracleDatabaseImpl, HCS_LANGUAGE_SNIPPETS, hCSSchema, properties);
    }

    public HCSLanguageExpressionBuilder(OracleDatabaseImpl oracleDatabaseImpl, String string, HCSSchema hCSSchema, Properties properties) {
        this(oracleDatabaseImpl, string, hCSSchema, properties, null);
    }

    public HCSLanguageExpressionBuilder(OracleDatabaseImpl oracleDatabaseImpl, String string, HCSSchema hCSSchema, Properties properties, DimensionAttribute[] dimensionAttributeArray) {
        try {
            HCSErrorDisplay hCSErrorDisplay = new HCSErrorDisplay();
            NonLazyFetchIcon nonLazyFetchIcon = new NonLazyFetchIcon();
            HCSResources hCSResources = new HCSResources(string);
            InputStreamReader inputStreamReader = new InputStreamReader(DimensionGeneralPanel.class.getResourceAsStream(string), "UTF-8");
            String string2 = string.substring(string.lastIndexOf("/"));
            TemplateHelperFactoryImpl templateHelperFactoryImpl = new TemplateHelperFactoryImpl(properties, hCSSchema, null, hCSResources, nonLazyFetchIcon);
            templateHelperFactoryImpl.setProvider(oracleDatabaseImpl);
            this.spec = new HCSSpec(properties, inputStreamReader, string2, null, templateHelperFactoryImpl, hCSErrorDisplay, hCSResources, nonLazyFetchIcon, oracleDatabaseImpl.getConnection());
            this.languageEditorPanel = new SnippetBuilderPanel(this.spec, hCSErrorDisplay, "");
            final SpecJTree specJTree = this.languageEditorPanel.getSpecJTree();
            if (dimensionAttributeArray != null) {
                this.addAttributesCategory(dimensionAttributeArray);
            }
            TemplateNodeRenderer templateNodeRenderer = new TemplateNodeRenderer(specJTree);
            templateNodeRenderer.setPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            specJTree.startEditingAtPath(specJTree.getSelectionPath());
                        }
                    });
                }
            });
            templateNodeRenderer.setupTreeRendering();
            this.addLanguagesCategory();
            specJTree.reload();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void setText(String string) {
        this.languageEditorPanel.setText(string);
    }

    public void clearEditorText() {
        this.languageEditorPanel.clearEditorText();
    }

    public String getSyntax() {
        return this.languageEditorPanel.getSyntax();
    }

    public void setLanguageSnippetValidator(SnippetValidator snippetValidator) {
        this.languageEditorPanel.setSnippetValidator(snippetValidator);
    }

    public SnippetBuilderPanel getEditorPanel() {
        return this.languageEditorPanel;
    }

    public String getMemberProperty() {
        return this.memberProperty;
    }

    public void setMemberProperty(String string) {
        this.memberProperty = string;
    }

    public void setLanguageEditorUsage(String string) {
        this.languageEditorPanel.setEditorUsage(string);
    }

    private void addLanguagesCategory() {
        String[] stringArray;
        SpecTreeNode specTreeNode = new SpecTreeNode(HCSArb.getString("SNIPPET_CODE_EDITOR_LANGUAGES"), "");
        for (String string : stringArray = OraLocaleInfo.getAvailableLanguages()) {
            specTreeNode.add(new SpecTreeNode(string, string));
        }
        this.spec.getRootNode().add(specTreeNode);
    }

    private void addAttributesCategory(DimensionAttribute[] dimensionAttributeArray) {
        SpecTreeNode specTreeNode = new SpecTreeNode(HCSArb.getString("SNIPPET_CODE_EDITOR_ATTRIBUTES"), "");
        for (DimensionAttribute dimensionAttribute : dimensionAttributeArray) {
            specTreeNode.add(new SpecTreeNode(dimensionAttribute.getName(), dimensionAttribute.getName()));
        }
        this.spec.getRootNode().add(specTreeNode);
    }
}

