/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.hcs.HCSArb;
import oracle.hcs.db.LanguageDBSettings;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.model.LanguageDescription;
import oracle.hcs.db.model.LanguageDescriptionsHelper;
import oracle.hcs.db.model.StatefulDescriptions;
import oracle.hcs.db.panels.GeneralBaseEditorPanelContext;
import oracle.hcs.db.panels.HCSPanel;
import oracle.hcs.db.panels.HCSPanelReference;
import oracle.hcs.db.view.DescriptionPanelTreeLoaderXML;
import oracle.hcs.db.view.LanguagesSelectorDialog;
import oracle.hcs.db.view.MyTableCellEditor;
import oracle.hcs.tree.loader.TreeLoaderXML;
import oracle.hcs.tree.model.TreeTable;
import oracle.hcs.tree.view.JTreeTable;
import oracle.hcs.tree.view.JTreeTableToolTipManager;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class DescriptionPanel<T extends AbstractSchemaObjectWithDesc>
extends BaseEditorPanel<T>
implements JTreeTableToolTipManager {
    private TreeLoaderXML treeLoaderXML;
    private JTreeTable namingTreeTable;
    private String rootXMLNodeName;
    private int operationResult;
    private String editDescriptionText;
    private JButton modifyLanguagesBtn;
    private DefaultListModel descriptionTranslations = new DefaultListModel();
    private String defaultLanguage;
    private String[] initialLanguages;
    private boolean languagesChanged;
    private boolean languageDescriptionsModified;
    private boolean parentObjectCaptionModified;
    private boolean parentObjectDescriptionModified;
    static final int NAME_ROW = 0;
    static final int DESCRIPTION_ROW = 1;
    static final int CAPTION_ROW = 2;
    static final int DEFAULT_LANGUAGE_COLUMN = 1;
    private static final Logger LOG = Logger.getLogger(DescriptionPanel.class.getName());

    public DescriptionPanel() {
        this.layoutComponents();
    }

    public void setLanguageDescriptionsModified(boolean bl) {
        this.languageDescriptionsModified = bl;
    }

    public void setParentObjectCaptionModified(boolean bl) {
        this.parentObjectCaptionModified = bl;
    }

    public boolean isParentObjectCaptionModified() {
        return this.parentObjectCaptionModified;
    }

    public void setParentObjectDescriptionModified(boolean bl) {
        this.parentObjectDescriptionModified = bl;
    }

    public boolean isParentObjectDescriptionModified() {
        return this.parentObjectDescriptionModified;
    }

    protected DBObjectListener createObjectListener() {
        String[] stringArray = new String[]{"name"};
        return new SwingDBObjectPropertyListener(stringArray){

            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                if (DescriptionPanel.this.isEditing()) {
                    return;
                }
                GeneralBaseEditorPanelContext generalBaseEditorPanelContext = GeneralBaseEditorPanelContext.getInstance();
                if (!generalBaseEditorPanelContext.isDescriptionSynchOn()) {
                    return;
                }
                String string2 = (String)DescriptionPanel.this.namingTreeTable.getModel().getValueAt(2, 1);
                String string3 = (String)DescriptionPanel.this.namingTreeTable.getModel().getValueAt(1, 1);
                if (string.equals("name")) {
                    boolean bl;
                    Object object;
                    HCSPanelReference hCSPanelReference = HCSPanelReference.getInstance();
                    HCSPanel hCSPanel = hCSPanelReference.getMDSPanel();
                    ComponentFactory componentFactory = hCSPanel.getPanelHelper();
                    ComponentWrapper componentWrapper = componentFactory.findComponentWrapper("name");
                    String string4 = null;
                    if (componentWrapper == null) {
                        string4 = ((AbstractSchemaObjectWithDesc)DescriptionPanel.this.getUpdatedObject()).getName();
                    } else {
                        object = componentWrapper.getActiveComponent();
                        if (object instanceof JTextField) {
                            JTextField jTextField = (JTextField)componentWrapper.getActiveComponent();
                            String string5 = jTextField.getText();
                            if (string5.contains("\"")) {
                                string5 = string5.replaceAll("\"", "");
                                jTextField.setText(string5);
                            }
                            string4 = jTextField.getText();
                        } else {
                            string4 = ((AbstractSchemaObjectWithDesc)DescriptionPanel.this.getUpdatedObject()).getName();
                        }
                    }
                    object = (AbstractSchemaObjectWithDesc)DescriptionPanel.this.getUpdatedObject();
                    boolean bl2 = string2 != null && UIStringUtils.isObjectNameAndDescriptionEqual(((AbstractSchemaObjectWithDesc)DescriptionPanel.this.getUpdatedObject()).getName(), string2);
                    boolean bl3 = string3 != null && UIStringUtils.isObjectNameAndDescriptionEqual(((AbstractSchemaObjectWithDesc)DescriptionPanel.this.getUpdatedObject()).getName(), string3);
                    boolean bl4 = ((AbstractSchemaObjectWithDesc)object).getCaptionDirty();
                    boolean bl5 = DescriptionPanel.this.parentObjectCaptionModified;
                    bl5 = bl5 || bl4;
                    boolean bl6 = bl = DescriptionPanel.this.parentObjectDescriptionModified || ((AbstractSchemaObjectWithDesc)object).getDescriptionDirty() != false;
                    if (!(bl5 || string2 != null && bl2)) {
                        ((AbstractSchemaObjectWithDesc)object).setCaption(UIStringUtils.convertDescription(string4));
                    }
                    if (!(bl || string3 != null && bl3)) {
                        ((AbstractSchemaObjectWithDesc)object).setDescription(UIStringUtils.convertDescription(string4));
                    }
                    DescriptionPanel.this.updateDescriptions();
                }
            }
        };
    }

    private void updateDescriptions() {
        String string = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName();
        this.namingTreeTable.getModel().setValueAt(string, 0, 1);
        String string2 = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getCaption();
        this.namingTreeTable.getModel().setValueAt(string2, 2, 1);
        String string3 = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getDescription();
        this.namingTreeTable.getModel().setValueAt(string3, 1, 1);
    }

    protected void initialisePanel() {
        try {
            this.defaultLanguage = LanguageDBSettings.getDefaultLanguage(((OracleDatabaseImpl)this.getProvider()).getConnection());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.descriptionTranslations.contains(this.defaultLanguage)) {
            this.descriptionTranslations.addElement(this.defaultLanguage);
        }
        this.initExistingDescriptionTranslationColumns(this.descriptionTranslations);
        this.initTreeLoader();
        this.populateNameTreeTable();
    }

    private void initTreeLoader() {
        String string = this.getDescriptionXML();
        try {
            Object object;
            String string2 = this.getDescriptionEditorXML();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.descriptionTranslations.getSize() > 1) {
                object = this.descriptionTranslations.elements();
                while (object.hasMoreElements()) {
                    String string3 = (String)object.nextElement();
                    if (string3.equalsIgnoreCase(this.defaultLanguage)) continue;
                    arrayList.add(string3);
                }
            }
            this.treeLoaderXML = new DescriptionPanelTreeLoaderXML(string, this.getClass(), string2, arrayList);
            int n = 0;
            object = this.treeLoaderXML.getDocument().getChildNodes();
            if (n < object.getLength()) {
                this.rootXMLNodeName = object.item(n).getNodeName();
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public String escapeSpecialCharacters(String string) {
        return string.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    private void populateNameTreeTable() {
        TreeTable treeTable = (TreeTable)this.treeLoaderXML.getTree();
        this.namingTreeTable.setModel(treeTable);
        this.namingTreeTable.expandAll(true);
        this.namingTreeTable.getColumnModel().getColumn(0).setHeaderValue(HCSArb.getString("DESCRIPTION_PANEL_NAME_TITLE"));
        this.namingTreeTable.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.namingTreeTable.getColumnModel().getColumn(1).setHeaderValue(this.defaultLanguage);
        this.namingTreeTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        if (this.namingTreeTable.getColumnCount() > 2) {
            for (int i = 2; i < this.namingTreeTable.getColumnCount(); ++i) {
                this.namingTreeTable.getColumnModel().getColumn(i).setPreferredWidth(250);
            }
        }
    }

    protected void initExistingDescriptionTranslationColumns(DefaultListModel defaultListModel) {
        LanguageDescriptionsHelper languageDescriptionsHelper = (LanguageDescriptionsHelper)this.getUpdatedObject();
        for (LanguageDescription languageDescription : languageDescriptionsHelper.getLanguageDescriptions()) {
            if (defaultListModel.contains(languageDescription.getLanguage())) continue;
            defaultListModel.addElement(languageDescription.getLanguage());
        }
        Set<String> set = this.getAvailableLanguages();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (defaultListModel.contains(string)) continue;
            defaultListModel.addElement(string);
        }
    }

    protected abstract String[] getObjectXPaths();

    protected abstract String getDescriptionXML();

    protected abstract String getDescriptionEditorXML();

    protected Set<String> getAvailableLanguages() {
        return Collections.emptySet();
    }

    protected String getDescXML(String string, AbstractChildObjectWithDesc abstractChildObjectWithDesc) {
        return this.getDescXML(string, abstractChildObjectWithDesc.getName(), abstractChildObjectWithDesc);
    }

    protected Set<String> availableLanguagesSetForObject(LanguageDescriptionsHelper languageDescriptionsHelper) {
        if (languageDescriptionsHelper.getLanguageDescriptions().length > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            for (LanguageDescription languageDescription : languageDescriptionsHelper.getLanguageDescriptions()) {
                hashSet.add(languageDescription.getLanguage());
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    protected String getDescXML(String string, String string2, Descriptions descriptions) {
        string2 = this.escapeSpecialCharacters(string2);
        LanguageDescriptionsHelper languageDescriptionsHelper = this.getLanguageDescriptionsHelper(string, string2);
        String string3 = descriptions.getDescription();
        if (string3 == null) {
            string3 = "";
        }
        string3 = this.escapeSpecialCharacters(string3);
        String string4 = descriptions.getCaption();
        if (string4 == null) {
            string4 = "";
        }
        string4 = this.escapeSpecialCharacters(string4);
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = String.format("  <%s name=\"%s\">\n", string, string2);
        stringBuffer.append(string5);
        string5 = String.format("    <%sDescription description=\"%s\" caption=\"%s\" >\n", string, string3, string4);
        stringBuffer.append(string5);
        if (languageDescriptionsHelper != null) {
            LanguageDescription[] languageDescriptionArray;
            for (LanguageDescription languageDescription : languageDescriptionArray = languageDescriptionsHelper.getLanguageDescriptions()) {
                stringBuffer.append(String.format("<LanguageDescription language='%s' description='%s' caption='%s'/> \n", languageDescription.getLanguage(), languageDescription.getDescription(), languageDescription.getCaption()));
            }
        }
        stringBuffer.append(String.format("</%sDescription>\n", string));
        string5 = String.format("  </%s>\n", string);
        stringBuffer.append(string5);
        return stringBuffer.toString();
    }

    protected void commitPanel() {
        this.namingTreeTable.getDefaultEditor(Object.class).stopCellEditing();
        String string = this.treeLoaderXML.generateXML();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            Document document = documentBuilder.parse(new InputSource(stringReader));
            XPath xPath = XPathFactory.newInstance().newXPath();
            for (String string2 : this.getObjectXPaths()) {
                XPathExpression xPathExpression = xPath.compile(string2);
                Object object = xPathExpression.evaluate(document, XPathConstants.NODESET);
                NodeList nodeList = (NodeList)object;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.commitFromXMLNode(xPath, nodeList.item(i));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void commitFromXMLNode(XPath xPath, Node node) throws XPathExpressionException {
        Object object;
        StatefulDescriptions statefulDescriptions = this.findDBObjectWithDesc(node);
        LanguageDescriptionsHelper languageDescriptionsHelper = this.getLanguageDescriptionHelper(node);
        if (this.initialLanguages != null && this.initialLanguages.length != this.descriptionTranslations.size()) {
            for (String object2 : this.initialLanguages) {
                if (this.descriptionTranslations.contains(object2) || (object = languageDescriptionsHelper.findLanguageDescription(object2)) == null) continue;
                languageDescriptionsHelper.removeLanguageDescription((LanguageDescription)object);
            }
        }
        if (statefulDescriptions != null) {
            Object object3 = xPath.compile("*/@description");
            String string = object3.evaluate(node);
            if (!(string = string.trim()).equalsIgnoreCase(statefulDescriptions.getDescription()) && !this.isEditing()) {
                statefulDescriptions.markDescriptionDirty(true);
            }
            if (string.isEmpty()) {
                if (statefulDescriptions.getDescription() != null) {
                    statefulDescriptions.setDescription(string);
                }
            } else {
                statefulDescriptions.setDescription(string);
            }
            object3 = xPath.compile("*/@caption");
            String string2 = object3.evaluate(node);
            if (!(string2 = string2.trim()).equalsIgnoreCase(statefulDescriptions.getCaption()) && !this.isEditing()) {
                statefulDescriptions.markCaptionDirty(true);
            }
            if (string2.isEmpty()) {
                if (statefulDescriptions.getCaption() != null) {
                    statefulDescriptions.setCaption(string2);
                }
            } else {
                statefulDescriptions.setCaption(string2);
            }
            object3 = xPath.compile("./*[@language]");
            Object object2 = object3.evaluate(node, XPathConstants.NODESET);
            object = (NodeList)object2;
            for (int i = 0; i < object.getLength(); ++i) {
                this.addLanguageDescriptions(xPath, object.item(i), languageDescriptionsHelper);
            }
        }
    }

    private StatefulDescriptions findDBObjectWithDesc(Node node) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xPath.compile("@name");
        String string = xPathExpression.evaluate(node);
        String string2 = node.getNodeName();
        return this.findDBObjectWithDesc(string2, string);
    }

    private LanguageDescriptionsHelper getLanguageDescriptionHelper(Node node) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xPath.compile("@name");
        String string = xPathExpression.evaluate(node);
        String string2 = node.getNodeName();
        return this.getLanguageDescriptionsHelper(string2, string);
    }

    protected abstract StatefulDescriptions findDBObjectWithDesc(String var1, String var2);

    protected abstract LanguageDescriptionsHelper getLanguageDescriptionsHelper(String var1, String var2);

    private void addLanguageDescriptions(XPath xPath, Node node, LanguageDescriptionsHelper languageDescriptionsHelper) throws XPathExpressionException {
        if (languageDescriptionsHelper != null) {
            XPathExpression xPathExpression = xPath.compile("@language");
            String string = xPathExpression.evaluate(node);
            xPathExpression = xPath.compile("@description");
            String string2 = xPathExpression.evaluate(node);
            xPathExpression = xPath.compile("@caption");
            String string3 = xPathExpression.evaluate(node);
            LanguageDescription languageDescription = languageDescriptionsHelper.findLanguageDescription(string);
            if (languageDescription != null) {
                languageDescription.setDescription(string2);
                languageDescription.setCaption(string3);
            } else if (this.languagesChanged || !string2.isEmpty() || !string3.isEmpty() || this.languageDescriptionsModified) {
                languageDescription = new LanguageDescription(string);
                languageDescription.setLanguage(string);
                languageDescription.setDescription(string2);
                languageDescription.setCaption(string3);
                languageDescriptionsHelper.addLanguageDescription(languageDescription);
            }
        }
    }

    private void layoutComponents() {
        this.namingTreeTable = new JTreeTable();
        this.namingTreeTable.setToolTipManager(this);
        this.modifyLanguagesBtn = new JButton(HCSArb.getString("DESCRIPTION_PANEL_MODIFY_LANGUAGES_BTN"));
        this.modifyLanguagesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DescriptionPanel.access$1002(DescriptionPanel.this, new String[DescriptionPanel.this.descriptionTranslations.size()]);
                DescriptionPanel.this.descriptionTranslations.copyInto(DescriptionPanel.this.initialLanguages);
                LanguagesSelectorDialog languagesSelectorDialog = new LanguagesSelectorDialog((Frame)Ide.getMainWindow(), HCSArb.getString("LANGUAGES_SELECTOR_DIALOG_TITLE"), DescriptionPanel.this.descriptionTranslations, DescriptionPanel.this.defaultLanguage);
                languagesSelectorDialog.setVisible(true);
                if (languagesSelectorDialog.isOkClicked() && !DescriptionPanel.this.descriptionTranslations.isEmpty()) {
                    DescriptionPanel.this.languagesChanged = true;
                    DescriptionPanel.this.initTreeLoader();
                    DescriptionPanel.this.populateNameTreeTable();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.namingTreeTable, 30, 20);
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent((Component)this.namingTreeTable, "languageDescriptions");
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(jScrollPane, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.modifyLanguagesBtn, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.namingTreeTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                Object object2;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 1 && (object2 = jTable.getModel().getValueAt(n, 0)) instanceof String && (string = (String)object2).toLowerCase().endsWith("/name")) {
                    Font font = component.getFont();
                    component.setFont(font.deriveFont(1));
                }
                return component;
            }
        });
        this.namingTreeTable.setDefaultEditor(Object.class, new MyTableCellEditor(this));
        this.namingTreeTable.setShowGrid(true);
    }

    @Override
    public String getCellToolTipValue(JTreeTable jTreeTable, int n, int n2) {
        if (n > 0) {
            Object object = jTreeTable.getValueAt(n2, n);
            if (object != null) {
                return object.toString();
            }
            return null;
        }
        return null;
    }

    protected void setEditOperationResult(int n) {
        this.operationResult = n;
    }

    protected int getEditOperationResult() {
        return this.operationResult;
    }

    protected void setEditDescriptionText(String string) {
        this.editDescriptionText = string;
    }

    protected String getEditDescriptionText() {
        return this.editDescriptionText;
    }

    protected String getJTreeTableCellValue(int n) {
        Object object = this.namingTreeTable.getValueAt(n, 0);
        return object.toString();
    }

    static /* synthetic */ String[] access$1002(DescriptionPanel descriptionPanel, String[] stringArray) {
        descriptionPanel.initialLanguages = stringArray;
        return stringArray;
    }
}

