/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.hierarchy;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.dimension.DimensionLevelsSorter;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.metadata.HCSSchema;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;

public class HierarchyValidator
extends SchemaObjectValidator<Hierarchy> {
    public HierarchyValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateObjectProperty(Hierarchy hierarchy, Hierarchy hierarchy2, String string) throws ValidationException {
        if (hierarchy2.isSkipValidation()) {
            return;
        }
        if (string.equalsIgnoreCase("caption")) {
            return;
        }
        if (string.toLowerCase().indexOf("description") != -1) {
            return;
        }
        super.validateObjectProperty((DBObject)hierarchy, (DBObject)hierarchy2, string);
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }

    @DBObjectValidator.PropertyValidator(value={"hierarchyLevels"})
    public void validateLevels(Hierarchy hierarchy, Hierarchy hierarchy2) throws ValidationException {
        int n = hierarchy2.getHierarchyLevels().length;
        if (n == 0) {
            throw new ValidationException((DBObject)hierarchy2, HCSArb.getString("HIERARCHY_VALIDATE_LEVELS_ERROR"));
        }
        this.validateDimension(hierarchy, hierarchy2);
    }

    @DBObjectValidator.PropertyValidator(value={"dimension"})
    public void validateDimension(Hierarchy hierarchy, Hierarchy hierarchy2) throws ValidationException {
        AttributeDimension attributeDimension = hierarchy2.getDimension();
        if (attributeDimension == null) {
            throw new ValidationException((DBObject)hierarchy2, HCSArb.getString("HIERARCHY_VALIDATE_DIMENSION_ERROR"));
        }
        HCSSchema hCSSchema = null;
        ArrayList<Hierarchy> arrayList = new ArrayList<Hierarchy>();
        ArrayList<Hierarchy> arrayList2 = new ArrayList<Hierarchy>();
        arrayList.add(hierarchy2);
        try {
            hCSSchema = HCSMetadataCache.getUpdatedSchema(Connections.getInstance().getConnectionName((Database)((OracleDatabaseImpl)this.getProvider())), attributeDimension.getSchema().getName());
            for (Hierarchy object : hCSSchema.getHierarchies(attributeDimension)) {
                if (object.getName().equals(hierarchy2.getName())) continue;
                object.setHierarchyLevels(object.getHierarchyLevelsReverse());
                arrayList2.add(object);
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (arrayList.size() > 1) {
            ArrayList arrayList3 = new ArrayList();
            for (Hierarchy hierarchy3 : arrayList) {
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (HierarchyLevel hierarchyLevel : hierarchy3.getHierarchyLevelsReverse()) {
                    arrayList4.add(hierarchyLevel.getLevel().getName());
                }
                arrayList3.add(arrayList4);
            }
            DimensionLevel[] dimensionLevelArray = DimensionLevelsSorter.getSortedLevels(arrayList3, arrayList);
            if (dimensionLevelArray == null) {
                this.restoreHierarchiesOriginalLevelOrder(arrayList2);
                throw new ValidationException((DBObject)hierarchy2, HCSArb.format("VALIDATION_ERROR_LEVELS_CYCLE_HIERARCHY_MSG", attributeDimension.getName()));
            }
            this.restoreHierarchiesOriginalLevelOrder(arrayList2);
        }
    }

    private void restoreHierarchiesOriginalLevelOrder(List<Hierarchy> list) {
        for (Hierarchy hierarchy : list) {
            hierarchy.setHierarchyLevels(hierarchy.getHierarchyLevelsReverse());
        }
    }
}

