/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.navigator;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.av.calcs.DockableSpecTree;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheMeasureProviderContext;
import oracle.hcs.db.AVCalcPersistSQL;
import oracle.hcs.db.DatabaseImpl;
import oracle.hcs.db.HCSExceptionHandler;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.hcs.syntax.HCSRuntimeException;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntaxbuilder.HCSSyntaxHandler;
import oracle.hcs.syntaxbuilder.HCSSyntaxParser;
import oracle.hcs.syntaxbuilder.SyntaxBuilderLauncher;
import oracle.hcs.syntaxbuilder.editor.CalculatedMeasureCompilerPage;
import oracle.hcs.syntaxbuilder.editor.EditorActions;
import oracle.hcs.syntaxbuilder.shuttle.TemplateHandler;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.templates.syntaxparser.ParseException;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.util.NameProvider;
import oracle.ide.Context;
import oracle.ide.compiler.Diagnostic;
import oracle.ide.controller.IdeAction;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.ojc.interfaces.Storage;

public class CalculatedMeasureNode
extends DatabaseSourceNode
implements Comparable {
    private static Logger LOG = Logger.getLogger(CalculatedMeasureNode.class.getName());
    public static final String TYPE_CALC_MEASURE_EXPRESSION = "HCSCALCMEASURE";
    public static final String MEASURE_NAME_KEY = "MEASURE_NAME";
    public static final String ANALYTIC_VIEW_NAME_KEY = "ANALYTIC_VIEW_NAME";
    public static final String COMPILE_ERROR_LINE_NUMBER_KEY = "COMPILE_ERROR_LINE_NUMBER";
    public static final String COMPILE_ERROR_COLUMN_NUMBER_KEY = "COMPILE_ERROR_COLUMN_NUMBER";
    private Boolean isBreadcrumbsOn;
    private Boolean isGutterNavOn;
    private String connectionName;
    private String measure;
    private String analyticView;
    private String schema;
    private String fullName;
    private String shortName;
    private TemplateHandler templateHandler;
    private ObjectFolder folderNode;
    private String description;
    private String caption;
    private String measureFormat;
    private boolean isCompiled = false;
    private boolean forceCreate;
    private boolean isCompiledWithErrors = false;
    private List<Throwable> lastCompileErrorsList = null;
    private Throwable sqlError;
    private static final Pattern errorPattern = Pattern.compile("^Lexical error at line (\\d+), column (\\d+)\\..*");
    private static final Pattern newLinePattern = Pattern.compile("\r?\n");

    public void openImpl() throws IOException {
        if (this.isBreadcrumbsOn()) {
            PlSqlFeatures.setSupportedBreadcrumbs((boolean)false);
        }
        if (this.isGutterNavOn()) {
            PlSqlFeatures.setSupportedGutterNavigation((boolean)false);
        }
        super.openImpl();
    }

    public void setForceCreate(boolean bl) {
        this.forceCreate = bl;
    }

    public boolean isForceCreate() {
        return this.forceCreate;
    }

    public boolean isBreadcrumbsOn() {
        if (this.isBreadcrumbsOn == null) {
            this.isBreadcrumbsOn = PlSqlFeatures.isSupportedBreadcrumbs();
        }
        return this.isBreadcrumbsOn;
    }

    public boolean isGutterNavOn() {
        if (this.isGutterNavOn == null) {
            this.isGutterNavOn = PlSqlFeatures.isSupportedGutterNavigation();
        }
        return this.isGutterNavOn;
    }

    public String getAVName() {
        return (String)this.getProperty(ANALYTIC_VIEW_NAME_KEY);
    }

    public String getMeasureName() {
        return (String)this.getProperty(MEASURE_NAME_KEY);
    }

    public Icon getIcon() {
        return HCSNavigatorResource.getIcon("HCSCALCMEASURE_ICON");
    }

    protected Reader createReader(URL uRL) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        this.setURL(uRL);
        hashMap.put("MEASURE", this.measure);
        hashMap.put("ANALYTIC_VIEW", this.analyticView);
        hashMap.put("SCHEMA", this.schema);
        try {
            HCSSchema hCSSchema = HCSMetadataCache.getSchema(this.getConnectionName(), this.schema);
            Connection connection = Connections.getInstance().getConnection(this.getConnectionName());
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            String string = dBUtil.executeOracleReturnOneCol("select MEAS_EXPRESSION from ALL_ANALYTIC_VIEW_CALC_MEAS where OWNER = :SCHEMA and ANALYTIC_VIEW_NAME =:ANALYTIC_VIEW and MEASURE_NAME = :MEASURE", hashMap);
            NameProvider nameProvider = NameProvider.getInstance();
            nameProvider.setProvider(this.getProvider());
            if (string != null) {
                Properties properties = new Properties();
                properties.setProperty("SCHEMA", this.schema);
                properties.setProperty("CUBE", this.analyticView);
                HCSSyntaxParser hCSSyntaxParser = new HCSSyntaxParser(hCSSchema, properties);
                string = HCSSyntaxHandler.format(this.schema, string);
                String string2 = hCSSyntaxParser.formatSyntax(string);
                if (hCSSyntaxParser.parseSyntax(string2, null)) {
                    this.callDefaultTemplate();
                    return new StringReader(string2);
                }
                this.callDefaultTemplate();
                return new StringReader(string);
            }
            LOG.severe(String.format("Could not fetch measure expression for measure,analytic view,schema = %s,%s,%s", this.measure, this.analyticView, this.schema));
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        return new StringReader("");
    }

    private void callDefaultTemplate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CalculatedMeasureNode.this.templateHandler != null) {
                    CalculatedMeasureNode.this.templateHandler.callDefaultTemplate();
                }
            }
        });
    }

    public Object getProperty(String string) {
        String string2 = null;
        if ("TYPE".equals(string)) {
            string2 = TYPE_CALC_MEASURE_EXPRESSION;
        } else if ("NAME".equals(string) || "LONG_NAME".equals(string)) {
            string2 = this.fullName;
        } else if ("SHORT_NAME".equals(string)) {
            string2 = this.shortName;
        } else if ("SCHEMA".equals(string)) {
            string2 = this.schema;
        } else if (MEASURE_NAME_KEY.equals(string)) {
            string2 = this.measure;
        } else if (ANALYTIC_VIEW_NAME_KEY.equals(string)) {
            string2 = this.analyticView;
        } else if ("ConnectionName".equals(string)) {
            string2 = this.connectionName;
        } else {
            if ("RUNNABLE".equals(string)) {
                return Boolean.TRUE.toString();
            }
            string2 = this.getNodeInstance() == null ? null : this.getNodeInstance().getProperty(string);
        }
        return string2;
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        if (uRL != null) {
            this.fullName = DBURLFormatHelper.getName((URL)uRL);
            this.shortName = this.fullName.contains(".") ? this.fullName.substring(this.fullName.indexOf(".") + 1) : this.fullName;
            IdentifierElement identifierElement = new IdentifierElement(this.fullName);
            this.connectionName = DBURLFormatHelper.getConnectionName((URL)uRL);
            this.analyticView = identifierElement.getFirst();
            this.measure = identifierElement.getSecond();
            this.schema = DBURLFormatHelper.getSchema((URL)uRL);
        }
    }

    public String getConnectionName() {
        return (String)this.getProperty("ConnectionName");
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            return;
        }
        if (!"TYPE".equals(string)) {
            if ("NAME".equals(string)) {
                this.fullName = object.toString();
            } else if ("SCHEMA".equals(string)) {
                this.schema = object.toString();
            } else if ("ConnectionName".equals(string)) {
                this.connectionName = object.toString();
            } else if (this.getNodeInstance() != null) {
                this.getNodeInstance().setProperty(string, object);
            }
        }
    }

    public String getObjectType() {
        return TYPE_CALC_MEASURE_EXPRESSION;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public Object getProviderIdentifier() {
        return this.connectionName;
    }

    public String getObjectName() {
        return this.fullName;
    }

    public int compareTo(Object object) {
        String string;
        if (object instanceof CalculatedMeasureNode && this.getMeasureName() != null && (string = ((CalculatedMeasureNode)object).getMeasureName()) != null) {
            return this.getMeasureName().compareTo(string);
        }
        return 0;
    }

    protected void saveImpl() throws IOException {
        this.commit(this.getConnectionName(), this.getSchemaName(), this.getAVName(), this.getMeasureName(), this.description, this.caption, this.getSource());
        IdeAction ideAction = IdeAction.find((int)EditorActions.Type.COMPILE.getCommandId());
        if (ideAction != null) {
            try {
                ideAction.performAction(Context.newIdeContext((Node)this));
            }
            catch (Exception exception) {
                LOG.warning(String.format("Error compiling %s after save.", this.getMeasureName()));
            }
        }
        if (this.folderNode != null) {
            this.folderNode = null;
        }
        try {
            HCSSchema hCSSchema = HCSMetadataCache.getUpdatedSchema(this.getConnectionName(), this.getSchemaName());
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
    }

    protected void closeImpl() throws IOException {
        LogPage logPage = CalculatedMeasureCompilerPage.getErrorLog();
        logPage.getLogPageView().close();
        super.closeImpl();
    }

    private void commit(String string, String string2, String string3, final String string4, String string5, String string6, String string7) {
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            DatabaseImpl databaseImpl = new DatabaseImpl(connection);
            HCSSchema hCSSchema = HCSMetadataCache.getSchema(string, string2);
            Properties properties = new Properties();
            properties.setProperty("SCHEMA", string2);
            properties.setProperty("CUBE", string3);
            properties.setProperty("CONTEXT", "MEASURE_EXPRESSION");
            if (hCSSchema == null) {
                hCSSchema = SyntaxBuilderLauncher.populateSchema(null, properties, null, databaseImpl);
            }
            AnalyticView analyticView = (AnalyticView)hCSSchema.getNamedObject(string3);
            if (string7 == null) {
                string7 = "0";
            }
            AnalyticView analyticView2 = CalculatedMeasureNode.getAV(string2, string3);
            AVCalcPersistSQL aVCalcPersistSQL = null;
            String string8 = "FREE_FORM";
            try {
                Object object;
                Object object2;
                HCSSyntaxParser hCSSyntaxParser;
                Spec spec = DockableSpecTree.getInstance().getSpec(string, string2, string3);
                if (spec != null && (hCSSyntaxParser = new HCSSyntaxParser(hCSSchema, properties)).parseSyntax(string7, (ParseNode)(object2 = new ParseNode())) && ((DefaultMutableTreeNode)object2).getChildCount() == 1 && (object = spec.findMatchingNode(((ParseNode)object2).getChildren().get(0))) != null && !"QDRMEASURE".equals(((SpecTreeNode)object).getType())) {
                    string8 = ((SpecTreeNode)object).getType();
                }
                if (this.isForceCreate()) {
                    analyticView.setForceCreate(true);
                } else {
                    analyticView.setForceCreate(false);
                }
                aVCalcPersistSQL = new AVCalcPersistSQL(databaseImpl, analyticView);
                aVCalcPersistSQL.setThrowException(false);
                hCSSyntaxParser = this.getProvider();
                object2 = AVCacheMeasureProviderContext.getInstance();
                ((AVCacheMeasureProviderContext)object2).setProvider((DBObjectProvider)hCSSyntaxParser);
                object = (Database)hCSSyntaxParser;
                aVCalcPersistSQL.setProvider((Database)object);
                if (string5 != null && string5.trim().isEmpty()) {
                    string5 = null;
                }
                if (string6 != null && string6.trim().isEmpty()) {
                    string6 = null;
                }
                if (string5 != null) {
                    aVCalcPersistSQL.setDescription(analyticView, string4, "DESCRIPTION", string5);
                    this.description = null;
                }
                if (string6 != null) {
                    aVCalcPersistSQL.setDescription(analyticView, string4, "CAPTION", string6);
                    this.caption = null;
                }
                if (this.measureFormat != null) {
                    aVCalcPersistSQL.setDescription(analyticView, string4, "FORMAT_STRING", this.measureFormat);
                    this.measureFormat = null;
                }
                Object object3 = aVCalcPersistSQL.addDerivedMeasure(analyticView, string4, string8, string7, null);
                aVCalcPersistSQL.commit();
                this.sqlError = null;
                this.isCompiled = true;
                this.isCompiledWithErrors = false;
            }
            catch (Exception exception) {
                this.isCompiledWithErrors = true;
                this.sqlError = exception;
                this.setLastCompileErrorsList(this.lastCompileErrorsList);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HCSExceptionHandler.handleException(null, HCSArb.format("EXPRESSION_EDITOR_SAVE_CALC_MEASURE_ERROR", string4) + "\n" + exception.getLocalizedMessage());
                        CalculatedMeasureNode.this.markDirty(true);
                        CalculatedMeasureNode.this.logError(CalculatedMeasureNode.this.lastCompileErrorsList);
                    }
                });
            }
        }
        catch (DBException dBException) {
            LOG.log(Level.SEVERE, dBException.getLocalizedMessage(), dBException);
        }
    }

    private static AnalyticView getAV(String string, String string2) {
        AnalyticView analyticView = new AnalyticView();
        analyticView.setName(string2);
        analyticView.setSchema(new HCSSchema(string));
        return analyticView;
    }

    public void setTemplateHandler(TemplateHandler templateHandler) {
        this.templateHandler = templateHandler;
    }

    public TemplateHandler getTemplateHandler() {
        return this.templateHandler;
    }

    public void setFolderNode(ObjectFolder objectFolder) {
        this.folderNode = objectFolder;
    }

    public void setDescriptions(String string, String string2, String string3) {
        this.description = string;
        this.caption = string2;
        this.measureFormat = string3;
    }

    public void logMessage(String string) {
        IdeStorage ideStorage = new IdeStorage((Node)this);
        ideStorage.setProperty("HCSCalculatedMeasureCompilerPage.URL", (Object)this.getURL());
        IdeLog ideLog = new IdeLog();
        LogPage logPage = CalculatedMeasureCompilerPage.getErrorLog();
        logPage.clearAll();
        ideLog.registerAsynchronousLogPage(logPage);
        ideLog.setProject(DBNavigatorWindow.getProject((String)this.getConnectionName()));
        ideLog.setWorkspace(DBNavigatorWindow.getWorkspace());
        ideLog.clear((Storage)ideStorage);
        if (this.isCompiled) {
            Diagnostic diagnostic = new Diagnostic(Diagnostic.Kind.INFO);
            diagnostic.setStorage((Storage)ideStorage);
            diagnostic.setLine(1);
            diagnostic.setColumn(1);
            diagnostic.setNumber(0);
            diagnostic.setMessage(string);
            ideLog.diagnostic(diagnostic);
        }
        ideLog.completed();
        ideLog.unregisterAsynchronousLogPage(logPage);
    }

    public void logError(List<Throwable> list) {
        IdeStorage ideStorage = new IdeStorage((Node)this);
        ideStorage.setProperty("HCSCalculatedMeasureCompilerPage.URL", (Object)this.getURL());
        IdeLog ideLog = new IdeLog();
        LogPage logPage = CalculatedMeasureCompilerPage.getErrorLog();
        logPage.clearAll();
        ideLog.registerAsynchronousLogPage(logPage);
        ideLog.setProject(DBNavigatorWindow.getProject((String)this.getConnectionName()));
        ideLog.setWorkspace(DBNavigatorWindow.getWorkspace());
        ideLog.clear((Storage)ideStorage);
        if (list == null) {
            return;
        }
        if (this.isCompiledWithErrors) {
            for (Throwable throwable : list) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                Map<String, Integer> map = this.getCompileErrorLocation(throwable);
                n = map.get(COMPILE_ERROR_LINE_NUMBER_KEY);
                n2 = map.get(COMPILE_ERROR_COLUMN_NUMBER_KEY);
                ideLog.error((Storage)ideStorage, n, n2, n3, throwable.getLocalizedMessage());
            }
        }
        ideLog.completed();
        ideLog.unregisterAsynchronousLogPage(logPage);
    }

    public Map<String, Integer> getCompileErrorLocation(Throwable throwable) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 1;
        int n2 = 1;
        try {
            Matcher matcher;
            Object object;
            if (throwable instanceof SyntaxException) {
                object = (SyntaxException)throwable;
                if (((HCSRuntimeException)object).getParameters().length == 4) {
                    n = Integer.parseInt(((HCSRuntimeException)object).getParameters()[1]);
                    n2 = Integer.parseInt(((HCSRuntimeException)object).getParameters()[2]);
                }
            } else if (throwable instanceof ParseException) {
                object = (ParseException)throwable;
                int n3 = 1;
                String string = this.getSource();
                Matcher matcher2 = newLinePattern.matcher(string);
                while (matcher2.find() && matcher2.start() <= ((ParseException)object).getOffset()) {
                    ++n3;
                }
                n = n3 == 0 ? 1 : n3;
                n2 = string.lastIndexOf("\n", ((ParseException)object).getOffset());
                n2 = ((ParseException)object).getOffset() - n2;
            }
            object = throwable.getMessage();
            if (n == 0 && object != null && (matcher = errorPattern.matcher((CharSequence)object)).matches() && matcher.groupCount() == 3) {
                n = Integer.parseInt(matcher.group(1));
                n2 = Integer.parseInt(matcher.group(2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
            n2 = 1;
        }
        hashMap.put(COMPILE_ERROR_LINE_NUMBER_KEY, n);
        hashMap.put(COMPILE_ERROR_COLUMN_NUMBER_KEY, n2);
        return hashMap;
    }

    public void clearCompileLog() {
        LogPage logPage = CalculatedMeasureCompilerPage.getErrorLog();
        logPage.clearAll();
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public void setCompiled(boolean bl) {
        this.isCompiled = bl;
    }

    public boolean isCompiledWithErrors() {
        return this.isCompiledWithErrors;
    }

    public void setCompiledWithErrors(boolean bl) {
        this.isCompiledWithErrors = bl;
    }

    public List<Throwable> getLastCompileErrorsList() {
        return this.lastCompileErrorsList;
    }

    public void setLastCompileErrorsList(List<Throwable> list) {
        this.lastCompileErrorsList = list;
        if (this.sqlError != null) {
            if (this.lastCompileErrorsList == null) {
                this.lastCompileErrorsList = new ArrayList<Throwable>();
            } else {
                for (Throwable throwable : this.lastCompileErrorsList) {
                    if (!(throwable instanceof SQLException)) continue;
                    this.lastCompileErrorsList.remove(throwable);
                    break;
                }
            }
            this.lastCompileErrorsList.add(this.sqlError);
        }
    }

    public String getLongLabel() {
        if (this.getProperty("LONG_NAME") != null) {
            String string = (String)this.getProperty("LONG_NAME");
            return string;
        }
        return super.getLongLabel();
    }
}

