/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.RowExpression;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class BinaryOperatorExpression
extends RowExpression {
    public static final String PLUS = "+";
    public static final String MINUS = "-";
    public static final String DIVIDE = "/";
    public static final String TIMES = "*";
    public static final String CONCAT = "||";
    static final String[] ALL_OPERATORS = new String[]{"+", "-", "/", "*", "||"};
    static final String[] ALL_MULTI_OPERATORS = new String[]{"+", "*", "||"};
    static final int[] CATEGORY_LIST = new int[]{16, 8, 4};
    private String m_Operator;
    private TypedExpression[] m_Arguments = null;

    private TypedExpression[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    private int getArgumentCategory(DataType dataType) {
        if (this.getOperator() == CONCAT) {
            dataType.validateType(31);
            return 65;
        }
        return dataType.getCategory(CATEGORY_LIST, 3);
    }

    private void initializeDataType() {
        DataType dataType = this.getArgumentsInternal()[0].getDataType();
        int n = this.getArgumentCategory(dataType);
        if (3 == n) {
            dataType = DataType.NUMBER;
        } else if (!(65 != n || dataType != DataType.NULL_TYPE && dataType.matchesCategory(65))) {
            dataType = DataType.VARCHAR2;
        }
        for (int i = 1; i < this.getArgumentsInternal().length; ++i) {
            TypedExpression typedExpression = this.getArgumentsInternal()[i];
            DataType dataType2 = typedExpression.getDataType();
            int n2 = this.getArgumentCategory(dataType2);
            boolean bl = false;
            int n3 = -1;
            switch (n) {
                case 65: {
                    if (this.getOperator() != CONCAT) break;
                    n3 = 65;
                    break;
                }
                case 4: {
                    if (this.getOperator() == PLUS) {
                        if (16 == n2) {
                            n3 = 16;
                            dataType = dataType2;
                            break;
                        }
                        if (8 == n2) {
                            n3 = 8;
                            dataType = dataType2;
                            break;
                        }
                        if (4 != n2) break;
                        dataType2.validateType(dataType);
                        n3 = 4;
                        break;
                    }
                    if (this.getOperator() == TIMES && 3 == n2) {
                        n3 = 4;
                        break;
                    }
                    if (this.getOperator() != DIVIDE || 3 != n2) break;
                    n3 = 4;
                    break;
                }
                case 16: {
                    if (!(this.getOperator() != PLUS && this.getOperator() != MINUS || 3 != n2 && 4 != n2)) {
                        n3 = 16;
                        break;
                    }
                    if (this.getOperator() != MINUS || 4 != n2 && 8 != n2 && 16 != n2) break;
                    n3 = 4;
                    dataType = DataType.YM_INTERVAL;
                    break;
                }
                case 8: {
                    if (this.getOperator() == PLUS && 4 == n2) {
                        n3 = 8;
                        break;
                    }
                    if (this.getOperator() != MINUS || 3 != n2 && 4 != n2 && 8 != n2 && 16 != n2) break;
                    n3 = 8;
                    break;
                }
                case 3: {
                    if (3 == n2) {
                        n3 = 3;
                        break;
                    }
                    if (this.getOperator() == PLUS && (16 == n2 || 8 == n2)) {
                        n3 = 16;
                        dataType = dataType2;
                        break;
                    }
                    if (this.getOperator() != TIMES || 4 != n2) break;
                    n3 = 4;
                    dataType = dataType2;
                }
            }
            if (-1 == n3) {
                throw new SyntaxException("BadDatatype", dataType2.getName());
            }
            n = n3;
        }
        this.setDataType(dataType);
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        for (int i = 0; i < this.getArgumentsInternal().length; ++i) {
            if (0 != i) {
                syntaxPrintingContext.append(" ");
                syntaxPrintingContext.append(this.getOperator());
                syntaxPrintingContext.append(" ");
            }
            syntaxPrintingContext.print(this.getArgumentsInternal()[i]);
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.validateComponents(this, this.getArgumentsInternal());
        this.initializeDataType();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getArgumentsInternal());
    }

    public BinaryOperatorExpression(String string, TypedExpression[] typedExpressionArray) {
        BinaryOperatorExpression.validateValues(typedExpressionArray, 2);
        this.m_Operator = typedExpressionArray.length > 2 ? BinaryOperatorExpression.validateEnum(string, ALL_MULTI_OPERATORS) : BinaryOperatorExpression.validateEnum(string, ALL_OPERATORS);
        this.m_Arguments = (TypedExpression[])typedExpressionArray.clone();
        this.initialize();
    }

    public BinaryOperatorExpression(TypedExpression typedExpression, String string, TypedExpression typedExpression2) {
        this(string, new TypedExpression[]{typedExpression, typedExpression2});
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBinaryOperatorExpression(this, object);
    }

    @Override
    public String getOperator() {
        return this.m_Operator;
    }

    public TypedExpression[] getArguments() {
        return (TypedExpression[])this.getArgumentsInternal().clone();
    }
}

