/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.LiteralExpression;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;

public class DateExpression
extends LiteralExpression {
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private String m_Value = null;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getDataType().getName());
    }

    public DateExpression(String string, DataType dataType) {
        DateExpression.validateValue(string);
        this.m_Value = string;
        if (dataType != DataType.DATE && dataType != DataType.TIMESTAMP) {
            throw new SyntaxException("DateOrTimestampExpected");
        }
        this.setDataType(dataType);
        SimpleDateFormat simpleDateFormat = null;
        if (this.getDataType() == DataType.DATE) {
            simpleDateFormat = DATE_FORMAT;
            simpleDateFormat.setLenient(false);
            try {
                Date date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                throw new SyntaxException("BadDateFormat", string);
            }
        }
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitDateExpression(this, object);
    }

    public String getValue() {
        return this.m_Value;
    }
}

