/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.syntax.BaseMetadataObjectReference;
import oracle.hcs.syntax.DataObject;
import oracle.hcs.syntax.HierarchyQualifierArgument;
import oracle.hcs.syntax.Qualifier;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.parser.ExpParser;

public final class HierarchyQualifier
extends DataObject {
    private BaseMetadataObjectReference m_Hierarchy;
    private TypedExpression m_Expression;
    private List<Qualifier> m_qualifiers;
    private HierarchyQualifierArgument m_hierarchyQualifierArgument;
    private List<HierarchyQualifierArgument> m_hierarchyQualifierArguments = new ArrayList<HierarchyQualifierArgument>();

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        this.m_Hierarchy.toSyntax(syntaxPrintingContext);
        syntaxPrintingContext.append(" = ");
        if (this.getExpression() != null) {
            syntaxPrintingContext.print(this.getExpression());
        } else if (this.m_qualifiers != null) {
            for (Qualifier object : this.m_qualifiers) {
                syntaxPrintingContext.print(object);
                syntaxPrintingContext.append(" ,");
            }
        }
        if (this.m_hierarchyQualifierArgument != null) {
            this.m_hierarchyQualifierArgument.toSyntax(syntaxPrintingContext);
        }
        int n = 0;
        if (this.m_hierarchyQualifierArguments != null) {
            for (HierarchyQualifierArgument hierarchyQualifierArgument : this.m_hierarchyQualifierArguments) {
                if (n != 0) {
                    syntaxPrintingContext.append(", ");
                }
                hierarchyQualifierArgument.toSyntax(syntaxPrintingContext);
                ++n;
            }
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        if (this.m_Expression != null) {
            this.m_Expression = validationContext.validateExp(this.m_Expression);
        }
        this.m_Hierarchy = (BaseMetadataObjectReference)validationContext.validate(this.m_Hierarchy);
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Hierarchy.isDefinitionComplete()) {
            return false;
        }
        if (!this.getExpression().isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    public HierarchyQualifier(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, TypedExpression typedExpression, HierarchyQualifierArgument hierarchyQualifierArgument) {
        HierarchyQualifier.validateValue(baseMetadataObjectReference);
        if (typedExpression != null) {
            HierarchyQualifier.validateValue(typedExpression);
        }
        this.m_Hierarchy = baseMetadataObjectReference;
        this.m_Expression = typedExpression;
        this.m_hierarchyQualifierArgument = hierarchyQualifierArgument;
        this.initialize();
    }

    public HierarchyQualifier(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, TypedExpression typedExpression, List<HierarchyQualifierArgument> list) {
        HierarchyQualifier.validateValue(baseMetadataObjectReference);
        if (typedExpression != null) {
            HierarchyQualifier.validateValue(typedExpression);
        }
        this.m_Hierarchy = baseMetadataObjectReference;
        this.m_Expression = typedExpression;
        this.m_hierarchyQualifierArguments = list;
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitHierarchyQualifier(this, object);
    }

    public String getHierarchyID() {
        return this.m_Hierarchy.getIdentifier().toString();
    }

    public TypedExpression getExpression() {
        return this.m_Expression;
    }

    public List<Qualifier> getQualifiers() {
        return this.m_qualifiers;
    }

    public HierarchyQualifierArgument getHierarchyQualifierArgument() {
        return this.m_hierarchyQualifierArgument;
    }

    public List<HierarchyQualifierArgument> getHierarchyQualifierArguments() {
        return this.m_hierarchyQualifierArguments;
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

