/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.List;
import oracle.hcs.syntax.DataObject;
import oracle.hcs.syntax.OrderByElement;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.ValidationContext;

public final class OrderByClause
extends DataObject {
    private OrderByElement[] m_Elements = null;

    private OrderByElement[] getElementsInternal() {
        return this.m_Elements;
    }

    private static OrderByElement[] createOrderByElementArray(List<OrderByElement> list) {
        if (null == list) {
            return null;
        }
        OrderByElement[] orderByElementArray = new OrderByElement[list.size()];
        list.toArray(orderByElementArray);
        return orderByElementArray;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("ORDER BY");
        for (int i = 0; i < this.getElementsInternal().length; ++i) {
            if (i != 0) {
                syntaxPrintingContext.append(",");
            }
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.print(this.getElementsInternal()[i]);
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.validateComponents(this, this.getElementsInternal());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getElementsInternal());
    }

    public OrderByClause(OrderByElement[] orderByElementArray) {
        OrderByClause.validateValues(orderByElementArray, 1);
        this.m_Elements = (OrderByElement[])orderByElementArray.clone();
        this.initialize();
    }

    public OrderByClause(List<OrderByElement> list) {
        this(OrderByClause.createOrderByElementArray(list));
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitOrderByClause(this, object);
    }

    public OrderByElement[] getElements() {
        return (OrderByElement[])this.getElementsInternal().clone();
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

