/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax.parser;

import java.util.ArrayList;
import java.util.List;

public final class Identifier {
    private List<String> m_Components = new ArrayList<String>();
    private boolean m_HasNamespace = false;
    private Class m_ObjectType = null;

    private Identifier subID(int n, int n2) {
        int n3;
        String[] stringArray = new String[n2 - n + 1];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = this.getComponent(n + n3);
        }
        n3 = this.hasNamespace() ? 1 : 0;
        if (n != 0) {
            n3 = 0;
        }
        return new Identifier(stringArray, n3 != 0);
    }

    private Identifier subID(int n) {
        return this.subID(0, n - 1);
    }

    public Identifier() {
    }

    Identifier(String string) {
        this(string, false);
    }

    Identifier(String string, boolean bl) {
        this.addComponent(string);
        this.setHasNamespace(bl);
    }

    Identifier(String[] stringArray, boolean bl) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addComponent(stringArray[i]);
        }
        this.setHasNamespace(bl);
    }

    public Identifier(Identifier identifier) {
        this.setValue(identifier);
    }

    public void addComponent(String string) {
        this.getComponents().add(string);
    }

    void addComponent(int n, String string) {
        this.getComponents().add(n, string);
    }

    void removeComponent(int n) {
        this.getComponents().remove(n);
    }

    List<String> getComponents() {
        return this.m_Components;
    }

    public int getNumComponents() {
        return this.getNumComponents(true);
    }

    public int getNumComponents(boolean bl) {
        int n = this.getComponents().size();
        if (!bl && this.hasNamespace()) {
            --n;
        }
        return n;
    }

    public String getComponent(int n) {
        return this.getComponents().get(n);
    }

    public void setComponent(int n, String string) {
        this.getComponents().set(n, string);
    }

    public String getName() {
        return this.getComponent(this.getNameIndex());
    }

    public void setName(String string) {
        this.setComponent(this.getNameIndex(), string);
    }

    public void trimToContainerID() {
        int n = this.getNameIndex();
        if (n <= this.getOwnerIndex()) {
            n = 0;
        }
        this.removeLastNComponents(this.getNumComponents() - n);
    }

    public void removeLastComponent() {
        this.removeComponent(this.getNumComponents() - 1);
    }

    public String getLastComponent() {
        return this.getComponent(this.getNumComponents() - 1);
    }

    public void removeLastNComponents(int n) {
        for (int i = 0; i < n; ++i) {
            this.removeLastComponent();
        }
    }

    public String getOwner() {
        return this.getComponent(this.getOwnerIndex());
    }

    void setOwner(String string) {
        this.setComponent(this.getOwnerIndex(), string);
    }

    void addOwner(String string) {
        this.addComponent(this.getOwnerIndex(), string);
    }

    public String getNamespace() {
        if (this.hasNamespace()) {
            return this.getComponent(0);
        }
        return null;
    }

    public void setNamespace(String string) {
        if (this.hasNamespace()) {
            if (null != string) {
                this.setComponent(0, string);
            } else {
                this.removeComponent(0);
                this.setHasNamespace(false);
            }
        } else if (null != string) {
            this.addComponent(0, string);
            this.setHasNamespace(true);
        }
    }

    public void setObjectType(Class clazz) {
        this.m_ObjectType = clazz;
    }

    public Class getObjectType() {
        return this.m_ObjectType;
    }

    public boolean isAWID() {
        return false;
    }

    void setValue(Identifier identifier) {
        if (identifier != this) {
            this.getComponents().clear();
            this.getComponents().addAll(identifier.getComponents());
            this.setHasNamespace(identifier.hasNamespace());
            this.setObjectType(identifier.getObjectType());
        }
    }

    public int getOwnerIndex() {
        return this.hasNamespace() ? 1 : 0;
    }

    public int getNameIndex() {
        if (this.isAWID()) {
            return this.getNumComponents() - 2;
        }
        return this.getNumComponents() - 1;
    }

    public boolean hasNamespace() {
        return this.m_HasNamespace;
    }

    void setHasNamespace(boolean bl) {
        this.m_HasNamespace = bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Identifier)) {
            return false;
        }
        Identifier identifier = (Identifier)object;
        if (this.getNumComponents() != identifier.getNumComponents()) {
            return false;
        }
        if (this.hasNamespace() != identifier.hasNamespace()) {
            return false;
        }
        for (int i = 0; i < this.getNumComponents(); ++i) {
            if (this.getComponent(i).equals(identifier.getComponent(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(this.getNumComponents());
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getNumComponents() && i < n; ++i) {
            if (1 == i && this.hasNamespace()) {
                stringBuffer.append("..");
            } else if (i != 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(this.getComponent(i));
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int getNumCommonComponents(Identifier identifier) {
        int n;
        if (this.hasNamespace() != identifier.hasNamespace()) {
            return 0;
        }
        for (n = 0; n < this.getNumComponents() && n < identifier.getNumComponents() && this.getComponent(n).equals(identifier.getComponent(n)); ++n) {
        }
        return n;
    }

    public boolean contains(Identifier identifier) {
        if (identifier.getNumComponents() > this.getNumComponents()) {
            return false;
        }
        int n = this.getNumCommonComponents(identifier);
        return n == identifier.getNumComponents();
    }

    public Identifier getParentID(int n) {
        return this.subID(n);
    }

    public Identifier getParentID() {
        return this.getParentID(this.getNumComponents() - 1);
    }

    public Identifier getTopLevelObjectID() {
        return this.subID(this.getOwnerIndex() + 1);
    }

    public static Identifier parseID(String string) {
        return Identifier.parseID(string, null);
    }

    public static Identifier parseID(String string, Class clazz) {
        String[] stringArray = string.split("\\.");
        boolean bl = false;
        if (stringArray.length > 1 && stringArray[1].length() == 0) {
            bl = true;
        }
        Identifier identifier = null;
        if (stringArray.length > 0) {
            identifier = new Identifier();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= 0) continue;
                identifier.addComponent(stringArray[i]);
            }
            identifier.setHasNamespace(bl);
            identifier.setObjectType(clazz);
        }
        return identifier;
    }
}

