/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.MetadataUpdateListener;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntaxbuilder.HCSSyntaxFormatter;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.syntaxbuilder.HCSSyntaxVisitor;
import oracle.hcs.syntaxbuilder.test.SyntaxTest;
import oracle.hcs.templates.syntaxparser.ParseException;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import oracle.hcs.templates.syntaxparser.SyntaxParserStateListener;
import oracle.hcs.templates.syntaxparser.SyntaxTokenListener;
import oracle.hcs.util.LogFileHandler;

public class HCSSyntaxParser
implements SyntaxParser,
MetadataUpdateListener {
    protected final HCSSyntaxFormatter formatter = new HCSSyntaxFormatter();
    protected final Properties props;
    private final EventListenerList listeners = new EventListenerList();
    private LinkedList<Integer> tokenBoundaries = new LinkedList();
    private ParseNode root;
    private List<Throwable> currentExceptions = new LinkedList<Throwable>();
    private Set<AVHierarchy> currentAVHierarchiesReferenced;
    private boolean isValid;
    private SyntaxTest syntaxTest;
    private boolean namesValid;
    protected String syntax;
    private static final Pattern tokens = Pattern.compile("(/\\*.*?\\*/)|(--[^\\n\\r]*(?:(?:\\r?\\n)|\\z))|('(?:[^']|'{2})*')|((?:(?:\\w+\\.)|(?:\"[^\"]+\"\\.)){0,3}(?:(?:\\w+)|(?:\"[^\"]+\")))|([()\\[\\]])|([-+/*,=><#]=?)|(\\r?\\n)", 296);
    private static final Pattern numeric = Pattern.compile("-?\\d*(\\.\\d+)?");
    private static final int BLOCK_COMMENT = 1;
    private static final int LINE_COMMENT = 2;
    private static final int STRING_LITERAL = 3;
    private static final int IDENTIFIER = 4;
    private static final int PAREN = 5;
    private static final int OPERATOR = 6;
    private static final int NEW_LINE = 7;
    private static final String operators = "-+/*,=><#=";
    private static final Logger LOG = Logger.getLogger(HCSSyntaxParser.class.getName());
    private HCSSchema schema;
    private String connectionName;
    protected HCSSyntaxVisitor visitor;
    private static final HashSet functions = new HashSet();

    public HCSSyntaxParser(HCSSchema hCSSchema, Properties properties) {
        this(hCSSchema, properties, new HCSSyntaxVisitor(hCSSchema, properties));
    }

    protected HCSSyntaxParser(HCSSchema hCSSchema, Properties properties, HCSSyntaxVisitor hCSSyntaxVisitor) {
        this.visitor = hCSSyntaxVisitor;
        this.setSchema(hCSSchema);
        this.schema = hCSSchema;
        this.props = properties;
    }

    private String getAV() {
        String string = this.props.getProperty("CUBE");
        return string;
    }

    public HCSSyntaxParser(String string, HCSSchema hCSSchema, Properties properties) {
        this(hCSSchema, properties);
        this.connectionName = string;
        HCSMetadataCache.addUpdateListener(string, hCSSchema.getName(), this);
    }

    public HCSSyntaxParser(String string, String string2, Properties properties) {
        this(null, properties);
        this.connectionName = string;
        HCSMetadataCache.addUpdateListener(string, string2, this);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public int[] getTokenBoundaries(int n) {
        ParseNode parseNode = this.getParseNode(n, n);
        if (parseNode != null) {
            return new int[]{parseNode.getOffset(), parseNode.getReplaceEnd(), parseNode.getEnd()};
        }
        if (!this.tokenBoundaries.isEmpty()) {
            int n2 = 0;
            int n3 = 0;
            Iterator iterator = this.tokenBoundaries.iterator();
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                n3 = (Integer)iterator.next();
                if (n < n2 || n > n3 || n3 - n2 <= 1) continue;
                return new int[]{n2, n3, n3};
            }
        }
        return new int[0];
    }

    @Override
    public ParseNode getParseNode(int n, int n2) {
        return this.getParseNode(n, n2, this.syntax);
    }

    protected ParseNode getParseNode(int n, int n2, String string) {
        block7: {
            if (this.root == null) break block7;
            if (n == n2) {
                Enumeration<TreeNode> enumeration = this.root.postorderEnumeration();
                while (enumeration.hasMoreElements()) {
                    ParseNode parseNode;
                    ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                    if (n < parseNode2.getOffset() || n > parseNode2.getReplaceEnd()) continue;
                    if (HCSSyntaxType.valueFrom(parseNode2.getType()) == HCSSyntaxType.MEASURE && HCSSyntaxType.valueFrom((parseNode = (ParseNode)parseNode2.getParent()).getType()) == HCSSyntaxType.QDR) {
                        parseNode2 = parseNode;
                    }
                    return parseNode2;
                }
            } else {
                Enumeration<TreeNode> enumeration = this.root.postorderEnumeration();
                while (n >= 0 && n - 1 < string.length() && Character.isWhitespace(string.charAt(n)) && n < n2) {
                    ++n;
                }
                while (n2 - 1 >= 0 && n2 - 1 < string.length() && Character.isWhitespace(string.charAt(n2 - 1)) && n2 > n) {
                    --n2;
                }
                while (enumeration.hasMoreElements()) {
                    ParseNode parseNode = (ParseNode)enumeration.nextElement();
                    if (n != parseNode.getReplaceOffset() || n2 != parseNode.getReplaceEnd()) continue;
                    return parseNode;
                }
            }
        }
        return null;
    }

    @Override
    public void addReservedWord(String string) {
        if (this.visitor != null) {
            this.visitor.addReservedWord(string);
        }
    }

    @Override
    public boolean parseSyntax(String string, ParseNode parseNode) {
        String string2 = this.syntax;
        boolean bl = this.isValid;
        LinkedList<Integer> linkedList = this.tokenBoundaries;
        this.syntax = string;
        List<Throwable> list = this.currentExceptions;
        this.currentExceptions = new LinkedList<Throwable>();
        ParseNode parseNode2 = this.root;
        boolean bl2 = this.parseSyntax(parseNode);
        for (Throwable throwable : this.currentExceptions) {
            if (throwable instanceof ParseException) continue;
            LOG.log(Level.WARNING, throwable.getMessage(), this.currentExceptions);
        }
        this.syntax = string2;
        this.currentExceptions = list;
        this.isValid = bl;
        this.tokenBoundaries = linkedList;
        this.root = parseNode2;
        return bl2;
    }

    @Override
    public boolean parseSyntax(ParseNode parseNode) {
        this.currentExceptions.clear();
        this.currentAVHierarchiesReferenced = new HashSet<AVHierarchy>();
        boolean bl = true;
        this.namesValid = true;
        this.isValid = false;
        Object var3_3 = null;
        SyntaxObject syntaxObject = null;
        if (parseNode == null) {
            parseNode = new ParseNode();
        }
        this.root = parseNode;
        try {
            if (this.visitor != null) {
                this.visitor.setSyntax(this.syntax);
            }
            this.tokenBoundaries = this.tokenize(this.syntax, this.visitor, new LinkedList<Integer>());
            if (this.syntax == null || this.syntax.trim().length() == 0) {
                return true;
            }
            if (this.visitor != null) {
                syntaxObject = SyntaxObject.fromSyntax(this.syntax, null, null);
            }
            if (var3_3 != null || syntaxObject != null) {
                parseNode.removeAllChildren();
                if (this.visitor != null) {
                    syntaxObject.visit(this.visitor, parseNode);
                    this.namesValid = this.visitor.getBadNames().size() == 0;
                    this.currentExceptions.addAll(this.visitor.getBadNames());
                    this.currentAVHierarchiesReferenced.addAll(this.visitor.getAVHierarchiesInExpression());
                }
            } else {
                bl = false;
            }
        }
        catch (Throwable throwable) {
            this.currentExceptions.add(throwable);
            bl = false;
        }
        if (!bl) {
            this.root = null;
            if (parseNode != null) {
                parseNode.removeAllChildren();
            }
        }
        this.isValid = bl;
        return this.isValid;
    }

    @Override
    public boolean isObjectNamesValid() {
        return this.namesValid;
    }

    @Override
    public String formatSyntax(String string) {
        if (string == null) {
            string = this.syntax;
        }
        this.formatter.setProps(this.props);
        this.formatter.clear();
        this.visitor.setSyntax(string);
        this.tokenize(string, this.formatter, null);
        String string2 = this.formatter.getFormattedSyntax();
        String string3 = string;
        try {
            string3 = string2;
            SyntaxObject syntaxObject = SyntaxObject.fromSyntax(string, null, null);
            string3 = string;
            SyntaxObject syntaxObject2 = SyntaxObject.fromSyntax(string2, null, null);
            String string4 = syntaxObject.toSyntax();
            String string5 = syntaxObject2.toSyntax();
            if (string4.equals(string5)) {
                string3 = string2;
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, throwable.getMessage(), throwable);
        }
        if (!string3.equals(string)) {
            string3 = this.formatSyntax(string3);
        }
        return string3;
    }

    @Override
    public void tokenize(SyntaxTokenListener syntaxTokenListener) {
        this.tokenize(this.syntax, syntaxTokenListener, new LinkedList<Integer>());
    }

    @Override
    public void setSyntax(String string) {
        this.syntax = string == null ? "" : string;
        if (this.visitor != null) {
            this.visitor.setSyntax(this.syntax);
        }
    }

    @Override
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public List<Throwable> getExceptions() {
        return this.currentExceptions;
    }

    public Set<AVHierarchy> getAVHierarchiesReferenced() {
        return this.currentAVHierarchiesReferenced;
    }

    @Override
    public void addSyntaxParserStateListener(SyntaxParserStateListener syntaxParserStateListener) {
        this.listeners.add(SyntaxParserStateListener.class, syntaxParserStateListener);
    }

    @Override
    public void removeSyntaxParserStateListener(SyntaxParserStateListener syntaxParserStateListener) {
        this.listeners.remove(SyntaxParserStateListener.class, syntaxParserStateListener);
    }

    public void setSchema(HCSSchema hCSSchema) {
        this.schema = hCSSchema;
        if (this.visitor != null) {
            this.visitor.setSchema(hCSSchema);
        }
    }

    public HCSSchema getSchema() {
        if (this.visitor != null) {
            return this.visitor.getSchema();
        }
        return null;
    }

    private boolean isNumeric(String string) {
        return numeric.matcher(string).matches();
    }

    private HCSSyntaxType getTokenType(String string) {
        if (string.length() == 1) {
            return this.getTokenType(string.charAt(0));
        }
        if (this.isNumeric(string)) {
            return HCSSyntaxType.NUMBER;
        }
        if (functions.contains(string)) {
            return HCSSyntaxType.FUNCTION;
        }
        HCSSyntaxType hCSSyntaxType = null;
        if (this.visitor != null) {
            hCSSyntaxType = this.visitor.calculateType(string);
        }
        if (hCSSyntaxType != HCSSyntaxType.BAD_NAME) {
            return hCSSyntaxType;
        }
        return HCSSyntaxType.DEFAULT;
    }

    private HCSSyntaxType getTokenType(char c) {
        if (operators.indexOf(c) != -1) {
            return HCSSyntaxType.OPERATOR;
        }
        if (c == ')' || c == '(') {
            return HCSSyntaxType.PAREN;
        }
        if (Character.isWhitespace(c)) {
            return HCSSyntaxType.WHITESPACE;
        }
        if (Character.isDigit(c)) {
            return HCSSyntaxType.NUMBER;
        }
        return HCSSyntaxType.DEFAULT;
    }

    protected LinkedList<Integer> tokenize(String string, SyntaxTokenListener syntaxTokenListener, LinkedList<Integer> linkedList) {
        if (string == null) {
            return linkedList;
        }
        Matcher matcher = tokens.matcher(string);
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (matcher.group(i) == null) continue;
                HCSSyntaxType hCSSyntaxType = HCSSyntaxType.DEFAULT;
                String string2 = matcher.group(i);
                switch (i) {
                    case 1: {
                        hCSSyntaxType = HCSSyntaxType.BLOCK_COMMENT;
                        break;
                    }
                    case 2: {
                        hCSSyntaxType = HCSSyntaxType.LINE_COMMENT;
                        break;
                    }
                    case 3: {
                        hCSSyntaxType = HCSSyntaxType.STRING;
                        break;
                    }
                    case 4: {
                        hCSSyntaxType = this.getTokenType(string2);
                        break;
                    }
                    case 5: {
                        hCSSyntaxType = HCSSyntaxType.PAREN;
                        break;
                    }
                    case 6: {
                        hCSSyntaxType = HCSSyntaxType.OPERATOR;
                        break;
                    }
                    case 7: {
                        hCSSyntaxType = HCSSyntaxType.NEWLINE;
                    }
                }
                int n = matcher.start(i);
                if (linkedList != null) {
                    linkedList.add(n);
                    linkedList.add(n + string2.length());
                }
                if (syntaxTokenListener == null) continue;
                this.notifyTokenCallback(syntaxTokenListener, string2, hCSSyntaxType, n);
            }
        }
        return linkedList;
    }

    protected void notifyTokenCallback(SyntaxTokenListener syntaxTokenListener, String string, HCSSyntaxType hCSSyntaxType, int n) {
        syntaxTokenListener.processToken(string, hCSSyntaxType.toString(), n);
    }

    public void setSyntaxTest(SyntaxTest syntaxTest) {
        this.syntaxTest = syntaxTest;
    }

    private void printTokens(String string) {
        Matcher matcher = tokens.matcher(string);
        while (matcher.find()) {
            System.out.println(matcher.group());
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = System.getProperty("user.home");
        String string2 = string == null ? "tokenization.out" : string + "/tokenization.out";
        LogFileHandler logFileHandler = new LogFileHandler();
        LOG.addHandler(logFileHandler);
        LOG.setLevel(Level.ALL);
        String[] stringArray2 = new String[]{"/*block comment*/", "--line comment\n", "'string literal'", "\"schema\".analytic_view.\"measure\"", "(", "+", "\r\n"};
        HCSSyntaxParser hCSSyntaxParser = new HCSSyntaxParser(null, new Properties());
        String[] stringArray3 = stringArray2;
        int n = stringArray3.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray3[i];
            if (tokens.matcher(string3).matches()) {
                LOG.fine(String.format("Test %s matched%n", string3));
                continue;
            }
            LOG.fine(String.format("WARNING! Test %s didn't match%n", string3));
        }
        LOG.fine("\n\n\n");
        for (String string4 : stringArray3 = new String[][]{{"SHARE(SALES_CUBE.SALES OF TIME.CALENDAR TOP)", "SHARE", "(", "SALES_CUBE.SALES", "OF", "TIME.CALENDAR", "TOP", ")"}, {"--percent different from prior period\r\nLAG_VARIANCE_PERCENT(SALES_CUBE.SALES,1) /*654*/OVER HIERARCHY \n(TIME.CALENDAR)", "--percent different from prior period\r\n", "LAG_VARIANCE_PERCENT", "(", "SALES_CUBE.SALES", ",", "1", ")", "/*654*/", "OVER", "HIERARCHY", "\n", "(", "TIME.CALENDAR", ")"}, {"LAG_VARIANCE(\nSUM(SALES_CUBE.SALES) OVER HIERARCHY \n(TIME.CALENDAR  \nBETWEEN UNBOUNDED /*oddly placed block comment*/ PRECEDING AND CURRENT MEMBER \nWITHIN ANCESTOR AT DIMENSION LEVEL --oddly placed inline comment\n TIME.ALL_YEARS)+1,1) OVER HIERARCHY ", "LAG_VARIANCE", "(", "\n", "SUM", "(", "SALES_CUBE.SALES", ")", "OVER", "HIERARCHY", "\n", "(", "TIME.CALENDAR", "\n", "BETWEEN", "UNBOUNDED", "/*oddly placed block comment*/", "PRECEDING", "AND", "CURRENT", "MEMBER", "\n", "WITHIN", "ANCESTOR", "AT", "DIMENSION", "LEVEL", "--oddly placed inline comment\n", "TIME.ALL_YEARS", ")", "+", "1", ",", "1", ")", "OVER", "HIERARCHY"}, {"1 + /*comment*/ 2 + 3 /*second comment*/ + 4", "1", "+", "/*comment*/", "2", "+", "3", "/*second comment*/", "+", "4"}}) {
            Matcher matcher = tokens.matcher(string4[0]);
            LOG.fine(String.format("Test %s has the following tokens:%n", string4[0]));
            boolean bl = true;
            int n2 = 1;
            boolean bl2 = matcher.find();
            while (bl && bl2) {
                LOG.fine(matcher.group());
                LOG.fine(", ");
                bl = n2 < ((String)string4).length ? string4[n2].equals(matcher.group()) : false;
                if (!bl) continue;
                ++n2;
                bl2 = matcher.find();
            }
            LOG.fine("\n");
            if (bl) {
                LOG.fine("The tokens were as expected\n");
            } else if (n2 < ((String)string4).length && bl2) {
                LOG.fine(String.format("WARNING! Token %s should have been %s.%n", matcher.group(), string4[n2]));
            } else if (bl2) {
                LOG.fine(String.format("WARNING! Token %s should NOT have been found.%n", matcher.group()));
            } else if (n2 < ((String)string4).length) {
                LOG.fine(String.format("WARNING! Token %s should have been found.%n", matcher.group()));
            }
            LOG.fine("\n");
        }
        ((Handler)logFileHandler).close();
    }

    @Override
    public void metadataUpdated(HCSSchema hCSSchema) {
        this.setSchema(hCSSchema);
        this.fireStateChange(true);
    }

    @Override
    public void metadataCleared() {
        this.fireStateChange(false);
    }

    private void fireStateChange(boolean bl) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SyntaxParserStateListener.class) continue;
            ((SyntaxParserStateListener)objectArray[i + 1]).stateChanged(bl);
        }
    }

    static {
        functions.add("AVERAGE_RANK");
        functions.add("AVG");
        functions.add("COUNT");
        functions.add("DENSE_RANK");
        functions.add("HIER_ANCESTOR");
        functions.add("HIER_CAPTION");
        functions.add("HIER_CHILD_COUNT");
        functions.add("HIER_DEPTH");
        functions.add("HIER_DESCRIPTION");
        functions.add("HIER_LAG");
        functions.add("HIER_LEAD");
        functions.add("HIER_LEVEL");
        functions.add("HIER_MEMBER_NAME");
        functions.add("HIER_MEMBER_UNIQUE_NAME");
        functions.add("HIER_ORDER");
        functions.add("HIER_PARENT");
        functions.add("HIER_PARENT_LEVEL");
        functions.add("HIER_PARENT_UNIQUE_NAME");
        functions.add("LAG");
        functions.add("LAG_DIFF");
        functions.add("LAG_DIFF_PERCENT");
        functions.add("LEAD");
        functions.add("LEAD_DIFF");
        functions.add("LEAD_DIFF_PERCENT");
        functions.add("MAX");
        functions.add("MIN");
        functions.add("RANK");
        functions.add("ROW_NUMBER");
        functions.add("SHARE_OF");
        functions.add("SUM");
    }
}

