/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.details;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import oracle.hcs.HCSArb;
import oracle.hcs.av.calcs.ReferencesTableModel;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.model.Classification;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.details.AbstractCalculatedMeasureTable;
import oracle.hcs.syntaxbuilder.details.CalculatedMeasureTablePanel;
import oracle.javatools.db.AbstractChildDBObject;

public class CalculatedMeasureClassifications
extends AbstractCalculatedMeasureTable {
    private CalculatedMeasureTablePanel classificationsTable;
    private List<Classification> classifications;
    private static final Logger LOG = Logger.getLogger(AbstractCalculatedMeasureTable.class.getName());

    @Override
    protected CalculatedMeasureTablePanel getCalculatedMeasureTable() {
        this.classifications = this.getMeasureClassifications();
        if (this.classificationsTable == null) {
            this.classificationsTable = new CalculatedMeasureTablePanel(this.classifications, this.getModel()){

                @Override
                protected void populateTable() {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)this.getTable().getModel();
                    if (this.getObjects() != null && !this.getObjects().isEmpty()) {
                        Object[] objectArray = null;
                        for (AbstractChildDBObject abstractChildDBObject : this.getObjects()) {
                            Classification classification = (Classification)abstractChildDBObject;
                            objectArray = new Object[]{classification.getClassificationType(), classification.getValue(), classification.getLanguage()};
                            defaultTableModel.addRow(objectArray);
                        }
                    }
                }

                @Override
                protected void setColumnsSize() {
                    int n = this.getTable().getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(i);
                        tableColumn.setPreferredWidth(150);
                    }
                }
            };
        }
        return this.classificationsTable;
    }

    private ReferencesTableModel getModel() {
        return new ReferencesTableModel(){

            @Override
            protected void addColumns() {
                this.addColumn(HCSArb.getString("MODIFY_OBJECTS_PROPS_CLASSIFICATION_TYPE_COLUMN"));
                this.addColumn(HCSArb.getString("MODIFY_OBJECTS_PROPS_VALUE_COLUMN"));
                this.addColumn(HCSArb.getString("MODIFY_OBJECTS_PROPS_LANGUAGE_COLUMN"));
            }
        };
    }

    private List<Classification> getMeasureClassifications() {
        String string;
        AVCalculatedMeasure aVCalculatedMeasure;
        String string2;
        AnalyticView analyticView;
        ArrayList<Classification> arrayList = new ArrayList<Classification>();
        HCSSchema hCSSchema = null;
        try {
            hCSSchema = this.getSchema();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        if (hCSSchema != null && (analyticView = hCSSchema.findAV(string2 = this.getAVName())) != null && (aVCalculatedMeasure = analyticView.findCalculatedMeasure(string = this.getMeasureName())) != null && aVCalculatedMeasure.getClassifications() != null) {
            arrayList.addAll(Arrays.asList(aVCalculatedMeasure.getClassifications()));
        }
        Collections.sort(arrayList, new Comparator<Classification>(){

            @Override
            public int compare(Classification classification, Classification classification2) {
                return classification.getClassificationType().compareTo(classification2.getClassificationType());
            }
        });
        return arrayList;
    }

    @Override
    protected List<? extends AbstractChildDBObject> getMeasuresList() throws Exception {
        return this.getMeasureClassifications();
    }
}

