/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.language;

import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.hcs.HCSArb;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.parser.plsql.PlsqlTokens;
import oracle.javatools.parser.plsql.SqlKeywords;

public final class HCSStyles {
    public static final String HCS_COMMENT_STYLE = "hcs-comment-style";
    public static final String HCS_KEYWORD_STYLE = "hcs-keyword-style";
    public static final String HCS_IDENTIFIER_STYLE = "hcs-identifier-style";
    public static final String HCS_STRING_STYLE = "hcs-string-style";
    public static final String HCS_NUMBER_STYLE = "hcs-number-style";
    public static final String HCS_BRACE_STYLE = "hcs-brace-style";
    public static final String HCS_OPERATOR_STYLE = "hcs-operator-style";
    public static final String[] STYLE_NAMES = new String[]{"hcs-comment-style", "hcs-keyword-style", "hcs-identifier-style", "hcs-string-style", "hcs-number-style", "hcs-brace-style", "hcs-operator-style"};
    public static BaseStyle HCSPlainStyle;
    public static BaseStyle HCSCommentStyle;
    public static BaseStyle HCSKeywordStyle;
    public static BaseStyle HCSIdentifierStyle;
    public static BaseStyle HCSStringStyle;
    public static BaseStyle HCSNumberStyle;
    public static BaseStyle HCSBraceStyle;
    public static BaseStyle HCSOperatorStyle;

    public HCSStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String string;
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        HCSPlainStyle = builtInStyles.plainStyle;
        HCSCommentStyle = styleRegistry.lookupStyle(HCS_COMMENT_STYLE);
        if (HCSCommentStyle == null) {
            string = HCSArb.getString("HCS_COMMENT_STYLE");
            HCSCommentStyle = styleRegistry.createStyle(HCS_COMMENT_STYLE, string, "base-comment-style");
        }
        if ((HCSStringStyle = styleRegistry.lookupStyle(HCS_STRING_STYLE)) == null) {
            string = HCSArb.getString("HCS_STRING_STYLE");
            HCSStringStyle = styleRegistry.createStyle(HCS_STRING_STYLE, string, "base-string-style");
        }
        if ((HCSKeywordStyle = styleRegistry.lookupStyle(HCS_KEYWORD_STYLE)) == null) {
            string = HCSArb.getString("HCS_KEYWORD_STYLE");
            HCSKeywordStyle = styleRegistry.createStyle(HCS_KEYWORD_STYLE, string, "base-keyword-style");
        }
        if ((HCSIdentifierStyle = styleRegistry.lookupStyle(HCS_IDENTIFIER_STYLE)) == null) {
            string = HCSArb.getString("HCS_IDENTIFIER_STYLE");
            HCSIdentifierStyle = styleRegistry.createStyle(HCS_IDENTIFIER_STYLE, string, "base-identifier-style");
        }
        if ((HCSNumberStyle = styleRegistry.lookupStyle(HCS_NUMBER_STYLE)) == null) {
            string = HCSArb.getString("HCS_NUMBER_STYLE");
            HCSNumberStyle = styleRegistry.createStyle(HCS_NUMBER_STYLE, string, "base-number-style");
        }
        if ((HCSBraceStyle = styleRegistry.lookupStyle(HCS_BRACE_STYLE)) == null) {
            string = HCSArb.getString("HCS_BRACE_STYLE");
            HCSBraceStyle = styleRegistry.createStyle(HCS_BRACE_STYLE, string, "base-brace-style");
        }
        if ((HCSOperatorStyle = styleRegistry.lookupStyle(HCS_OPERATOR_STYLE)) == null) {
            string = HCSArb.getString("HCS_OPERATOR_STYLE");
            HCSOperatorStyle = styleRegistry.createStyle(HCS_OPERATOR_STYLE, string, "base-operator-style");
        }
    }

    public static String highlightSyntax(String string) {
        List list = LexerToken.parse((String)string, (boolean)true);
        StringBuilder stringBuilder = new StringBuilder("<html>");
        for (LexerToken lexerToken : list) {
            if (lexerToken.type == Token.IDENTIFIER && HCSStyles.isKeyword(lexerToken.content)) {
                stringBuilder.append(HCSStyles.sugarcoat(lexerToken.content));
                continue;
            }
            stringBuilder.append(lexerToken.content);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static String sugarcoat(String string) {
        return "<font color=#005577><b>" + string + "</b></font>";
    }

    public static boolean isKeyword(String string) {
        for (String string2 : SqlKeywords.KW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : SqlKeywords.DW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : PlsqlTokens.KW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

