/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.qdr;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.templates.templateview.Member;
import oracle.hcs.templates.templateview.QDRData;

public class QDRTableModel
extends AbstractTableModel {
    static final int HIERARCHY_ALIAS = 0;
    static final int MEMBER = 1;
    static final int HIERARCHY = 2;
    private transient Vector<QDRData> qdr;
    static final String[] COLUMNS = new String[]{HCSArb.get("QDR_SELECTOR_HIERARCHY_ALIAS_COLUMN_TITLE"), HCSArb.get("QDR_SELECTOR_MEMBER_NAMES_TITLE")};

    QDRTableModel(Vector<QDRData> vector) {
        this.qdr = vector;
    }

    @Override
    public int getRowCount() {
        if (this.qdr != null) {
            return this.qdr.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            AVHierarchy aVHierarchy = this.qdr.get(n).getAVHierarchy();
            String string = aVHierarchy.getHierarchyAlias();
            String string2 = aVHierarchy.getHierarchy().getDimensionName();
            return String.format("%s.%s", string2, string);
        }
        if (n2 == 1 && this.qdr.get((int)n).additionalMembers != null) {
            String string = null;
            for (Member member : this.qdr.get((int)n).additionalMembers) {
                String string3 = member.getMemberDescription();
                if (string3 == null) {
                    string3 = member.getMemberKey();
                }
                if (string == null) {
                    string = string3;
                    continue;
                }
                string = string + ", " + string3;
            }
            return string;
        }
        if (n2 == 2) {
            AVHierarchy aVHierarchy = this.qdr.get(n).getAVHierarchy();
            String string = aVHierarchy.getHierarchy().getName();
            return string;
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 1) {
            return;
        }
        boolean bl = false;
        if (object == null) {
            bl = true;
        } else if (object instanceof String) {
            if (((String)object).trim().length() == 0) {
                bl = true;
            } else {
                this.qdr.get(n).setMemberDescription(object.toString());
                this.qdr.get(n).setMemberKey(object.toString());
            }
        } else if (object instanceof QDRData) {
            this.qdr.get(n).setData((QDRData)object);
        }
        if (bl) {
            this.qdr.get(n).setMemberKey(null);
            this.qdr.get(n).setMemberDescription(null);
        }
    }

    public void setRowValue(QDRData qDRData, int n) {
        this.qdr.insertElementAt(qDRData, n);
        this.qdr.remove(n + 1);
        this.fireTableDataChanged();
    }

    public QDRData getRowValue(int n) {
        QDRData qDRData = null;
        qDRData = this.qdr.get(n);
        return qDRData;
    }
}

