/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templatelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.hcs.templates.templatelist.BaseTemplate;
import oracle.hcs.templates.templatelist.Measure;
import oracle.hcs.templates.templatelist.Param;
import oracle.hcs.templates.templatelist.Template;
import oracle.hcs.templates.templatelist.TemplateExpression;
import oracle.hcs.templates.templatelist.TemplateGroup;
import oracle.hcs.util.FeatureMap;

public class TemplateList {
    private String comment;
    private String fileName;
    private String type;
    private String connectionName;
    private List<BaseTemplate> templates = new ArrayList<BaseTemplate>();
    private List<Param> templateParams = new ArrayList<Param>();
    private List<Measure> measures = new ArrayList<Measure>();
    private List<TemplateExpression> expressions = new ArrayList<TemplateExpression>();
    private Set<String> templatesToCheck = new HashSet<String>();
    private static final String RANK = "RANK";

    public TemplateList() {
        this.templatesToCheck.add(RANK);
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void addMeasure(String string, boolean bl) {
        this.measures.add(new Measure(string, bl));
    }

    public void addMeasure(Measure measure) {
        this.measures.add(measure);
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public void removeAllMeasures() {
        this.measures.clear();
    }

    public boolean isMeasureSelected(String string) {
        for (Measure measure : this.measures) {
            if (!measure.getName().equals(string) || !measure.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void addTemplate(Template template) {
        this.templates.add(template);
        template.setTemplateList(this);
    }

    public List<BaseTemplate> getTemplates() {
        return this.templates;
    }

    public void addTemplateGroup(TemplateGroup templateGroup) {
        this.templates.add(templateGroup);
        templateGroup.setTemplateList(this);
    }

    public List<TemplateGroup> getTemplateGroups() {
        ArrayList<TemplateGroup> arrayList = new ArrayList<TemplateGroup>();
        for (BaseTemplate baseTemplate : this.templates) {
            if (!(baseTemplate instanceof TemplateGroup)) continue;
            String string = baseTemplate.getName().toUpperCase();
            if (this.checkTemplate(string)) {
                if (!this.isSupported(string)) continue;
                arrayList.add((TemplateGroup)baseTemplate);
                continue;
            }
            arrayList.add((TemplateGroup)baseTemplate);
        }
        return arrayList;
    }

    private boolean checkTemplate(String string) {
        return this.templatesToCheck.contains(string);
    }

    private boolean isSupported(String string) {
        if (this.connectionName != null) {
            return FeatureMap.getInstance().isSupported(this.connectionName, string);
        }
        return false;
    }

    public List<Template> getTemplatesOnly() {
        ArrayList<Template> arrayList = new ArrayList<Template>();
        for (BaseTemplate baseTemplate : this.templates) {
            if (!(baseTemplate instanceof Template)) continue;
            String string = baseTemplate.getName().toUpperCase();
            if (this.checkTemplate(string)) {
                if (!this.isSupported(string)) continue;
                arrayList.add((Template)baseTemplate);
                continue;
            }
            arrayList.add((Template)baseTemplate);
        }
        return arrayList;
    }

    public void removeAllTemplates() {
        this.templates.clear();
    }

    public void addParam(Param param) {
        this.templateParams.add(param);
    }

    public List<Param> getParams() {
        if (this.templateParams == null) {
            return Collections.emptyList();
        }
        return this.templateParams;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void addTemplateExpression(TemplateExpression templateExpression) {
        this.expressions.add(templateExpression);
    }

    public List<TemplateExpression> getTemplateExpressions() {
        return this.expressions;
    }

    public void setTemplateExpressions(List<TemplateExpression> list) {
        this.expressions = list;
    }

    public String toXML() {
        return this.toXML(true, true);
    }

    public String toXML(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TemplateList>\n");
        if (this.comment != null) {
            stringBuffer.append("  <!--");
            stringBuffer.append(this.comment);
            stringBuffer.append("  -->\n");
        }
        if (bl) {
            for (BaseTemplate object : this.getTemplatesOnly()) {
                stringBuffer.append(object.toXML());
            }
        }
        if (bl2) {
            for (TemplateGroup templateGroup : this.getTemplateGroups()) {
                stringBuffer.append(templateGroup.toXML());
            }
            for (Param param : this.templateParams) {
                stringBuffer.append(param.toXML());
            }
        }
        stringBuffer.append("</TemplateList>\n");
        return stringBuffer.toString();
    }

    public String getMeasureXML() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Measure measure : this.measures) {
            stringBuffer.append(measure.toXML());
        }
        return stringBuffer.toString();
    }

    public TemplateExpression findTemplateExpression(String string) {
        for (TemplateExpression templateExpression : this.expressions) {
            if (!templateExpression.getName().equalsIgnoreCase(string)) continue;
            return templateExpression;
        }
        return null;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getConnectionName() {
        return this.connectionName;
    }
}

