/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.MetadataUpdateListener;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.templates.templateview.TemplateMetadata;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class TemplateContext
implements MetadataUpdateListener {
    private HCSSchema schema;
    private DBObjectProvider provider;
    private AnalyticView analyticView;
    private AttributeDimension baseDimension;
    private AttributeDimension timeDimension;
    private List<AttributeDimension> referenceDimensions;
    private AVDimensionality baseDimensionality;
    private TemplateMetadata templateMetadata;

    public TemplateContext() {
    }

    public TemplateContext(TemplateMetadata templateMetadata, DBObjectProvider dBObjectProvider) throws SQLException, IOException {
        this.templateMetadata = templateMetadata;
        this.provider = dBObjectProvider;
        this.referenceDimensions = new ArrayList<AttributeDimension>();
        if (templateMetadata.getBaseDimension() != null) {
            String string;
            if (templateMetadata.getTimeDimension() != null) {
                this.schema = templateMetadata.getSchema();
                string = templateMetadata.getTimeDimension().getName();
                this.timeDimension = this.schema.findDimension(string);
            } else {
                this.schema = templateMetadata.getSchema();
            }
            string = templateMetadata.getBaseDimension().getName();
            this.baseDimension = this.schema.findDimension(string);
            this.baseDimensionality = templateMetadata.getBaseDimensionality();
            if (this.baseDimension == null) {
                this.loadSchema();
                this.baseDimension = this.schema.findDimension(string);
            }
            List<Object> list = new ArrayList();
            list = templateMetadata.getReferenceDimensions();
            AttributeDimension attributeDimension = null;
            if (list != null) {
                for (AttributeDimension attributeDimension2 : list) {
                    string = attributeDimension2.getName();
                    attributeDimension = this.schema.findDimension(string);
                    this.referenceDimensions.add(attributeDimension);
                }
            }
        } else {
            this.schema = templateMetadata.getSchema();
            String string = templateMetadata.getAV().getName();
            this.analyticView = this.schema.findAV(string);
            if (this.analyticView == null) {
                this.loadSchema();
                this.analyticView = this.schema.findAV(string);
            }
            if (templateMetadata.getTimeDimension() != null) {
                this.timeDimension = this.schema.findDimension(templateMetadata.getTimeDimension().getName());
            }
        }
        HCSMetadataCache.addUpdateListener(Connections.getInstance().getConnectionName((Database)((OracleDatabaseImpl)dBObjectProvider)), this.schema.getName(), this);
    }

    public void reinitialize(TemplateMetadata templateMetadata) {
        this.templateMetadata = templateMetadata;
        if (this.templateMetadata.getBaseDimension() != null) {
            List<AttributeDimension> list;
            this.schema = this.templateMetadata.getSchema();
            String string = this.templateMetadata.getBaseDimension().getName();
            this.baseDimension = this.schema.findDimension(string);
            if (this.templateMetadata.getTimeDimension() != null) {
                list = this.templateMetadata.getTimeDimension().getName();
                this.timeDimension = this.schema.findDimension((String)((Object)list));
            }
            list = new ArrayList();
            list = this.templateMetadata.getReferenceDimensions();
            AttributeDimension attributeDimension = null;
            if (list != null) {
                for (AttributeDimension attributeDimension2 : list) {
                    string = attributeDimension2.getName();
                    attributeDimension = this.schema.findDimension(string);
                    this.referenceDimensions.add(attributeDimension);
                }
            }
        } else if (this.templateMetadata.isAV()) {
            this.schema = this.templateMetadata.getSchema();
            String string = this.templateMetadata.getAV().getName();
            this.analyticView = this.schema.findAV(string);
            if (this.templateMetadata.getTimeDimension() != null) {
                String string2 = this.templateMetadata.getTimeDimension().getName();
                this.timeDimension = this.schema.findDimension(string2);
            }
        }
    }

    public DBObjectProvider getProvider() {
        return this.provider;
    }

    public AnalyticView getAV() {
        return this.analyticView;
    }

    public void setAV(AnalyticView analyticView) {
        this.analyticView = analyticView;
    }

    public Set<AVHierarchy> getPreselectedAVHierarchies() {
        return this.templateMetadata.getPreselectedAVHierarchies();
    }

    public AttributeDimension getTimeDimension() {
        return this.timeDimension;
    }

    public AttributeDimension getBaseDimension() {
        return this.baseDimension;
    }

    public AVDimensionality getBaseDimensionality() {
        return this.baseDimensionality;
    }

    public List<AttributeDimension> getReferenceDimensions() {
        return this.referenceDimensions;
    }

    public AVHierarchy getAVHierarchy() {
        return this.templateMetadata.getAVHierarchy();
    }

    public List<AttributeDimension> getDimensions() {
        ArrayList<AttributeDimension> arrayList = new ArrayList<AttributeDimension>();
        AnalyticView analyticView = this.templateMetadata.getAV();
        if (analyticView == null) {
            arrayList.add(this.templateMetadata.getBaseDimension());
        }
        return arrayList;
    }

    public HCSSchema getSchema() {
        return this.schema;
    }

    public TemplateMetadata getTemplateMetadata() {
        return this.templateMetadata;
    }

    public void setTemplateMetadata(TemplateMetadata templateMetadata) {
        this.templateMetadata = templateMetadata;
    }

    private void loadSchema() throws SQLException, IOException {
        try {
            Connections.getInstance();
            this.schema = HCSMetadataCache.getUpdatedSchema(Connections.getActiveConnectionName(), this.schema.getName());
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public boolean isAV() {
        return this.templateMetadata.isAV();
    }

    @Override
    public void metadataUpdated(HCSSchema hCSSchema) {
        this.schema = hCSSchema;
        this.reinitialize(this.templateMetadata);
    }

    @Override
    public void metadataCleared() {
    }
}

