/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;

public class TemplateMetadata {
    private AnalyticView analyticView;
    private AttributeDimension baseDimension;
    private AttributeDimension timeDimension;
    private List<AttributeDimension> refDimensions;
    private AVDimensionality baseDimensionality;
    private AVHierarchy analyticViewHier;
    private HCSSchema schema;
    private Set<AVHierarchy> preselectedAVHierarchies;

    public TemplateMetadata(HCSSchema hCSSchema, AttributeDimension attributeDimension) {
        this.schema = hCSSchema;
        this.baseDimension = attributeDimension;
        if (attributeDimension.isTime()) {
            this.timeDimension = attributeDimension;
        }
    }

    public TemplateMetadata(HCSSchema hCSSchema, AVDimensionality aVDimensionality) {
        this.schema = hCSSchema;
        this.baseDimension = aVDimensionality.getDimension();
        if (aVDimensionality.getDimension().isTime()) {
            this.timeDimension = aVDimensionality.getDimension();
        }
        this.baseDimensionality = aVDimensionality;
    }

    public TemplateMetadata(HCSSchema hCSSchema, AVHierarchy aVHierarchy) {
        this.schema = hCSSchema;
        this.baseDimensionality = (AVDimensionality)aVHierarchy.getParent();
        this.analyticViewHier = aVHierarchy;
        Hierarchy hierarchy = aVHierarchy.getHierarchy();
        AttributeDimension attributeDimension = null;
        if (hierarchy != null) {
            this.baseDimension = attributeDimension = hierarchy.getDimension();
        }
        if (this.baseDimensionality.getDimension().isTime()) {
            this.timeDimension = this.baseDimensionality.getDimension();
        }
    }

    public TemplateMetadata(HCSSchema hCSSchema, AnalyticView analyticView) {
        this(hCSSchema, analyticView, null);
    }

    public TemplateMetadata(HCSSchema hCSSchema, AnalyticView analyticView, Set<AVHierarchy> set) {
        this.schema = hCSSchema;
        this.refDimensions = new ArrayList<AttributeDimension>();
        if (analyticView != null) {
            this.analyticView = analyticView;
            this.timeDimension = this.findTimeDimension(analyticView);
        }
        if (set == null) {
            set = new HashSet<AVHierarchy>();
        }
        this.preselectedAVHierarchies = set;
    }

    public AnalyticView getAV() {
        return this.analyticView;
    }

    public void setAV(AnalyticView analyticView) {
        this.analyticView = analyticView;
    }

    public boolean isAV() {
        return this.analyticView != null;
    }

    public Set<AVHierarchy> getPreselectedAVHierarchies() {
        return this.preselectedAVHierarchies;
    }

    public AttributeDimension getBaseDimension() {
        return this.baseDimension;
    }

    public List<AttributeDimension> getReferenceDimensions() {
        return this.refDimensions;
    }

    public AttributeDimension getTimeDimension() {
        return this.timeDimension;
    }

    public HCSSchema getSchema() {
        return this.schema;
    }

    private AttributeDimension findTimeDimension(AnalyticView analyticView) {
        for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
            String string = aVDimensionality.getName();
            HCSSchema hCSSchema = (HCSSchema)analyticView.getSchema();
            AttributeDimension attributeDimension = hCSSchema.findDimension(string);
            if (attributeDimension == null || !attributeDimension.isTime()) continue;
            return attributeDimension;
        }
        return null;
    }

    private AttributeDimension findTimeDimension(List<AttributeDimension> list) {
        for (AttributeDimension attributeDimension : list) {
            if (!attributeDimension.isTime()) continue;
            return attributeDimension;
        }
        return null;
    }

    public AVDimensionality getBaseDimensionality() {
        return this.baseDimensionality;
    }

    public AVHierarchy getAVHierarchy() {
        return this.analyticViewHier;
    }
}

