/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.tree.loader;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.hcs.tree.loader.TreeLoader;
import oracle.hcs.tree.model.DefaultNode;
import oracle.hcs.tree.model.NodeXMLData;
import oracle.hcs.tree.model.Tree;
import oracle.hcs.tree.model.TreeTable;
import oracle.hcs.tree.xmleditor.NodeFold;
import oracle.hcs.tree.xmleditor.NodeHide;
import oracle.hcs.tree.xmleditor.NodeLabel;
import oracle.hcs.tree.xmleditor.XMLEditor;
import oracle.hcs.util.HCSResources;
import oracle.hcs.util.JavaXMLBind;
import oracle.hcs.util.Resources;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TreeLoaderXML
extends TreeLoader {
    private XMLEditor xmlEditor;
    private Document doc;
    private Resources resources;
    private List<String> columns;
    private String translationKey;
    private StringBuffer sb;
    private int depth;
    private List<String> nodeNameList;

    public TreeLoaderXML(String string) throws Exception {
        this(string, null, null);
    }

    public TreeLoaderXML(String string, Class clazz, String string2, List<String> list) throws Exception {
        super(new TreeTable(NodeXMLData.class));
        Object object;
        String string3;
        if (clazz != null) {
            string3 = JavaXMLBind.LoadDocument(clazz, string2);
            object = "oracle.hcs.tree.xmleditor";
            JavaXMLBind.BindToJavaStr(string3, (String)object, this);
        }
        this.columns = list;
        this.resources = new HCSResources(string2);
        this.translationKey = string2.substring(string2.lastIndexOf("/") + 1);
        string3 = new DOMParser();
        object = new StringReader(string);
        string3.parse((Reader)object);
        this.doc = string3.getDocument();
        this.init(this.doc);
    }

    public TreeLoaderXML(String string, Class clazz, String string2) throws Exception {
        this(string, clazz, string2, Collections.EMPTY_LIST);
    }

    public Document getDocument() {
        return this.doc;
    }

    public TreeLoaderXML(Document document) {
        super(new TreeTable(NodeXMLData.class));
        this.init(document);
    }

    private void init(Document document) {
        this.initColumns();
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.loadNode(nodeList.item(i), null);
        }
    }

    private void initColumns() {
        if (this.columns != null && !this.columns.isEmpty()) {
            for (String string : this.columns) {
                this.addColumn(string);
            }
        }
    }

    public void addColumn(String string) {
        if (this.getTree() instanceof TreeTable) {
            TreeTable treeTable = (TreeTable)this.getTree();
            treeTable.addColumn(string);
        }
    }

    public void addXMLEditor(XMLEditor xMLEditor) {
        this.xmlEditor = xMLEditor;
    }

    protected XMLEditor getXMLEditor() {
        return this.xmlEditor;
    }

    protected Resources getResources() {
        return this.resources;
    }

    /*
     * WARNING - void declaration
     */
    protected void loadNode(Node node, oracle.hcs.tree.model.Node node2) {
        void var7_16;
        if (node instanceof XMLText) {
            XMLText xMLText = (XMLText)node;
            String string = xMLText.getData();
            return;
        }
        String string = TreeLoaderXML.getNodePath(node);
        oracle.hcs.tree.model.Node node3 = node2;
        boolean bl = false;
        if (this.xmlEditor != null) {
            for (NodeFold object2 : this.xmlEditor.getNodeFolds()) {
                NamedNodeMap namedNodeMap;
                if (!object2.getTo().equals(string) || (namedNodeMap = node.getAttributes()) == null) continue;
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node4 = namedNodeMap.item(i);
                    String string2 = node4.getNodeName();
                    if (!object2.getNode().equals(string + "/" + string2)) continue;
                    String string3 = node4.getNodeValue();
                    if (string2.endsWith("/name")) {
                        string3 = "";
                    }
                    String string4 = string + "/" + string2;
                    NodeXMLData nodeXMLData = new NodeXMLData(string4, string3);
                    node3 = new DefaultNode(this.getTree(), node2, nodeXMLData);
                    if (node2 == null) {
                        this.getTree().addRoot(node3);
                    }
                    String string5 = this.getDisplayName(node4);
                    nodeXMLData.setDisplayName(this.resources.getXLIFFResource(this.translationKey, string5));
                    node2 = node3;
                    bl = true;
                }
            }
        }
        if (!bl) {
            boolean bl2 = false;
            if (this.xmlEditor != null) {
                for (NodeHide nodeHide : this.xmlEditor.getNodeHides()) {
                    if (!nodeHide.getNode().equals(string)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                String string6 = node.getNodeName();
                NodeXMLData nodeXMLData = new NodeXMLData(string6);
                node3 = new DefaultNode(this.getTree(), node2, nodeXMLData);
                if (node2 == null) {
                    this.getTree().addRoot(node3);
                }
                String string7 = this.getDisplayName(node);
                nodeXMLData.setDisplayName(this.resources.getXLIFFResource(this.translationKey, string7));
            }
        }
        this.loadNodeAttributes(node, node3);
        NodeList nodeList = node.getChildNodes();
        boolean bl2 = false;
        while (var7_16 < nodeList.getLength()) {
            this.loadNode(nodeList.item((int)var7_16), node3);
            ++var7_16;
        }
    }

    protected void loadNodeAttributes(Node node, oracle.hcs.tree.model.Node node2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = node.getNodeName();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node3 = namedNodeMap.item(i);
                String string2 = node3.getNodeName();
                String string3 = TreeLoaderXML.getNodePath(node3);
                if (this.xmlEditor != null) {
                    boolean bl = false;
                    for (NodeFold nodeFold : this.xmlEditor.getNodeFolds()) {
                        if (!nodeFold.getNode().equals(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                }
                String string4 = node3.getNodeValue();
                NodeXMLData nodeXMLData = (NodeXMLData)node2.getUserObject();
                if (!nodeXMLData.getName().equals(string)) {
                    string2 = string + "/" + string2;
                }
                NodeXMLData nodeXMLData2 = new NodeXMLData(string2, string4);
                DefaultNode defaultNode = new DefaultNode(this.getTree(), node2, nodeXMLData2);
                String string5 = this.getDisplayName(node3);
                nodeXMLData2.setDisplayName(this.resources.getXLIFFResource(this.translationKey, string5));
            }
        }
    }

    protected String getTranslationKey() {
        return this.translationKey;
    }

    protected String getDisplayName(Node node) {
        String string = TreeLoaderXML.getNodePath(node);
        if (this.xmlEditor != null) {
            for (NodeLabel nodeLabel : this.xmlEditor.getNodeLabels()) {
                if (!nodeLabel.getNode().equals(string)) continue;
                if (string.endsWith("/name")) {
                    return node.getNodeValue();
                }
                return nodeLabel.getLabel();
            }
        }
        return node.getNodeName();
    }

    public List<String> getNodePath(oracle.hcs.tree.model.Node node) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        while (node != null) {
            NodeXMLData nodeXMLData = (NodeXMLData)node.getUserObject();
            String string = nodeXMLData.getData(0).toString();
            for (NodeFold nodeFold : this.xmlEditor.getNodeFolds()) {
                if (!nodeFold.getNode().equals(string)) continue;
                arrayList.add(string + "=" + nodeXMLData.getData(1).toString());
                string = nodeFold.getTo();
                break;
            }
            if (!stringBuffer.toString().startsWith("/" + string)) {
                stringBuffer.insert(0, string);
                if (stringBuffer.toString().equals(string)) {
                    stringBuffer.append("=" + nodeXMLData.getData(1).toString());
                }
                if (stringBuffer.charAt(0) != '/') {
                    stringBuffer.insert(0, "/");
                }
            }
            node = node.getParent();
        }
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    protected static String getNodePath(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        while (node != null && !(node instanceof XMLDocument)) {
            stringBuffer.insert(0, node.getNodeName());
            stringBuffer.insert(0, "/");
            if (node instanceof XMLAttr) {
                XMLAttr xMLAttr = (XMLAttr)node;
                node = xMLAttr.getOwnerElement();
                continue;
            }
            node = node.getParentNode();
        }
        return stringBuffer.toString();
    }

    protected StringBuffer getXMLBuffer() {
        return this.sb;
    }

    protected void setXMLBuffer(StringBuffer stringBuffer) {
        this.sb = stringBuffer;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected void setDepth(int n) {
        this.depth = n;
    }

    protected List<String> getNodeNameList() {
        return this.nodeNameList;
    }

    public String generateXML() {
        this.sb = new StringBuffer();
        this.depth = 0;
        this.nodeNameList = new ArrayList<String>();
        this.sb.append("<?xml version=\"1.0\" encoding=\"windows-1252\" ?>\n");
        Tree tree = this.getTree();
        for (oracle.hcs.tree.model.Node node : tree.getRoots()) {
            this.generateXML(node, tree);
        }
        for (int i = 0; i < this.nodeNameList.size(); ++i) {
            this.sb.append("</" + this.nodeNameList.get(i) + ">\n");
        }
        return this.sb.toString();
    }

    protected void generateXML(oracle.hcs.tree.model.Node node, Tree tree) {
        String string;
        int n;
        Object object;
        NodeXMLData nodeXMLData = (NodeXMLData)node.getUserObject();
        if (!nodeXMLData.isAttribute()) {
            TreeLoaderXML.append(this.sb, " ", this.depth);
            this.sb.append("<" + nodeXMLData.getName() + ">\n");
            this.nodeNameList.add(nodeXMLData.getName());
        } else {
            boolean bl = this.unfold(node, true);
            if (!bl) {
                object = nodeXMLData.getData(0).toString();
                n = ((String)object).indexOf("/");
                if (n != -1) {
                    ++this.depth;
                    string = ((String)object).substring(0, n);
                    object = nodeXMLData.getName().substring(n + 1, ((String)object).length());
                    TreeLoaderXML.append(this.sb, " ", this.depth);
                    String string2 = TreeLoaderXML.getLastNodeName(this.sb);
                    if (!string.equals(string2)) {
                        this.sb.append("<" + string + ">\n");
                        this.nodeNameList.add(string);
                    } else {
                        String string3 = "</" + string2 + ">";
                        if (this.sb.toString().trim().endsWith(string3)) {
                            this.sb = new StringBuffer(this.sb.toString().trim());
                            this.sb.delete(this.sb.length() - string3.length(), this.sb.length());
                            this.sb = new StringBuffer(this.sb.toString().trim());
                            this.sb.append("\n");
                            this.nodeNameList.remove(string2);
                        }
                    }
                }
                this.sb.delete(this.sb.length() - 2, this.sb.length());
                string = nodeXMLData.getData(1).toString();
                this.sb.append(" " + (String)object + "=\"" + string + "\">\n");
            }
        }
        List<oracle.hcs.tree.model.Node> list = node.getChildren();
        object = list.iterator();
        while (object.hasNext()) {
            oracle.hcs.tree.model.Node node2 = (oracle.hcs.tree.model.Node)object.next();
            ++this.depth;
            this.generateXML(node2, tree);
            --this.depth;
        }
        if (!nodeXMLData.isAttribute()) {
            TreeLoaderXML.append(this.sb, " ", this.depth);
            this.sb.append("</" + nodeXMLData.getName() + ">\n");
            this.nodeNameList.remove(nodeXMLData.getName());
        } else if (!this.unfold(node, false) && (n = ((String)(object = nodeXMLData.getData(0).toString())).indexOf("/")) != -1) {
            string = nodeXMLData.getName().substring(0, n);
            TreeLoaderXML.append(this.sb, " ", this.depth);
            this.sb.append("</" + string + ">\n");
            this.nodeNameList.remove(string);
            --this.depth;
        }
    }

    protected static void append(StringBuffer stringBuffer, String string, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
    }

    protected static String getLastNodeName(StringBuffer stringBuffer) {
        String string = "";
        int n = stringBuffer.toString().lastIndexOf("<");
        string = stringBuffer.substring(n + 1, stringBuffer.length());
        if ((n = string.indexOf(" ")) != -1) {
            string = string.substring(0, n - 1);
        }
        if (string.endsWith(">")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    protected boolean unfold(oracle.hcs.tree.model.Node node, boolean bl) {
        NodeXMLData nodeXMLData = (NodeXMLData)node.getUserObject();
        if (this.xmlEditor != null) {
            String string = nodeXMLData.getData(0).toString();
            for (NodeFold nodeFold : this.xmlEditor.getNodeFolds()) {
                if (!nodeFold.getNode().equals(string)) continue;
                String string2 = this.getLeafNodeName(string);
                if (bl) {
                    TreeLoaderXML.append(this.sb, " ", this.depth);
                    this.sb.append("<" + string2);
                    String string3 = nodeXMLData.getData(1).toString();
                    String string4 = TreeLoaderXML.getLeafAttributeName(string);
                    this.sb.append(" " + string4 + "=\"" + string3 + "\">\n");
                    this.nodeNameList.add(string2);
                } else {
                    this.sb.append("</" + string2 + ">\n");
                    this.nodeNameList.remove(string2);
                }
                return true;
            }
        }
        return false;
    }

    protected String getLeafNodeName(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        String[] stringArray = string.split("/");
        for (int i = 0; i < stringArray.length - 2; ++i) {
            if (i < this.nodeNameList.size() && stringArray[i].equals(this.nodeNameList.get(i))) continue;
            this.sb.append("<" + stringArray[i] + ">\n");
            this.nodeNameList.add(i, stringArray[i]);
            ++this.depth;
        }
        if (stringArray.length > 2) {
            return stringArray[stringArray.length - 2];
        }
        return string;
    }

    protected static String getLeafAttributeName(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length > 1) {
            return stringArray[stringArray.length - 1];
        }
        return string;
    }
}

