/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.hover;

import java.awt.AWTEvent;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverListener;

public final class AutoHideHover {
    private Hover hover;
    private boolean keyHide = false;
    private AutoHideMouseListener listener = new AutoHideMouseListener();

    private AutoHideHover(Hover hover, boolean keyHide) {
        assert (hover != null);
        this.hover = hover;
        this.keyHide = keyHide;
        hover.addHoverListener(this.listener);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 40L);
    }

    private void hideHover() {
        if (this.hover != null) {
            this.hover.hideHover();
        }
    }

    private void cleanUp() {
        this.hover.removeHoverListener(this.listener);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
        this.hover = null;
        this.listener = null;
    }

    public static void autoHide(Hover hover) {
        new AutoHideHover(hover, false);
    }

    public static void autoHide(Hover hover, boolean hideOnKey) {
        new AutoHideHover(hover, hideOnKey);
    }

    private class AutoHideMouseListener
    implements AWTEventListener,
    HoverListener {
        private AutoHideMouseListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (pointerInfo == null) {
                    AutoHideHover.this.hideHover();
                    return;
                }
                Point p = pointerInfo.getLocation();
                if (p == null) {
                    AutoHideHover.this.hideHover();
                    return;
                }
                if (!AutoHideHover.this.hover.isPointWithinHover(new Point(p))) {
                    AutoHideHover.this.hideHover();
                }
            } else if (event instanceof KeyEvent && AutoHideHover.this.keyHide) {
                KeyEvent keyEvent = (KeyEvent)event;
                if (keyEvent.getID() == 401 && (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 65406 || keyEvent.getKeyCode() == 157)) {
                    return;
                }
                AutoHideHover.this.hideHover();
                return;
            }
        }

        @Override
        public void hoverChange(HoverEvent he) {
            if (he.isHidden()) {
                AutoHideHover.this.cleanUp();
            }
        }
    }
}

