/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

public class GITUser
implements Comparable {
    private String holder = "%s <%s>";
    private String _name;
    private String _email;

    public GITUser(String name) {
        this._name = name;
    }

    public GITUser(String name, String email) {
        this(name);
        this._email = email;
    }

    public void setEmail(String email) {
        this._email = email;
    }

    public String getName() {
        return this._name;
    }

    public String getEmail() {
        if (this._email == null) {
            this._email = "";
        }
        return this._email;
    }

    public String toString() {
        if (this._email == null) {
            return this._name;
        }
        return String.format(this.holder, this._name, this._email);
    }

    public static GITUser parseUserEmail(String item) {
        if (item.contains("<") && item.contains(">")) {
            int left = item.indexOf("<");
            int right = item.indexOf(">", left);
            if (left == -1 || right == -1) {
                return new GITUser(item);
            }
            String name = item.substring(0, left).trim();
            String email = item.substring(left + 1, right).trim();
            GITUser user = new GITUser(name);
            user.setEmail(email);
            return user;
        }
        return new GITUser(item);
    }

    public int compareTo(Object o) {
        if (!(o instanceof GITUser)) {
            return -1;
        }
        if (!this._name.equals(((GITUser)o).getName())) {
            return this._name.compareTo(((GITUser)o).getName());
        }
        return this._email.compareTo(((GITUser)o).getEmail());
    }

    public boolean equals(Object o) {
        if (!(o instanceof GITUser)) {
            return false;
        }
        if (this._email == null && ((GITUser)o).getEmail() == null) {
            return this._name.equals(((GITUser)o).getName());
        }
        if (this._email == null && ((GITUser)o).getEmail() != null || this._email != null && ((GITUser)o).getEmail() == null) {
            return false;
        }
        return this._name.equals(((GITUser)o).getName()) && this._email.equals(((GITUser)o).getEmail());
    }
}

