/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.util.VCSStreamUtils;
import oracle.jdevimpl.vcs.git.GITHistoryEntryProducer;
import oracle.jdevimpl.vcs.git.GITVersionURL;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.util.browser.DefaultBrowsable;

public class GITVersionBrowsable
extends DefaultBrowsable {
    public GITVersionBrowsable() {
    }

    public GITVersionBrowsable(URL url) {
        super(url);
    }

    public void writeFileContents(OutputStream outputStream) throws IOException {
        GITVersionURL versionUrl = new GITVersionURL(this.getURL());
        try {
            VCSStreamUtils.pipeStreamData((InputStream)GITHistoryEntryProducer.openInputStream(versionUrl.getPath(), versionUrl.getVersion()), (OutputStream)outputStream);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    protected boolean isTrackedInNodeCache() {
        return false;
    }

    public String getToolTipText() {
        return null;
    }

    public String getShortLabel() {
        return MessageFormat.format(Resource.get("VERSION_BROWSABLE_LABEL"), URLFileSystem.getFileName((URL)this.getURL()), new GITVersionURL(this.getURL()).getVersion());
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public boolean isReadOnly() {
        return true;
    }
}

